/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.ArrayPoolsKt;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.JsonTreeDecoder;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a5\u0010\b\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"readJson", "T", "Lkotlinx/serialization/json/Json;", "element", "Lkotlinx/serialization/json/JsonElement;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonElement;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "readPolymorphicJson", "discriminator", "", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/Json;Ljava/lang/String;Lkotlinx/serialization/json/JsonObject;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nArrayPools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayPools.kt\nkotlinx/serialization/json/internal/CharArrayPoolBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public class WriteModeKt {
    private final ArrayDeque<char[]> arrays = new ArrayDeque();
    private int charsTotal;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final WriteMode switchMode(Json $this$switchMode, SerialDescriptor desc) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter((Object)$this$switchMode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        SerialKind serialKind = desc.getKind();
        if (serialKind instanceof PolymorphicKind) {
            return WriteMode.POLY_OBJ;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            return WriteMode.LIST;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            Json $this$selectMapMode$iv;
            SerialDescriptor keyDescriptor$iv = WriteModeKt.carrierDescriptor(desc.getElementDescriptor(0), $this$selectMapMode$iv.getSerializersModule());
            SerialKind keyKind$iv = keyDescriptor$iv.getKind();
            if (keyKind$iv instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
                writeMode = WriteMode.MAP;
                return writeMode;
            } else {
                Json json;
                if (!json.getConfiguration$1775e292().getAllowStructuredMapKeys()) void var1_1;
                throw WriteModeKt.InvalidKeyKindException((SerialDescriptor)var1_1);
                writeMode = WriteMode.LIST;
            }
            return writeMode;
        } else {
            writeMode = WriteMode.OBJ;
        }
        return writeMode;
    }

    /*
     * WARNING - void declaration
     */
    public static final SerialDescriptor carrierDescriptor(SerialDescriptor $this$carrierDescriptor, SerializersModule module) {
        SerialDescriptor serialDescriptor;
        block2: {
            SerialDescriptor serialDescriptor2;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$carrierDescriptor, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                    if (!Intrinsics.areEqual((Object)$this$carrierDescriptor.getKind(), (Object)SerialKind.CONTEXTUAL.INSTANCE)) break block1;
                    serialDescriptor = SerialDescriptor.DefaultImpls.getContextualDescriptor((SerializersModule)module, (SerialDescriptor)$this$carrierDescriptor);
                    if (serialDescriptor != null && (serialDescriptor = WriteModeKt.carrierDescriptor(serialDescriptor, module)) != null) break block2;
                    break block3;
                }
                if ($this$carrierDescriptor.isInline()) {
                    void var1_1;
                    return WriteModeKt.carrierDescriptor($this$carrierDescriptor.getElementDescriptor(0), (SerializersModule)var1_1);
                }
            }
            serialDescriptor = serialDescriptor2;
        }
        return serialDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public static JsonDecodingException JsonDecodingException(int offset, String message) {
        void var1_1;
        int n;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new JsonDecodingException((String)(offset >= 0 ? "Unexpected JSON token at offset " + n + ": " + message : var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static JsonDecodingException JsonDecodingException(int offset, String message, CharSequence input) {
        int n;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return WriteModeKt.JsonDecodingException(offset, (String)var1_1 + "\nJSON input: " + WriteModeKt.minify((CharSequence)var2_2, n));
    }

    /*
     * WARNING - void declaration
     */
    public static JsonEncodingException InvalidFloatingPointEncoded(Number value, String output) {
        Number number;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        boolean bl = true;
        bl = false;
        CharSequence charSequence = (CharSequence)var1_3;
        return new JsonEncodingException("Unexpected special floating-point value " + number + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + WriteModeKt.minify(charSequence, -1));
    }

    /*
     * WARNING - void declaration
     */
    public static Void throwInvalidFloatingPointDecoded(AbstractJsonLexer $this$throwInvalidFloatingPointDecoded, Number result) {
        void var1_1;
        AbstractJsonLexer abstractJsonLexer;
        Intrinsics.checkNotNullParameter((Object)$this$throwInvalidFloatingPointDecoded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        AbstractJsonLexer.fail$default(abstractJsonLexer, "Unexpected special floating-point value " + var1_1 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    public static JsonEncodingException InvalidKeyKindException(SerialDescriptor keyDescriptor) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)keyDescriptor, (String)"keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + serialDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    /*
     * WARNING - void declaration
     */
    public static JsonDecodingException InvalidFloatingPointDecoded(Number value, String key, String output) {
        void var1_3;
        Number number;
        void var2_4;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        boolean bl = true;
        bl = false;
        CharSequence charSequence = (CharSequence)var2_4;
        return WriteModeKt.JsonDecodingException(-1, "Unexpected special floating-point value " + number + " with key " + (String)var1_3 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + WriteModeKt.minify(charSequence, -1));
    }

    /*
     * WARNING - void declaration
     */
    public static JsonDecodingException UnknownKeyException(String key, String input) {
        String string;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean bl = true;
        bl = false;
        CharSequence charSequence = (CharSequence)var1_3;
        return WriteModeKt.JsonDecodingException(-1, "Encountered an unknown key '" + string + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.\nCurrent input: " + WriteModeKt.minify(charSequence, -1));
    }

    /*
     * WARNING - void declaration
     */
    private static CharSequence minify(CharSequence $this$minify, int offset22) {
        CharSequence charSequence;
        void var1_1;
        void var2_4;
        void var3_6;
        int offset22;
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset22 == -1) {
            int start = $this$minify.length() - 60;
            if (start <= 0) {
                return $this$minify;
            }
            CharSequence offset22 = $this$minify;
            int n = offset22.length();
            return "....." + ((Object)offset22.subSequence(start, n)).toString();
        }
        int start = offset22 - 30;
        int end = offset22 + 30;
        String prefix = start <= 0 ? "" : ".....";
        String suffix = end >= $this$minify.length() ? "" : ".....";
        return (String)var3_6 + ((Object)$this$minify.subSequence(RangesKt.coerceAtLeast((int)var2_4, (int)0), RangesKt.coerceAtMost((int)var1_1, (int)charSequence.length()))).toString() + suffix;
    }

    /*
     * WARNING - void declaration
     */
    protected char[] take(int size) {
        char[] cArray;
        Object object = this;
        synchronized (object) {
            char[] cArray2;
            char[] cArray3 = (char[])this.arrays.removeLastOrNull();
            if (cArray3 != null) {
                void var3_5;
                cArray = cArray3;
                char[] it = cArray3;
                this.charsTotal -= ((void)var3_5).length;
                cArray2 = cArray;
            } else {
                cArray2 = null;
            }
            cArray = cArray2;
        }
        object = cArray;
        char[] cArray4 = cArray;
        if (cArray == null) {
            cArray4 = new char[128];
        }
        return cArray4;
    }

    /*
     * WARNING - void declaration
     */
    protected void releaseImpl(char[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        WriteModeKt writeModeKt = this;
        synchronized (writeModeKt) {
            if (this.charsTotal + array.length < ArrayPoolsKt.access$getMAX_CHARS_IN_POOL$p()) {
                void var1_1;
                this.charsTotal += array.length;
                this.arrays.addLast((Object)var1_1);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T readPolymorphicJson(Json $this$readPolymorphicJson, String discriminator, JsonObject element, DeserializationStrategy<? extends T> deserializer) {
        void var3_3;
        void var1_1;
        void var2_2;
        Json json;
        Intrinsics.checkNotNullParameter((Object)$this$readPolymorphicJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)discriminator, (String)"discriminator");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return new JsonTreeDecoder(json, (JsonObject)var2_2, (String)var1_1, deserializer.getDescriptor()).decodeSerializableValue(var3_3);
    }
}

