/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.entity.pet;

import net.herosuits.entity.pet.ai.EntityAIPetFollow;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class EntityPetBase
extends EntityCreature {
    protected EntityPlayer owner;

    public EntityPetBase(World world) {
        super(world);
        this.initAITasks();
    }

    public EntityPetBase(World world, EntityPlayer owner) {
        this(world);
        this.setOwner(owner);
    }

    protected void initAITasks() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPetFollow(this, 0.5, 6.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)String.valueOf(this.getDefaultName()));
        this.field_70180_af.func_75682_a(19, (Object)(this.owner != null ? String.valueOf(this.owner.func_146103_bH().getName()) : ""));
    }

    public String getPetName() {
        return this.field_70180_af.func_75681_e(18);
    }

    public void setPetName(String name) {
        this.field_70180_af.func_75692_b(18, (Object)name);
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.field_70128_L || this.owner == null || this.owner.field_70128_L)) {
            this.field_70180_af.func_75692_b(19, (Object)this.owner.func_146103_bH().getName());
        }
        this.field_70143_R = 0.0f;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.owner == null && player.func_71045_bC() == null) {
            this.setOwner(player);
            return true;
        }
        return super.func_70085_c(player);
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
        this.setOwnerName(player.func_146103_bH().getName());
    }

    public EntityPlayer getOwner() {
        return this.owner;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70094_T() {
        if (this.getOwner() != null) {
            return false;
        }
        return super.func_70094_T();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public boolean func_110164_bC() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public abstract String getDefaultName();
}

