/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.gui;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.herosuits.HeroSuits;
import net.herosuits.catalog.BookPage;
import net.herosuits.catalog.EnchiridionCompatibility;
import net.herosuits.catalog.HeroSuitsCatalogHelper;
import net.herosuits.item.ItemSuitCatalog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.MutablePair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiHeroSuitsCatalog
extends GuiScreen {
    private static final ResourceLocation bookCover = new ResourceLocation("herosuits", "textures/gui/catalogCover.png");
    private static final ResourceLocation bookLeftPage = new ResourceLocation("herosuits", "textures/gui/catalogLeftPage.png");
    private static final ResourceLocation bookRightPage = new ResourceLocation("herosuits", "textures/gui/catalogRightPage.png");
    public static int bookTotalPages = 1;
    public static int currPage = 0;
    public static int lastIndexPage = 0;
    public static String viewing = "";
    private static ItemStack book;
    private static boolean mustReleaseMouse;
    public final EntityPlayer editingPlayer;
    private final ItemStack bookObj;
    public int bookImageWidth = 192;
    public int bookImageHeight = 192;
    private boolean field_146481_r;
    private int updateCount;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private ArrayList<String> categories = new ArrayList();

    public GuiHeroSuitsCatalog(EntityPlayer player, ItemStack itemstack, boolean par3) {
        for (String cat : HeroSuitsCatalogHelper.categories) {
            int pages = 0;
            for (MutablePair<String, String> entry : HeroSuitsCatalogHelper.entry) {
                if (!entry.right.equals(cat) || HeroSuitsCatalogHelper.pageEntries.get(entry.left).length <= 0) continue;
                ++pages;
            }
            for (int s = 0; s < MathHelper.func_76123_f((float)((float)pages / 9.0f)); ++s) {
                this.categories.add(cat + (s == 0 ? "" : Integer.valueOf(s)));
            }
        }
        this.editingPlayer = player;
        this.bookObj = itemstack;
        boolean i = false;
        String lastCategory = "";
        boolean canDo = true;
        bookTotalPages = MathHelper.func_76123_f((float)((float)this.categories.size() / 2.0f)) + 1;
        if (viewing != "") {
            bookTotalPages = MathHelper.func_76123_f((float)((float)HeroSuitsCatalogHelper.pageEntries.get(viewing).length / 2.0f));
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemSuitCatalog) {
            book = player.func_70694_bm();
        } else {
            if (Loader.isModLoaded((String)"Enchiridion")) {
                book = EnchiridionCompatibility.findBook(HeroSuits.itemSuitCatalog, player);
            }
            for (int p = 0; p < player.field_71071_by.func_70302_i_(); ++p) {
                if (player.field_71071_by.func_70301_a(p) == null || !(player.field_71071_by.func_70301_a(p).func_77973_b() instanceof ItemSuitCatalog)) continue;
                book = player.field_71071_by.func_70301_a(p);
                break;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int i = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = (this.field_146295_m - this.bookImageHeight) / 2;
        this.buttonNextPage = new NextPageButton(1, i + 120 + 67 + 18, b0 + 154 + 8, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 38 - 67 - 14, b0 + 154 + 8, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void updateButtons() {
        this.buttonNextPage.field_146125_m = currPage < bookTotalPages - 1;
        this.buttonPreviousPage.field_146125_m = currPage > 0;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (currPage < bookTotalPages - 1) {
                    ++currPage;
                }
            } else if (button.field_146127_k == 2) {
                if (currPage > 0) {
                    --currPage;
                }
            }
            if (button instanceof GuiButtonSelect) {
                GuiButtonSelect buttonSelect = (GuiButtonSelect)button;
                lastIndexPage = currPage;
                viewing = buttonSelect.name.substring(0, 1).equals("#") ? buttonSelect.name.substring(1) : buttonSelect.name;
                currPage = 0;
                bookTotalPages = MathHelper.func_76123_f((float)((float)HeroSuitsCatalogHelper.pageEntries.get(viewing).length / 2.0f));
                this.updateButtons();
                mustReleaseMouse = true;
            }
            this.func_73866_w_();
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            ++bookTotalPages;
            this.field_146481_r = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String func_146456_p() {
        if (this.bookPages == null) return "";
        if (currPage < 0) return "";
        if (currPage >= this.bookPages.func_74745_c()) return "";
        String string = this.bookPages.func_150307_f(currPage);
        return string;
    }

    private void func_146457_a(String p_146457_1_) {
        if (this.bookPages != null) {
            if (currPage >= 0) {
                if (currPage < this.bookPages.func_74745_c()) {
                    this.bookPages.func_150304_a(currPage, (NBTBase)new NBTTagString(p_146457_1_));
                    this.field_146481_r = true;
                }
            }
        }
    }

    private void func_146459_b(String p_146459_1_) {
        String s1 = this.func_146456_p();
        String s2 = s1 + p_146459_1_;
        int i = this.field_146289_q.func_78267_b(s2 + "" + EnumChatFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.func_146457_a(s2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            if (viewing != "") {
                viewing = "";
                currPage = lastIndexPage;
                boolean i = false;
                String lastCategory = "";
                boolean canDo = true;
                bookTotalPages = MathHelper.func_76123_f((float)((float)this.categories.size() / 2.0f)) + 1;
                this.updateButtons();
                return;
            }
        }
        super.func_73869_a(par1, par2);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int d = Mouse.getDWheel();
        if (d < 0 && this.buttonNextPage.field_146125_m) {
            this.func_146284_a(this.buttonNextPage);
        }
        if (d > 0 && this.buttonPreviousPage.field_146125_m) {
            this.func_146284_a(this.buttonPreviousPage);
        }
        if (mustReleaseMouse && !Mouse.isButtonDown((int)0)) {
            mustReleaseMouse = false;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = (this.field_146295_m - this.bookImageHeight) / 2;
        if (currPage == 0 && viewing == "") {
            this.field_146297_k.func_110434_K().func_110577_a(bookCover);
            this.func_73729_b(k + 67, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(bookLeftPage);
            this.func_73729_b(k - 67, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
            this.field_146297_k.func_110434_K().func_110577_a(bookRightPage);
            this.func_73729_b(k + 67, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
        }
        String s = book.func_82833_r();
        int l = this.field_146289_q.func_78256_a(s);
        this.field_146289_q.func_78261_a(s, k + this.bookImageWidth / 2 - l / 2 - 3, b0 - 15, 0xFFFFFF);
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        if (currPage != 0 || viewing != "") {
            Object[] objectArray = new Object[2];
            objectArray[0] = (currPage - 1) * 2 + 4;
            objectArray[1] = bookTotalPages * 2;
            s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])objectArray);
            if (viewing == "") {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = (currPage - 1) * 2 + 2;
                objectArray2[1] = bookTotalPages * 2 - 2;
                s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])objectArray2);
            }
            l = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b("\u00a7l" + s, k - l + this.bookImageWidth - 44 + 67, b0 + 8, 0xFFFFFF);
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = (currPage - 1) * 2 + 3;
            objectArray3[1] = bookTotalPages * 2;
            s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])objectArray3);
            if (viewing == "") {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = (currPage - 1) * 2 + 1;
                objectArray4[1] = bookTotalPages * 2 - 2;
                s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])objectArray4);
            }
            this.field_146289_q.func_78276_b("\u00a7l" + s, k + l - this.bookImageWidth + 54 + 67, b0 + 8, 0xFFFFFF);
        }
        if (viewing == "") {
            if (currPage > 0) {
                String lastCategory = "";
                boolean canDo = true;
                ArrayList thingsToRemove = new ArrayList();
                for (Object button : this.field_146292_n) {
                    if (!(button instanceof GuiButtonSelect)) continue;
                    thingsToRemove.add(button);
                }
                for (Object button : thingsToRemove) {
                    this.field_146292_n.remove(button);
                }
                String category = this.categories.get((currPage - 1) * 2);
                int offset = 0;
                if (category.substring(category.length() - 1, category.length()).matches("-?\\d+")) {
                    offset = 9 * Integer.parseInt(category.substring(category.length() - 1, category.length()));
                    category = category.substring(0, category.length() - 1);
                }
                s = I18n.func_135052_a((String)category, (Object[])new Object[0]);
                int i = 14;
                int offsetCounter = 0;
                this.field_146289_q.func_78276_b("\u00a7n" + s, k + 40 - 67, 24 + b0, 0x3F3F3F);
                for (MutablePair<String, String> entry : HeroSuitsCatalogHelper.entry) {
                    if (!entry.right.equals(category) || HeroSuitsCatalogHelper.pageEntries.get(entry.left).length <= 0 || ++offsetCounter <= offset || offsetCounter >= offset + 10) continue;
                    s = (String)entry.left;
                    this.field_146292_n.add(new GuiButtonSelect(4, k + 50 - 67, b0 + 24 + i, 110, 10, s));
                    i += 14;
                }
                if (this.categories.size() > 1 + (currPage - 1) * 2) {
                    category = this.categories.get((currPage - 1) * 2 + 1);
                    offset = 0;
                    offsetCounter = 0;
                    if (category.substring(category.length() - 1, category.length()).matches("-?\\d+")) {
                        offset = 9 * Integer.parseInt(category.substring(category.length() - 1, category.length()));
                        category = category.substring(0, category.length() - 1);
                    }
                    s = I18n.func_135052_a((String)category, (Object[])new Object[0]);
                    i = 14;
                    this.field_146289_q.func_78276_b("\u00a7n" + s, k + 40 + 67, 24 + b0, 0x3F3F3F);
                    for (MutablePair<String, String> entry : HeroSuitsCatalogHelper.entry) {
                        if (!entry.right.equals(category) || HeroSuitsCatalogHelper.pageEntries.get(entry.left).length <= 0 || ++offsetCounter <= offset || offsetCounter >= offset + 10) continue;
                        s = (String)entry.left;
                        this.field_146292_n.add(new GuiButtonSelect(4, k + 50 + 67, b0 + 24 + i, 110, 10, s));
                        i += 14;
                    }
                }
            }
            this.field_146289_q.func_78264_a(unicode);
            super.func_73863_a(par1, par2, par3);
        } else {
            this.field_146289_q.func_78264_a(unicode);
            super.func_73863_a(par1, par2, par3);
            this.field_146289_q.func_78264_a(true);
            if (HeroSuitsCatalogHelper.pageEntries.containsKey(viewing)) {
                GL11.glEnable((int)3042);
                BookPage[] pages = HeroSuitsCatalogHelper.pageEntries.get(viewing);
                BookPage page = pages[currPage * 2];
                GL11.glEnable((int)3042);
                GL11.glPushMatrix();
                page.renderPage(k - 67, b0, this.field_146289_q, this, field_146296_j, currPage == 0, par1, par2);
                GL11.glPopMatrix();
                BookPage originalPage = page;
                GL11.glEnable((int)3042);
                if (pages.length > currPage * 2 + 1) {
                    page = pages[currPage * 2 + 1];
                    GL11.glPushMatrix();
                    page.renderPage(k + 67, b0, this.field_146289_q, this, field_146296_j, false, par1, par2);
                    GL11.glPopMatrix();
                    page.renderPageAfter(k + 67, b0, this.field_146289_q, this, field_146296_j, false, par1, par2);
                }
                originalPage.renderPageAfter(k - 67, b0, this.field_146289_q, this, field_146296_j, currPage == 0, par1, par2);
            }
            this.field_146289_q.func_78264_a(unicode);
        }
    }

    public void renderToolTip(ItemStack stack0, int p_146285_2_, int p_146285_3_, boolean renderHyperlink) {
        List list = stack0.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        this.field_73735_i = 1.0f;
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack0.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        if (renderHyperlink) {
            for (ItemStack stack : HeroSuitsCatalogHelper.bookRecipes.keySet()) {
                if (stack.func_77973_b() != stack0.func_77973_b() || stack.func_77960_j() != stack0.func_77960_j()) continue;
                list.add(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"herosuits.catalog.clickHere"));
            }
        }
        FontRenderer font = stack0.func_77973_b().getFontRenderer(stack0);
        this.func_146283_a(list, p_146285_2_, p_146285_3_);
        this.drawHoveringText(list, p_146285_2_, p_146285_3_, font == null ? this.field_146289_q : font);
        this.field_73735_i = 0.0f;
    }

    public void renderText(String str, int p_146285_2_, int p_146285_3_) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)str, (Object[])new Object[0]));
        this.func_146283_a(list, p_146285_2_, p_146285_3_);
        this.drawHoveringText(list, p_146285_2_, p_146285_3_, this.field_146289_q);
    }

    public void itemClicked(ItemStack itemStack) {
        for (ItemStack stack : HeroSuitsCatalogHelper.bookRecipes.keySet()) {
            if (mustReleaseMouse || stack.func_77973_b() != itemStack.func_77973_b() || stack.func_77960_j() != itemStack.func_77960_j()) continue;
            viewing = (String)HeroSuitsCatalogHelper.bookRecipes.get((Object)stack).left;
            currPage = MathHelper.func_76141_d((float)((float)((Integer)HeroSuitsCatalogHelper.bookRecipes.get((Object)stack).right).intValue() / 2.0f));
            bookTotalPages = MathHelper.func_76123_f((float)((float)HeroSuitsCatalogHelper.pageEntries.get(viewing).length / 2.0f));
            mustReleaseMouse = true;
            this.updateButtons();
        }
    }

    static {
        mustReleaseMouse = false;
    }

    class GuiButtonSelect
    extends GuiButton {
        public String name;

        public GuiButtonSelect(int par1, int par2, int par3, int par4, int par5, String par6Str) {
            super(par1, par2, par3, par4, par5, par6Str.contains("#") ? I18n.func_135052_a((String)par6Str.substring(1), (Object[])new Object[0]) : I18n.func_135052_a((String)par6Str, (Object[])new Object[0]));
            this.name = par6Str;
        }

        public void drawCenteredStringWithoutShadow(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5) {
            par1FontRenderer.func_78276_b(par2Str, par3, par4, par5);
        }

        public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
            if (this.field_146125_m) {
                FontRenderer var4 = par1Minecraft.field_71466_p;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean test = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
                int var5 = this.func_146114_a(test);
                this.func_146119_b(par1Minecraft, par2, par3);
                int var6 = 0x3F3F3F;
                boolean unicode = GuiHeroSuitsCatalog.this.field_146289_q.func_82883_a();
                GuiHeroSuitsCatalog.this.field_146289_q.func_78264_a(true);
                this.drawCenteredStringWithoutShadow(var4, "\u2022 " + this.field_146126_j, this.field_146128_h + (test ? 1 : 0), this.field_146129_i + (this.field_146121_g - 8) / 2, var6);
                GuiHeroSuitsCatalog.this.field_146289_q.func_78264_a(unicode);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class NextPageButton
    extends GuiButton {
        private static final String __OBFID = "CL_00000745";
        private final boolean field_146151_o;

        public NextPageButton(int par1, int par2, int par3, boolean par4) {
            super(par1, par2, par3, 23, 13, "");
            this.field_146151_o = par4;
        }

        public void func_146112_a(Minecraft minecraft, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                minecraft.func_110434_K().func_110577_a(bookRightPage);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }
    }
}

