/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.herosuits.HeroSuits;
import net.herosuits.HeroSuitsAchievements;
import net.herosuits.entity.EntityWidowsLine;
import net.herosuits.item.armor.ItemPointArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlackWidowArmor
extends ItemPointArmor {
    public String textureName;

    public ItemBlackWidowArmor(String unlocalizedName, ItemArmor.ArmorMaterial armorMaterial, String textureName, int type, int value) {
        super(armorMaterial, type, value);
        this.textureName = textureName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(HeroSuits.heroSuitsTab2);
        this.func_111206_d("HeroSuits:" + unlocalizedName);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        boolean invisible = itemstack.func_77978_p().func_74767_n("Invisible");
        if (invisible) {
            return "HeroSuits:armor/invisible_1.png";
        }
        return "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelBiped armorModel = new ModelBiped();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemBlackWidowArmor && (armorModel = HeroSuits.proxy.getModel(60)) != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                }
            }
            return armorModel;
        }
        return armorModel;
    }

    @Override
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemstack, world, entity, par4, par5);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        super.onArmorTick(world, player, itemstack);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
        }
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        boolean invisible = itemstack.field_77990_d.func_74767_n("Invisible");
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemBlackWidowMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemBlackWidowChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemBlackWidowPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemBlackWidowBoots)) {
            int z;
            int y;
            int x;
            player.func_71029_a((StatBase)HeroSuitsAchievements.achievementBlackWidow);
            if (HeroSuits.weaponNerf && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemSword || player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool"))) {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 1, true));
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 5, true));
            }
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 10, 0, true));
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionBlockStep.field_76415_H, 10, 0, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionAcrobat.field_76415_H, 10, 0, true));
            if (player.field_70123_F && player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
            }
            if (!player.field_70122_E && world.func_147439_a(x = (int)Math.floor(player.field_70165_t), (y = (int)(player.field_70163_u - player.func_70033_W())) - 1, z = (int)Math.floor(player.field_70161_v)).isAir((IBlockAccess)player.field_70170_p, x, y - 1, z) && !world.func_147439_a(x, y + 2, z).isAir((IBlockAccess)player.field_70170_p, x, y + 2, z) && player.func_70093_af()) {
                player.field_70181_x = 0.0;
            }
            if (player.field_70125_A > 75.0f && player.field_70154_o != null && player.field_70154_o instanceof EntityLivingBase) {
                float swingAmount;
                PotionEffect hasHaste = player.func_70660_b(Potion.field_76422_e);
                float f = hasHaste == null ? 0.16666667f : (swingAmount = hasHaste.func_76458_c() == 1 ? 0.5f : 0.4f);
                if (!world.field_72995_K && player.field_70733_aJ == swingAmount) {
                    EntityLivingBase entity = (EntityLivingBase)player.field_70154_o;
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 2.0f);
                    if (!(player.field_70154_o instanceof EntityPlayer) && world.field_73012_v.nextInt(19) == 0) {
                        player.func_70078_a((Entity)null);
                    }
                }
            }
            invisible = player.func_70644_a(Potion.field_76441_p);
            itemstack.field_77990_d.func_74757_a("Invisible", invisible);
        }
    }

    public static void changeSuit(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemBlackWidowMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemBlackWidowChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemBlackWidowPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemBlackWidowBoots)) {
                int suitId;
                if (!chest.func_77942_o()) {
                    NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                    chest.func_77982_d(par1NBTTagCompound);
                    chest.field_77990_d.func_74768_a("Suit", 0);
                }
                suitId = (suitId = chest.field_77990_d.func_74762_e("Suit")) <= 10 ? ++suitId : 0;
                if (suitId < 0) {
                    suitId = 0;
                }
                mask.field_77990_d.func_74768_a("Suit", suitId);
                chest.field_77990_d.func_74768_a("Suit", suitId);
                pants.field_77990_d.func_74768_a("Suit", suitId);
                boots.field_77990_d.func_74768_a("Suit", suitId);
            }
        }
    }

    public static void widowsLine(EntityPlayer player) {
        EntityWidowsLine widowsLine = new EntityWidowsLine(player.field_70170_p, player, 2.0f);
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemBlackWidowMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemBlackWidowChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemBlackWidowPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemBlackWidowBoots)) {
                player.field_70170_p.func_72838_d((Entity)widowsLine);
                player.field_70170_p.func_72956_a((Entity)player, "herosuits:grappleThrow", 0.5f, 1.0f);
            }
        }
    }

    public static void widowsBite(EntityPlayer player) {
        if (player.field_70154_o != null && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)player.field_70154_o;
            player.field_70170_p.func_72956_a((Entity)player, "herosuits:widowsBite", 1.0f, 1.0f);
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 40, 24));
            entity.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 40, -9));
            entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 40, 0));
            player.func_70078_a((Entity)null);
        }
    }

    public static void takedown(EntityPlayer player) {
        if (player.field_70154_o != null && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)player.field_70154_o;
            double forwardSpeed = 0.5;
            double verticalSpeed = 0.2;
            double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * forwardSpeed;
            double y = Math.cos(Math.toRadians((double)(player.field_70125_A / 180.0f) * Math.PI)) * verticalSpeed;
            double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * forwardSpeed;
            player.func_70078_a((Entity)null);
            entity.field_70159_w += x;
            entity.field_70181_x += y;
            entity.field_70179_y += z;
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 12.0f);
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 80, 24));
            entity.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 80, -9));
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP mp = (EntityPlayerMP)entity;
                mp.field_71135_a.func_147364_a(entity.field_70165_t, entity.field_70163_u + 1.6, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            }
        }
    }
}

