/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.herosuits.HeroSuits;
import net.herosuits.HeroSuitsAchievements;
import net.herosuits.item.armor.ItemPointArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class ItemColossusArmor
extends ItemPointArmor {
    public String textureName;

    public ItemColossusArmor(String unlocalizedName, ItemArmor.ArmorMaterial armorMaterial, String textureName, int type, int value) {
        super(armorMaterial, type, value);
        this.textureName = textureName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(HeroSuits.heroSuitsTab2);
        this.func_111206_d("HeroSuits:" + unlocalizedName);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        int suitId = itemstack.field_77990_d.func_74762_e("Suit");
        boolean hasSkin = itemstack.func_77978_p().func_74767_n("Skin");
        boolean invisible = itemstack.func_77978_p().func_74767_n("Invisible");
        if (invisible) {
            return "HeroSuits:armor/invisible_1.png";
        }
        switch (suitId) {
            case 0: {
                return hasSkin ? "HeroSuits:armor/" + this.textureName + "_skin" + ".png" : "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
            }
            case 1: {
                return hasSkin ? "HeroSuits:armor/" + this.textureName + "JX_skin" + ".png" : "HeroSuits:armor/" + this.textureName + "JX_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
            }
        }
        return hasSkin ? "HeroSuits:armor/" + this.textureName + "_skin" + ".png" : "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelBiped armorModel = new ModelBiped();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemColossusArmor && (armorModel = HeroSuits.proxy.getModel(15)) != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                }
            }
            return armorModel;
        }
        return armorModel;
    }

    @Override
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemstack, world, entity, par4, par5);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Skin", false);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        super.onArmorTick(world, player, itemstack);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Skin", false);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
        }
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        boolean hasSkin = itemstack.field_77990_d.func_74767_n("Skin");
        boolean invisible = itemstack.field_77990_d.func_74767_n("Invisible");
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemColossusMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemColossusChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemColossusPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemColossusBoots)) {
            player.func_71029_a((StatBase)HeroSuitsAchievements.achievementColossus);
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 2, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionBlockStep.field_76415_H, 10, 0, true));
            if (hasSkin) {
                if (HeroSuits.weaponNerf && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemSword || player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool"))) {
                    player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 2, true));
                } else {
                    player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 7, true));
                }
                player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 10, 3, true));
                player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 10, 0, true));
                player.func_70690_d(new PotionEffect(HeroSuits.potionMight.field_76415_H, 10, 0, true));
                player.field_70143_R = 0.0f;
            } else if (HeroSuits.weaponNerf && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemSword || player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool"))) {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 0, true));
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 3, true));
            }
            invisible = player.func_70644_a(Potion.field_76441_p);
            itemstack.field_77990_d.func_74757_a("Invisible", invisible);
        }
    }

    public static void changeSuit(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemColossusMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemColossusChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemColossusPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemColossusBoots)) {
                int suitId;
                if (!chest.func_77942_o()) {
                    NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                    chest.func_77982_d(par1NBTTagCompound);
                    chest.field_77990_d.func_74768_a("Suit", 0);
                }
                suitId = (suitId = chest.field_77990_d.func_74762_e("Suit")) <= 0 ? ++suitId : 0;
                if (suitId < 0) {
                    suitId = 0;
                }
                mask.field_77990_d.func_74768_a("Suit", suitId);
                chest.field_77990_d.func_74768_a("Suit", suitId);
                pants.field_77990_d.func_74768_a("Suit", suitId);
                boots.field_77990_d.func_74768_a("Suit", suitId);
            }
        }
    }

    public static void toggleSkin(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemColossusMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemColossusChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemColossusPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemColossusBoots)) {
                boolean hasSkin;
                player.field_70170_p.func_72956_a((Entity)player, "herosuits:clawOut", 0.5f, 0.3f);
                if (!chest.func_77942_o()) {
                    NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                    chest.func_77982_d(par1NBTTagCompound);
                    chest.field_77990_d.func_74757_a("Skin", true);
                    mask.field_77990_d.func_74757_a("Skin", true);
                }
                hasSkin = !(hasSkin = chest.field_77990_d.func_74767_n("Skin"));
                mask.field_77990_d.func_74757_a("Skin", hasSkin);
                chest.field_77990_d.func_74757_a("Skin", hasSkin);
            }
        }
    }

    public static void fastballSpecial(EntityPlayer player) {
        if (player.field_70153_n != null) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            EntityLivingBase entity = (EntityLivingBase)player.field_70153_n;
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemColossusMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemColossusChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemColossusPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemColossusBoots)) {
                double forwardSpeed = 4.0;
                double verticalSpeed = 1.2;
                double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * forwardSpeed;
                double y = Math.cos(Math.toRadians((double)(player.field_70125_A / 180.0f) * Math.PI)) * verticalSpeed;
                double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * forwardSpeed;
                entity.func_70078_a((Entity)null);
                entity.field_70159_w += x;
                entity.field_70181_x += y;
                entity.field_70179_y += z;
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP mp = (EntityPlayerMP)entity;
                    mp.field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(mp.func_145782_y(), mp.field_70159_w, mp.field_70181_x, mp.field_70179_y));
                }
                ItemStack maskR = entity.func_71124_b(4);
                ItemStack chestR = entity.func_71124_b(3);
                ItemStack pantsR = entity.func_71124_b(2);
                ItemStack bootsR = entity.func_71124_b(1);
                if (maskR != null && maskR.func_77973_b().equals(HeroSuits.itemWolverineMask) && chestR != null && chestR.func_77973_b().equals(HeroSuits.itemWolverineChest) && pantsR != null && pantsR.func_77973_b().equals(HeroSuits.itemWolverinePants) && bootsR != null && bootsR.func_77973_b().equals(HeroSuits.itemWolverineBoots)) {
                    player.func_71029_a((StatBase)HeroSuitsAchievements.achievementFastballSpecial);
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_71029_a((StatBase)HeroSuitsAchievements.achievementFastballSpecial);
                    }
                }
            }
        }
    }
}

