/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.item.armor;

import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.herosuits.HeroSuits;
import net.herosuits.HeroSuitsAchievements;
import net.herosuits.common.HeroSuitsUtilities;
import net.herosuits.item.ItemEnergyConstruct;
import net.herosuits.item.ItemGreenPowerRing;
import net.herosuits.item.armor.ItemPointArmor;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class ItemSimonBazArmor
extends ItemPointArmor {
    public String textureName;

    public ItemSimonBazArmor(String unlocalizedName, ItemArmor.ArmorMaterial armorMaterial, String textureName, int type, int value) {
        super(armorMaterial, type, value);
        this.textureName = textureName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(HeroSuits.heroSuitsTab3);
        this.func_111206_d("HeroSuits:" + unlocalizedName);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        boolean invisible = itemstack.func_77978_p().func_74767_n("Invisible");
        if (invisible) {
            return "HeroSuits:armor/invisible_1.png";
        }
        return "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelBiped armorModel = new ModelBiped();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemSimonBazArmor && (armorModel = HeroSuits.proxy.getModel(39)) != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                }
            }
            return armorModel;
        }
        return armorModel;
    }

    @Override
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemstack, world, entity, par4, par5);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
            itemstack.field_77990_d.func_74768_a("Construct1", 0);
            itemstack.field_77990_d.func_74768_a("Construct2", 1);
            itemstack.field_77990_d.func_74768_a("Construct3", 2);
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        super.onArmorTick(world, player, itemstack);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
            itemstack.field_77990_d.func_74768_a("Construct1", 0);
            itemstack.field_77990_d.func_74768_a("Construct2", 1);
            itemstack.field_77990_d.func_74768_a("Construct3", 2);
        }
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        ItemStack ring1 = PlayerHandler.getPlayerBaubles((EntityPlayer)player).func_70301_a(1);
        boolean invisible = itemstack.field_77990_d.func_74767_n("Invisible");
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemSimonBazMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemSimonBazChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemSimonBazPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemSimonBazBoots)) {
            player.func_71029_a((StatBase)HeroSuitsAchievements.achievementSimonBaz);
            if (ring1 != null && ring1.func_77973_b() instanceof ItemGreenPowerRing) {
                if (HeroSuits.weaponNerf && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemSword || player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool"))) {
                    player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 2, true));
                } else {
                    player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 7, true));
                }
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 0, true));
                player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 10, 2, true));
                player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 10, 0, true));
                player.func_70690_d(new PotionEffect(HeroSuits.potionFlight.field_76415_H, 10, 0, true));
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemEnergyConstruct) {
                    ItemEnergyConstruct item = (ItemEnergyConstruct)player.func_71045_bC().func_77973_b();
                    item.setColor(player.func_71045_bC(), 0);
                }
                if (player.field_71075_bZ.field_75100_b && !player.func_70055_a(Material.field_151586_h) && player.field_70701_bs > 0.0f) {
                    player.func_70060_a(0.0f, 1.0f, 0.02f);
                }
                player.field_70143_R = 0.0f;
            }
            invisible = player.func_70644_a(Potion.field_76441_p);
            itemstack.field_77990_d.func_74757_a("Invisible", invisible);
        }
    }

    public static void selectConstruct(EntityPlayer player, String constructNBT) {
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        ItemStack ring1 = PlayerHandler.getPlayerBaubles((EntityPlayer)player).func_70301_a(1);
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemSimonBazMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemSimonBazChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemSimonBazPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemSimonBazBoots)) {
            if (!chest.func_77942_o()) {
                NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                chest.func_77982_d(par1NBTTagCompound);
                chest.field_77990_d.func_74768_a(constructNBT, 0);
            }
            int constructId = chest.field_77990_d.func_74762_e(constructNBT);
            if (ring1 != null && ring1.func_77973_b() instanceof ItemGreenPowerRing) {
                if (!player.func_70093_af()) {
                    if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemEnergyConstruct) {
                        player.func_70062_b(0, HeroSuitsUtilities.getConstruct(constructId));
                    }
                } else {
                    constructId = constructId <= 6 ? ++constructId : 0;
                    if (constructId < 0) {
                        constructId = 0;
                    }
                    if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemEnergyConstruct) {
                        player.func_70062_b(0, HeroSuitsUtilities.getConstruct(constructId));
                    }
                }
                chest.field_77990_d.func_74768_a(constructNBT, constructId);
            }
        }
    }

    public static void construct1(EntityPlayer player) {
        ItemSimonBazArmor.selectConstruct(player, "Construct1");
    }

    public static void construct2(EntityPlayer player) {
        ItemSimonBazArmor.selectConstruct(player, "Construct2");
    }

    public static void construct3(EntityPlayer player) {
        ItemSimonBazArmor.selectConstruct(player, "Construct3");
    }
}

