/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.herosuits.HeroSuits;
import net.herosuits.HeroSuitsAchievements;
import net.herosuits.item.armor.ItemPointArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;

public class ItemStormArmor
extends ItemPointArmor {
    public String textureName;

    public ItemStormArmor(String unlocalizedName, ItemArmor.ArmorMaterial armorMaterial, String textureName, int type, int value) {
        super(armorMaterial, type, value);
        this.textureName = textureName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(HeroSuits.heroSuitsTab2);
        this.func_111206_d("HeroSuits:" + unlocalizedName);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        boolean invisible = itemstack.func_77978_p().func_74767_n("Invisible");
        if (invisible) {
            return "HeroSuits:armor/invisible_1.png";
        }
        return "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelBiped armorModel = new ModelBiped();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemStormArmor && (armorModel = HeroSuits.proxy.getModel(5)) != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                }
            }
            return armorModel;
        }
        return armorModel;
    }

    @Override
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemstack, world, entity, par4, par5);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
            itemstack.field_77990_d.func_74768_a("airTime", 0);
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        super.onArmorTick(world, player, itemstack);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
            itemstack.field_77990_d.func_74768_a("airTime", 0);
        }
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        boolean invisible = itemstack.field_77990_d.func_74767_n("Invisible");
        int air = itemstack.field_77990_d.func_74762_e("airTime");
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemStormMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemStormChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemStormPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemStormBoots)) {
            player.func_71029_a((StatBase)HeroSuitsAchievements.achievementStorm);
            if (!HeroSuits.weaponNerf || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemSword) && !player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool")) {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 1, true));
            }
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionFlight.field_76415_H, 10, 0, true));
            if (!player.field_70122_E && player.field_70181_x < 0.0 && !player.field_71075_bZ.field_75100_b && !player.field_71075_bZ.field_75098_d) {
                ++air;
            }
            if (air > 8) {
                player.field_70181_x *= 0.9;
                player.field_70143_R = 0.0f;
            }
            if (player.field_70122_E || player.field_71075_bZ.field_75100_b || player.field_71075_bZ.field_75098_d) {
                air = 0;
            }
            itemstack.field_77990_d.func_74768_a("airTime", air);
            invisible = player.func_70644_a(Potion.field_76441_p);
            itemstack.field_77990_d.func_74757_a("Invisible", invisible);
        }
    }

    public static void rainstorm(EntityPlayer player) {
        WorldServer worldserver = MinecraftServer.func_71276_C().field_71305_c[0];
        WorldInfo worldinfo = worldserver.func_72912_H();
        worldinfo.func_76080_g(3600);
        worldinfo.func_76084_b(true);
        if (player.field_70170_p.field_73012_v.nextInt(4) == 0) {
            worldinfo.func_76090_f(3600);
            worldinfo.func_76069_a(true);
        }
    }

    public static void clearWeather(EntityPlayer player) {
        WorldServer worldserver = MinecraftServer.func_71276_C().field_71305_c[0];
        WorldInfo worldinfo = worldserver.func_72912_H();
        worldinfo.func_76080_g(0);
        worldinfo.func_76090_f(0);
        worldinfo.func_76084_b(false);
        worldinfo.func_76069_a(false);
    }

    public static void lightningStrike(EntityPlayer player) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - 3.141593f));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f)));
        Vec3 vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 100.0), (double)(f8 = (f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f)))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = player.field_70170_p.func_72901_a(vec3d, vec3d1, false);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, (double)i, (double)j, (double)k));
        }
    }
}

