/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.herosuits.HeroSuits;
import net.herosuits.HeroSuitsAchievements;
import net.herosuits.entity.EntityEyeBeam;
import net.herosuits.entity.EntityRepulsorBeam;
import net.herosuits.item.armor.ItemPointArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemUltronArmor
extends ItemPointArmor {
    public String textureName;

    public ItemUltronArmor(String unlocalizedName, ItemArmor.ArmorMaterial armorMaterial, String textureName, int type, int value) {
        super(armorMaterial, type, value);
        this.textureName = textureName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(HeroSuits.heroSuitsTab2);
        this.func_111206_d("HeroSuits:" + unlocalizedName);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        boolean invisible = itemstack.func_77978_p().func_74767_n("Invisible");
        if (invisible) {
            return "HeroSuits:armor/invisible_1.png";
        }
        return "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelBiped armorModel = new ModelBiped();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemUltronArmor && (armorModel = HeroSuits.proxy.getModel(64)) != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                }
            }
            return armorModel;
        }
        return armorModel;
    }

    @Override
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemstack, world, entity, par4, par5);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
            itemstack.field_77990_d.func_74757_a("Flying", false);
            itemstack.field_77990_d.func_74757_a("Hover", false);
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        super.onArmorTick(world, player, itemstack);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
            itemstack.field_77990_d.func_74757_a("Flying", false);
            itemstack.field_77990_d.func_74757_a("Hover", false);
        }
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        boolean invisible = itemstack.field_77990_d.func_74767_n("Invisible");
        boolean isFlying = itemstack.field_77990_d.func_74767_n("Flying");
        boolean hovering = itemstack.field_77990_d.func_74767_n("Hover");
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemUltronMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemUltronChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemUltronPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemUltronBoots)) {
            player.func_71029_a((StatBase)HeroSuitsAchievements.achievementUltron);
            if (HeroSuits.weaponNerf && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemSword || player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool"))) {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 3, true));
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 9, true));
            }
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 10, 3, true));
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 2, true));
            player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 10, 0, true));
            player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 10, 0, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionBlockStep.field_76415_H, 10, 0, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionMight.field_76415_H, 10, 0, true));
            if (!player.func_82165_m(Potion.field_76428_l.field_76415_H)) {
                player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 20, 1, true));
            }
            if (!player.func_82165_m(Potion.field_76434_w.field_76415_H)) {
                player.func_70690_d(new PotionEffect(Potion.field_76434_w.field_76415_H, 10, 4, true));
            } else {
                PotionEffect potionEffect = player.func_70660_b(Potion.field_76434_w);
                potionEffect.func_76452_a(new PotionEffect(Potion.field_76434_w.field_76415_H, 10, 4, true));
            }
            if (!player.func_82165_m(Potion.field_76443_y.field_76415_H)) {
                player.func_70690_d(new PotionEffect(Potion.field_76443_y.field_76415_H, 20, 1, true));
            }
            if (itemstack.field_77990_d.func_74767_n("Invisible")) {
                player.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 10, 0));
            }
            if (isFlying) {
                if (!(player.field_70122_E || player.field_70123_F || player.field_71075_bZ.field_75100_b)) {
                    double forwardSpeed = 0.03;
                    double verticalSpeed = 0.85;
                    if (hovering) {
                        forwardSpeed = player.func_70093_af() ? 0.0 : 0.005;
                        verticalSpeed = 0.0;
                    } else {
                        forwardSpeed = 0.03;
                        verticalSpeed = 0.85;
                    }
                    double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * forwardSpeed;
                    double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * forwardSpeed;
                    player.field_70159_w += x;
                    player.field_70179_y += z;
                    player.field_70181_x = player.field_70125_A < -10.0f && player.field_70125_A > -70.0f && !hovering ? 0.55 : (player.field_70125_A < -70.0f && !hovering ? 1.0 : (player.field_70125_A > 25.0f && !hovering ? (player.field_70181_x *= 0.99) : (player.field_70181_x *= verticalSpeed)));
                }
            } else {
                hovering = false;
            }
            if (player.field_70122_E) {
                isFlying = false;
                hovering = false;
            }
            player.field_70143_R = 0.0f;
            if (!player.func_70644_a(Potion.field_76440_q)) {
                if (player.field_70170_p.func_72957_l(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)) <= 5) {
                    player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 240, 0, true));
                } else {
                    player.func_82170_o(Potion.field_76439_r.field_76415_H);
                }
            }
            invisible = player.func_70644_a(Potion.field_76441_p);
            itemstack.field_77990_d.func_74757_a("Invisible", invisible);
            itemstack.field_77990_d.func_74757_a("Flying", isFlying);
            itemstack.field_77990_d.func_74757_a("Hover", hovering);
        } else {
            player.func_82170_o(Potion.field_76439_r.field_76415_H);
        }
    }

    public static void toggleFlying(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemUltronMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemUltronChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemUltronPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemUltronBoots)) {
                if (player.func_70093_af()) {
                    boolean hovering;
                    if (!chest.func_77942_o()) {
                        NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                        chest.func_77982_d(par1NBTTagCompound);
                        chest.field_77990_d.func_74757_a("Hover", true);
                        mask.field_77990_d.func_74757_a("Hover", true);
                        pants.field_77990_d.func_74757_a("Hover", true);
                        boots.field_77990_d.func_74757_a("Hover", true);
                    }
                    hovering = !(hovering = chest.field_77990_d.func_74767_n("Hover"));
                    mask.field_77990_d.func_74757_a("Hover", hovering);
                    chest.field_77990_d.func_74757_a("Hover", hovering);
                    pants.field_77990_d.func_74757_a("Hover", hovering);
                    boots.field_77990_d.func_74757_a("Hover", hovering);
                } else {
                    boolean isFlying;
                    if (!chest.func_77942_o()) {
                        NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                        chest.func_77982_d(par1NBTTagCompound);
                        chest.field_77990_d.func_74757_a("Flying", true);
                        mask.field_77990_d.func_74757_a("Flying", true);
                        pants.field_77990_d.func_74757_a("Flying", true);
                        boots.field_77990_d.func_74757_a("Flying", true);
                    }
                    boolean bl = isFlying = !(isFlying = chest.field_77990_d.func_74767_n("Flying"));
                    if (isFlying && !player.field_70122_E) {
                        player.field_70170_p.func_72956_a((Entity)player, "herosuits:repulsorBoost", 0.5f, 1.0f);
                    }
                    mask.field_77990_d.func_74757_a("Flying", isFlying);
                    chest.field_77990_d.func_74757_a("Flying", isFlying);
                    pants.field_77990_d.func_74757_a("Flying", isFlying);
                    boots.field_77990_d.func_74757_a("Flying", isFlying);
                }
            }
        }
    }

    public static void eyeBeam(EntityPlayer player) {
        EntityEyeBeam entityeyebeam = new EntityEyeBeam(player.field_70170_p, (EntityLivingBase)player);
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)entityeyebeam);
            player.field_70170_p.func_72956_a((Entity)player, "herosuits:visionBlast", 0.5f, 1.0f);
        }
    }

    public static void repulsorBeam(EntityPlayer player) {
        EntityRepulsorBeam repulsorBeam = new EntityRepulsorBeam(player.field_70170_p, (EntityLivingBase)player);
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)repulsorBeam);
            player.field_70170_p.func_72956_a((Entity)player, "herosuits:visionBlast", 0.5f, 1.0f);
        }
    }

    public static void changeSuit(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemUltronMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemUltronChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemUltronPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemUltronBoots)) {
                int suitId;
                if (!chest.func_77942_o()) {
                    NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                    chest.func_77982_d(par1NBTTagCompound);
                    chest.field_77990_d.func_74768_a("Suit", 0);
                }
                suitId = (suitId = chest.field_77990_d.func_74762_e("Suit")) <= 1 ? ++suitId : 0;
                if (suitId < 0) {
                    suitId = 0;
                }
                mask.field_77990_d.func_74768_a("Suit", suitId);
                chest.field_77990_d.func_74768_a("Suit", suitId);
                pants.field_77990_d.func_74768_a("Suit", suitId);
                boots.field_77990_d.func_74768_a("Suit", suitId);
            }
        }
    }
}

