/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.herosuits.HeroSuits;
import net.herosuits.HeroSuitsAchievements;
import net.herosuits.item.armor.ItemPointArmor;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemZoomArmor
extends ItemPointArmor {
    public String textureName;

    public ItemZoomArmor(String unlocalizedName, ItemArmor.ArmorMaterial armorMaterial, String textureName, int type, int value) {
        super(armorMaterial, type, value);
        this.textureName = textureName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(HeroSuits.heroSuitsTab3);
        this.func_111206_d("HeroSuits:" + unlocalizedName);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        boolean invisible = itemstack.func_77978_p().func_74767_n("Invisible");
        if (invisible) {
            return "HeroSuits:armor/invisible_1.png";
        }
        return "HeroSuits:armor/" + this.textureName + "_" + (this.field_77881_a == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelBiped armorModel = new ModelBiped();
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemZoomArmor && (armorModel = HeroSuits.proxy.getModel(42)) != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                } else if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                }
            }
            return armorModel;
        }
        return armorModel;
    }

    @Override
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemstack, world, entity, par4, par5);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74768_a("SuperSpeed", 0);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemstack) {
        super.onArmorTick(world, player, itemstack);
        if (!itemstack.func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            itemstack.func_77982_d(par1NBTTagCompound);
            itemstack.field_77990_d.func_74768_a("SuperSpeed", 0);
            itemstack.field_77990_d.func_74757_a("Invisible", false);
            itemstack.field_77990_d.func_74768_a("Suit", 0);
        }
        ItemStack mask = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack pants = player.func_82169_q(1);
        ItemStack boots = player.func_82169_q(0);
        boolean invisible = itemstack.field_77990_d.func_74767_n("Invisible");
        int speedLevel = itemstack.field_77990_d.func_74762_e("SuperSpeed");
        if (mask != null && mask.func_77973_b().equals(HeroSuits.itemZoomMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemZoomChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemZoomPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemZoomBoots)) {
            AxisAlignedBB axisalignedbb;
            List list1;
            player.func_71029_a((StatBase)HeroSuitsAchievements.achievementZoom);
            if (HeroSuits.weaponNerf && player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() instanceof ItemSword || player.func_71045_bC().func_77973_b().func_77658_a().contains("InfiTool"))) {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 1, true));
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 10, 5, true));
            }
            player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 10, 4, true));
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 10, 1, true));
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 10, 2, true));
            player.func_70690_d(new PotionEffect(HeroSuits.potionBlockStep.field_76415_H, 10, 0, true));
            if (!player.func_82165_m(Potion.field_76428_l.field_76415_H)) {
                player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 20, 1, true));
            }
            if (speedLevel == 1) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 24, true));
                player.func_70690_d(new PotionEffect(HeroSuits.potionWaterWalk.field_76415_H, 10, 0, true));
            }
            if (speedLevel == 2) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 49, true));
                player.func_70690_d(new PotionEffect(HeroSuits.potionWaterWalk.field_76415_H, 10, 0, true));
                if (player.field_70123_F && player.field_70701_bs > 0.0f && player.field_70125_A < -45.0f) {
                    player.field_70181_x = 2.5;
                }
            }
            if (speedLevel == 3) {
                int x = (int)Math.floor(player.field_70165_t);
                int y = (int)(player.field_70163_u - player.func_70033_W());
                int z = (int)Math.floor(player.field_70161_v);
                if (player.func_70093_af() && !player.field_70170_p.func_147439_a(x, y - 1, z).isAir((IBlockAccess)player.field_70170_p, x, y - 1, z)) {
                    player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 149, true));
                    player.func_70690_d(new PotionEffect(HeroSuits.potionIntangibility.field_76415_H, 10, 0, true));
                } else {
                    player.func_82170_o(HeroSuits.potionIntangibility.field_76415_H);
                    player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 99, true));
                    player.func_70690_d(new PotionEffect(HeroSuits.potionWaterWalk.field_76415_H, 10, 0, true));
                    if (player.field_70123_F && player.field_70701_bs > 0.0f && player.field_70125_A < -45.0f) {
                        player.field_70181_x = 2.5;
                    }
                }
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 10, 2, true));
            }
            if (speedLevel > 0 && (list1 = player.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb = player.field_70121_D.func_72314_b(8.0, 8.0, 8.0))) != null && !list1.isEmpty()) {
                for (EntityLivingBase entity : list1) {
                    double d0 = player.func_70068_e((Entity)entity);
                    if (d0 < 16.0) {
                        if (entity == player) continue;
                        entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 40, speedLevel - 1));
                        continue;
                    }
                    return;
                }
            }
            invisible = player.func_70644_a(Potion.field_76441_p);
            player.field_70143_R = 0.0f;
            itemstack.field_77990_d.func_74757_a("Invisible", invisible);
        }
    }

    public static void toggleSuperSpeed(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack mask = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack pants = player.func_82169_q(1);
            ItemStack boots = player.func_82169_q(0);
            if (mask != null && mask.func_77973_b().equals(HeroSuits.itemZoomMask) && chest != null && chest.func_77973_b().equals(HeroSuits.itemZoomChest) && pants != null && pants.func_77973_b().equals(HeroSuits.itemZoomPants) && boots != null && boots.func_77973_b().equals(HeroSuits.itemZoomBoots)) {
                int speed;
                if (!mask.func_77942_o()) {
                    NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
                    mask.func_77982_d(par1NBTTagCompound);
                    mask.field_77990_d.func_74768_a("SuperSpeed", 0);
                    chest.field_77990_d.func_74768_a("SuperSpeed", 0);
                    pants.field_77990_d.func_74768_a("SuperSpeed", 0);
                    boots.field_77990_d.func_74768_a("SuperSpeed", 0);
                }
                speed = (speed = chest.field_77990_d.func_74762_e("SuperSpeed")) <= 2 ? ++speed : 0;
                if (speed < 0) {
                    speed = 0;
                }
                mask.field_77990_d.func_74768_a("SuperSpeed", speed);
                chest.field_77990_d.func_74768_a("SuperSpeed", speed);
                pants.field_77990_d.func_74768_a("SuperSpeed", speed);
                boots.field_77990_d.func_74768_a("SuperSpeed", speed);
            }
        }
    }
}

