/*
 * Decompiled with CFR 0.152.
 */
package net.herosuits.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.herosuits.common.HeroSuitsUtilities;
import net.herosuits.point.ExtendedPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketCatalogPurchase
implements IMessage,
IMessageHandler<PacketCatalogPurchase, IMessage> {
    private int dimension;
    private int playerId;
    private ItemStack item;
    private int cost;

    public PacketCatalogPurchase() {
    }

    public PacketCatalogPurchase(EntityPlayer player, ItemStack item, int cost) {
        this.dimension = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerId = player.func_145782_y();
        this.item = item;
        this.cost = cost;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.dimension);
        buffer.writeInt(this.playerId);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.item);
        buffer.writeInt(this.cost);
    }

    public void fromBytes(ByteBuf buffer) {
        this.dimension = buffer.readInt();
        this.playerId = buffer.readInt();
        this.item = ByteBufUtils.readItemStack((ByteBuf)buffer);
        this.cost = buffer.readInt();
    }

    public IMessage onMessage(PacketCatalogPurchase message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ExtendedPlayer extPlayer = ExtendedPlayer.getExtendedPlayer((EntityPlayer)player);
        ChatComponentText points = new ChatComponentText("You don't have enough Points to purchase this item.");
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        if (world == null) {
            return null;
        }
        if (player != null) {
            if (extPlayer.getPlayerPoints() >= message.cost) {
                extPlayer.spendPlayerPoints(message.cost);
                HeroSuitsUtilities.dropItemOnPlayer((EntityPlayer)player, message.item);
            } else {
                player.func_145747_a((IChatComponent)points);
            }
        }
        return null;
    }
}

