/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.herac.tuxguitar.io.midi.base.MidiEvent;

public class MidiTrack {
    private long ticks;
    private List events = new ArrayList();

    public void add(MidiEvent midiEvent) {
        this.events.add(midiEvent);
        this.ticks = Math.max(this.ticks, midiEvent.getTick());
    }

    public MidiEvent get(int n) {
        return (MidiEvent)this.events.get(n);
    }

    public int size() {
        return this.events.size();
    }

    public long ticks() {
        return this.ticks;
    }

    public void sort() {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof MidiEvent && object2 instanceof MidiEvent) {
                    MidiEvent midiEvent = (MidiEvent)object;
                    MidiEvent midiEvent2 = (MidiEvent)object2;
                    if (midiEvent.getTick() == midiEvent2.getTick()) {
                        return 0;
                    }
                    return midiEvent.getTick() > midiEvent2.getTick() ? 1 : -1;
                }
                return 0;
            }
        };
        Collections.sort(this.events, comparator);
    }
}

