/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerGui;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBUrl;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import org.herac.tuxguitar.util.TGSynchronizer;

public class SBAssistant {
    public static final SBUrl[] URLS = new SBUrl[]{new SBUrl(SBAssistant.toURL("http://java.sun.com/products/java-media/sound/soundbank-min.gm.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.minimal")), new SBUrl(SBAssistant.toURL("http://java.sun.com/products/java-media/sound/soundbank-mid.gm.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.medium")), new SBUrl(SBAssistant.toURL("http://java.sun.com/products/java-media/sound/soundbank-deluxe.gm.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.deluxe"))};
    private MidiPortSynthesizer synthesizer;

    public SBAssistant(MidiPortSynthesizer midiPortSynthesizer) {
        this.synthesizer = midiPortSynthesizer;
    }

    public void process() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                        public void run() {
                            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.confirm-message"));
                            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_NO);
                            if (confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO, ConfirmDialog.BUTTON_YES) == ConfirmDialog.STATUS_YES) {
                                SBAssistant.this.open();
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }).start();
    }

    protected void open() {
        final Shell shell = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)67680);
        shell.setLayout((Layout)new GridLayout());
        Group group = new Group((Composite)shell, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)this.getGroupData());
        group.setText(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.select"));
        final Button[] buttonArray = new Button[URLS.length];
        for (int i = 0; i < URLS.length; ++i) {
            buttonArray[i] = new Button((Composite)group, 16);
            buttonArray[i].setText(URLS[i].getName());
            buttonArray[i].setData((Object)URLS[i]);
            buttonArray[i].setSelection(i == 0);
        }
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)this.getButtonsData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                URL uRL = SBAssistant.this.getSelection(buttonArray);
                shell.dispose();
                if (uRL != null) {
                    SBAssistant.this.install(uRL);
                }
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)this.getButtonsData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.dispose();
            }
        });
        shell.setDefaultButton(button);
        DialogUtils.openDialog((Shell)shell, (int)10);
    }

    protected GridData getGroupData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 250;
        return gridData;
    }

    protected GridData getButtonsData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected URL getSelection(Button[] buttonArray) {
        for (int i = 0; i < buttonArray.length; ++i) {
            if (!buttonArray[i].getSelection() || !(buttonArray[i].getData() instanceof SBUrl)) continue;
            return ((SBUrl)buttonArray[i].getData()).getUrl();
        }
        return null;
    }

    protected void install(URL uRL) {
        new SBInstallerGui(uRL, this.synthesizer).open();
    }

    private static URL toURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }
}

