/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import org.herac.tuxguitar.player.base.MidiPort;
import org.herac.tuxguitar.player.base.MidiPortEmpty;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiReceiverImpl;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequenceLoader;

public class MidiSequencerImpl
implements MidiSequencer,
MidiSequenceLoader {
    private static final int TICK_MOVE = 1;
    private Sequencer sequencer;
    private Transmitter transmitter;
    private MidiPort midiPort;

    public MidiSequencerImpl(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    public synchronized void open() {
        try {
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
                this.closeTransmitter();
                this.openTransmitter();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void close() {
        try {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
                this.closeTransmitter();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openTransmitter() {
        try {
            this.transmitter = this.getSequencer().getTransmitter();
            this.transmitter.setReceiver(new MidiReceiverImpl(this));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void closeTransmitter() {
        try {
            if (this.transmitter != null) {
                this.transmitter.close();
                this.transmitter = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected Sequencer getSequencer() {
        this.open();
        return this.sequencer;
    }

    public MidiSequenceHandler createSequence(int n) {
        this.resetTracks();
        return new MidiSequenceHandlerImpl(this, n);
    }

    public MidiPort getMidiPort() {
        if (this.midiPort == null) {
            this.midiPort = new MidiPortEmpty();
        }
        return this.midiPort;
    }

    public void setMidiPort(MidiPort midiPort) {
        this.midiPort = midiPort;
    }

    public long getTickLength() {
        try {
            return this.getSequencer().getTickLength();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public long getTickPosition() {
        try {
            return this.getSequencer().getTickPosition() + 1L;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public void setTickPosition(long l) {
        try {
            this.getSequencer().setTickPosition(l - 1L);
            this.reset(false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isRunning() {
        try {
            return this.getSequencer().isRunning();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setMute(int n, boolean bl) {
        try {
            this.getSequencer().setTrackMute(n, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSolo(int n, boolean bl) {
        try {
            this.getSequencer().setTrackSolo(n, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setSequence(Sequence sequence) {
        try {
            this.getSequencer().setSequence(sequence);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void start() {
        try {
            this.getSequencer().start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.getSequencer().stop();
            this.reset(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void reset(boolean bl) {
        try {
            this.getMidiPort().out().sendAllNotesOff();
            for (int i = 0; i < 16; ++i) {
                this.getMidiPort().out().sendPitchBend(i, 64);
            }
            if (bl) {
                this.getMidiPort().out().sendSystemReset();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void resetTracks() {
        try {
            Track[] trackArray;
            Sequence sequence = this.getSequencer().getSequence();
            if (sequence != null && (trackArray = sequence.getTracks()) != null) {
                int n = trackArray.length;
                for (int i = 0; i < n; ++i) {
                    this.setSolo(i, false);
                    this.setMute(i, false);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getKey() {
        return this.sequencer.getDeviceInfo().getName();
    }

    public String getName() {
        return this.sequencer.getDeviceInfo().getName();
    }
}

