import WxValidate from '../../utils/WxValidate.js';

Component({
  /**
   * 组件的属性列表
   */
  properties: {
    formData: {
      type: Object,
      value: {}
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    form: {},
    formList: [],
    dateParams: {
      year: true,
      month: true,
      day: true,
      hour: false,
      minute: false,
      second: false
    },
    rules: {},
    time: "12:00"
  },

  attached() {
    let formList = this.data.formData.form_list || [];
    let form = {};
    let fileList = [];
    let rules = {};
    let messages = {};
    Object.keys(formList).length && Object.keys(formList).forEach((index) => {
      let item = formList[index];
      let formKey = item.type + '_' + item.random_code;
      form[formKey] = '';
      fileList.push([]);

      let message = "请填写正确的" + item.title;
      if(item.type=='image') {
        message = "请上传"+item.title;
      }
      if(item.type=='select') {
        item.index = -1;
        message = "请选择"+item.title;
      }

      //手机格式验证
      if(item.type=='telephone'&&item.required) {
        rules[formKey] = {
          required: item.required,
          tel: true
        }
        messages[formKey] = {
          required: message,
          tel: message
        }
      } else {
        rules[formKey] = {
          required: item.required
        }
        messages[formKey] = {
          required: message
        }
      }

      item.show = false;
    })

    this.setData({
      form,
      formList,
      fileList,
      formList,
      rules
    })

    this.WxValidate = new WxValidate(rules, messages)
    console.log('form', form)
  },

  /**
   * 组件的方法列表
   */
  methods: {
    changeImg: function (e) {
      // console.log(e.detail)
      let key = e.detail.key;
      let form = this.data.form;
      form[key] = e.detail.value.join(",");
      this.setData({
        form
      })
    },
    bindPickerChange(e) {
      // console.log(e)
      let idx = e.currentTarget.dataset.idx || "";
      let value = e.detail.value;
      let { form, formList } = this.data;
      let item = formList[idx];
      let key = item.type+'_'+item.random_code;
      item.index = value;
      formList[idx] = item;
      form[key] = item.option_val[value];
      this.setData({
        form,
        formList
      })
    },
    formSubmit(e) {
      const form = this.data.form
      console.log('form发生了submit事件，携带数据为：', form)
      //校验表单
      if (!this.WxValidate.checkForm(form)) {
        const error = this.WxValidate.errorList[0];
        wx.showToast({
          title: error.msg,
          icon: "none"
        })
        return false;
      }
    }
  }
})