<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    fish
 *
 */
namespace Home\Controller;
use Home\Model\OrderModel;
class PlatformmobileController extends CommonController {
	public $member_id;
	protected function _initialize(){
		parent::_initialize();

		$isopen_admin_managefront = D('Home/Front')->get_config_by_name('isopen_admin_managefront');
        $isopen_admin_managefront = isset($isopen_admin_managefront) ? $isopen_admin_managefront : 0;

        if( $isopen_admin_managefront == 0 )
        {
            echo json_encode( array('code' => 3, 'message' => '未开启平台手机端功能') );
            die();
        }

        $token =  I('request.token');

        $weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();

        if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
        {
            echo json_encode( array('code' => 1,'message' => '请先登录') );
            die();
        }

        $this->member_id = $weprogram_token['member_id'];

        //检测是否平台管理员
        $platform_admin_member = D('Home/Front')->get_config_by_name('platform_admin_member');
        if( empty($platform_admin_member) )
        {
            echo json_encode( array('code' => 3, 'message' => '您不是平台管理员') );
            die();
        }

        $platform_admin_member_arr = explode(',', $platform_admin_member );
        if( !in_array( $this->member_id , $platform_admin_member_arr ) )
        {
            echo json_encode( array('code' => 3, 'message' => '您不是平台管理员') );
            die();
        }
	}

    /**
     * @author yj
     * @desc 获取平台手机端数据所需要的内容
     */
	public function getIndexData()
    {
        $begin_time = 0;
        $end_time = time() +1;
        $sales_data = D('Home/OrderV3')->analySalesByTime( $begin_time , $end_time );//销售统计
        $todayOrderData = D('Home/OrderV3')->getTodayOrderData();//今日平台数据
        $user_data = D('Home/OrderV3')->getPlatformUserData();
        $goods_data = D('Home/OrderV3')->getPlatformGoodsData();
        $business_data = D('Home/OrderV3')->getBusinessData();

        $need_data = [];
        $need_data['sales_data'] = $sales_data;
        $need_data['todayOrderData'] = $todayOrderData;
        $need_data['user_data'] = $user_data;
        $need_data['goods_data'] = $goods_data;
        $need_data['business_data'] = $business_data;
        $need_data['code'] = 0;

        echo json_encode( $need_data );
        die();
    }


    public function searchAnalySalesByTime()
    {
        $type = I('request.type', 0);
        $begin_time = I('request.begin_time','','strtotime');
        $end_time = I('request.end_time', '', 'strtotime');

        switch( $type )
        {
            case 0:
                $begin_time = 0;
                $end_time = time() +1;
                break;
            case 1:
                //今日
                $begin_time = strtotime( date('Y-m-d').' 00:00:00' );
                $end_time = $begin_time + 86400;
                break;
            case 2:
                //昨日
                $begin_time = strtotime( date('Y-m-d').' 00:00:00' ) - 86400;
                $end_time = $begin_time + 86400;
                break;
            case 3:
                //7日
                $begin_time = strtotime( date('Y-m-d').' 00:00:00' );
                $end_time = $begin_time + 86400;
                $begin_time = $begin_time - 6*86400;
                break;
        }

        $sales_data = D('Home/OrderV3')->analySalesByTime( $begin_time , $end_time );//销售统计

        $need_data = [];
        $need_data['code'] = 1;
        $need_data['sales_data'] = $sales_data;

        echo json_encode( $need_data );
        die();
    }
	

}