<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    fish
 *
 */
namespace Home\Controller;

class VirtualcardController extends CommonController {
	
    protected function _initialize()
    {
    	parent::_initialize();
	}
    public function index(){

        $virtualcard_index_info = [];

        $virtcard_share_title = D('Home/Front')->get_config_by_name('virtcard_share_title');//分销标题
        $virtualcard_index_info['virtcard_share_title'] = !isset($virtcard_share_title) ? '' : $virtcard_share_title;

        $virtcard_share_img = D('Home/Front')->get_config_by_name('virtcard_share_img');//分享图片
        $virtualcard_index_info['virtcard_share_img'] = empty($virtcard_share_img) ? '' : tomedia($virtcard_share_img );

        $virtcard_top_banner = D('Home/Front')->get_config_by_name('virtcard_top_banner');//礼品卡顶部图片
        $virtualcard_index_info['virtcard_top_banner'] = empty($virtcard_top_banner) ? '' : tomedia($virtcard_top_banner );

        $virtualcard_layout = D('Home/Front')->get_config_by_name('virtualcard_layout');//布局方式 0左右布局，1横向布局
        $virtualcard_index_info['virtualcard_layout'] = !isset($virtualcard_layout) ? 0 : $virtualcard_layout;

        $virtcard_publish = D('Home/Front')->get_config_by_name('virtcard_publish');//规则说明
        $virtualcard_index_info['virtcard_publish'] = htmlspecialchars_decode( $virtcard_publish );

        $virtualcard_name_modify = D('Home/Front')->get_config_by_name('virtualcard_name_modify');
        $virtualcard_index_info['virtualcard_name_modify'] = empty($virtualcard_name_modify) ? '礼品卡中心' : $virtualcard_name_modify;

        echo json_encode( ['code' => 0, 'data' => $virtualcard_index_info ] );
        die();
    }

    /**
     * @author yj
     * @desc 获取商品列表有分页
     */
    public function load_goods_list()
    {
        $result = D('Seller/VirtualCard')->getIndexVirturalCardGoods(0);

        echo json_encode( $result );
        die();
    }
    /**
     * @author yj
     * @desc 获取已兑换列表
     */
    public function loadUseRecord()
    {

        $gpc = I('request.');

        $token =  $gpc['token'];

        $weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();

        if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
        {
            //未登录
            echo json_encode( array('code' => 1) );
            die();
        }

        $member_id = $weprogram_token['member_id'];


        $result = D('Seller/VirtualCard')->getUserUserecord( $member_id );

        echo json_encode( $result );
        die();
    }





    /**
     * @author yj
     * @desc 提交兑换码兑换余额
     */
    public function subCodeSn()
    {
        $gpc = I('request.');

        $token =  $gpc['token'];
        $code_sn =  $gpc['code_sn'];

        $weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();

        if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
        {
            //未登录
            echo json_encode( array('code' => 1) );
            die();
        }

        $member_id = $weprogram_token['member_id'];

        if($member_id)
        {
            //检测是否被锁定
            $check_lock_res = D('Seller/VirtualCard')->checkUserIsLock( $member_id );
            if( $check_lock_res['code'] == 0 )
            {
                echo json_encode( ['code' => 2, 'message' => '输入次数过多，请在'.$check_lock_res['min'].'分钟后重新尝试' ] );
                die();
            }

            //检验sn
            $result = D('Seller/VirtualCard')->subCodeSn( $code_sn ,$member_id );
            if( $result['code'] != 0 )
            {
                //开启巡查禁用模式
                D('Seller/Virtualcard')->insErrorSubCodeSnUserId( $member_id );
                D('Seller/Virtualcard')->checkIsNeedLockUser( $member_id );
            }

            echo json_encode( $result );
            die();
        }

    }

    
}