<?php

namespace Home\Model;

use Think\Model;

/**
 * 同城配送模型
 * @author fish
 *
 */

class LocaltownSnatchModel {

    public $table = 'pin';
    public $state_arr = array(
        0 =>'未付款，未配送',
        1=>'已付款，未被抢',
        2=>'已付款，待配送，已被抢单',
        3=>'已拿货，配送中',
        4=>'已送达',
        5=>'已取消'
    );

    /**
     * @author yj 2020-06-05
     * @desc 将待抢的订单id 放入到redis中， 未开启redis不让他们使用
     * @param $id
     */
   public function push_localtown_orderquene($id)
   {
       //D('Seller/Redisorder')->

   }

    /**
     * @auth yj 2020-06-10
     * @desc
     * @param $id
     *
     */
   public function get_localtown_orderinfo( $id )
   {

        $orderdistribution_order = M('lionfish_comshop_orderdistribution_order')->where( array('id' => $id ) )->find();

        $order_info = M('lionfish_comshop_order')->where( array('order_id' => $orderdistribution_order['order_id'] ) )->find();

        $shop_name = '平台';
		$shop_mobile = D('Home/Front')->get_config_by_name('localtown_shop_telephone');

        $store_id = $order_info['store_id'];

        if( $store_id > 0 )
        {
            $supply_info = M('lionfish_comshop_supply')->field('shopname,mobile')->where( array('id' => $store_id ) )->find();

            $shop_name = $supply_info['shopname'];

			$shop_mobile = D('Home/Front')->get_supply_config_by_name('localtown_shop_telephone',$store_id);

        }

        $shop_address = $orderdistribution_order['shop_address'];

        $shop_address = empty($shop_address) ? '平台': $shop_address;

        $province_info = D('Seller/Area')->get_area_info($order_info['shipping_province_id']);
        $city_info = D('Seller/Area')->get_area_info($order_info['shipping_city_id']);
        $country_info = D('Seller/Area')->get_area_info($order_info['shipping_country_id']);

        $member_address = $province_info.$city_info.$country_info.$order_info['shipping_address'];



        $member_lon = $orderdistribution_order['member_lon'];
        $member_lat = $orderdistribution_order['member_lat'];

        $pay_time = date( 'Y-m-d H:i:s', $order_info['pay_time'] );

        $delivery_note = "配送距离".$orderdistribution_order['distance']."公里，配送费".$orderdistribution_order['shipping_money']."元";

        $need_data = array();

        $need_data['order_num_alias'] = $order_info['order_num_alias'];
        $need_data['shop_name'] = $shop_name;
        $need_data['shop_mobile'] = $shop_mobile;

        $need_data['want_time'] = '立即送达';

        $need_data['shop_address'] = $shop_address;
        $need_data['order_id'] = $orderdistribution_order['order_id'];
		
        $need_data['shipping_name'] = $order_info['shipping_name'];
        $need_data['member_address'] = $member_address;
        $need_data['member_lon'] = $member_lon;
        $need_data['member_lat'] = $member_lat;
        $need_data['pay_time'] = $pay_time;
        $need_data['state'] = $orderdistribution_order['state'];//
        $need_data['delivery_note'] = $delivery_note;
		
        $need_data['order_info'] = D('Home/SzyOrder')->getOrderGoodsByOrderId( $orderdistribution_order['order_id'] );

	  	//商家配送货物时间
	    $order_delivery_history = M('lionfish_comshop_order_history')->where(array('order_id'=>$orderdistribution_order['order_id'],'order_status_id'=>4))->order('date_added asc')->find();
	    if(!empty($order_delivery_history)){
			$need_data['order_delivery_time'] = date('Y-m-d H:i:s',$order_delivery_history['date_added']);
	    }else{
			$need_data['order_delivery_time'] = '';
		}
	   $need_data['payment_code'] = $order_info['payment_code'];
	    //货到付款收款码
	   if($order_info['payment_code'] == 'cashon_delivery'){
		   $need_data['cashondelivery_code_img'] = D('Home/Front')->getCashonDeliveryCode();
	   }

        return $need_data;
   }

	/**
		@author yj 2020-06-10 
		@desc 根据会员id找到配送单数量
	**/
	public function get_distribution_ordercount_bymember_id( $member_id, $state )
	{
		$orderdistribution_id = $this->get_distribution_id_by_member_id($member_id);
		
		if( $orderdistribution_id > 0 )
		{
			$count = $this->get_distribution_ordercount( $orderdistribution_id , $state );
			return $count;
		}else{
			return 0;
		}
		
	}
	
	/**
		@author yj 2020-06-10
		@desc 根据会员id，找到 配送员id 
	**/
	public function get_distribution_id_by_member_id($member_id)
	{

		$orderdistribution_info = M('lionfish_comshop_orderdistribution')->field('id')->where( array('member_id' => $member_id) )->find();
		
		if( !empty($orderdistribution_info) )
		{
			return $orderdistribution_info['id'];
		}else { 
			return 0;
		}
	}
   
	/**
		@author yj 2020-06-10
		@desc 获取一个配送员某个状态下的配送订单数量
	**/
	public function get_distribution_ordercount( $orderdistribution_id , $state )
	{
		$count = M('lionfish_comshop_orderdistribution_order')->where( array('orderdistribution_id' => $orderdistribution_id, 'state' => $state ) )->count();
		
		
		return $count;
	}
	/**
		@author yj 2020-06-10
		@desc 获取一个配送员某个状态下的配送订单数量
	**/
	public function get_distribution_system_send_ordercount( $orderdistribution_id , $state )
	{
		$count = M('lionfish_comshop_orderdistribution_order')->where( array('is_admin_assign'=>1, 'orderdistribution_id' => $orderdistribution_id, 'state' => $state ) )->count();
		
		return $count;
	}
	
	
	/**
		@author yj 2020-06-10
		@desc 根据会员id, 骑手手中待取货用户的位置列表
	**/
	public function get_distribution_waitget_memberlist_by_memberid( $member_id )
	{
		$orderdistribution_id = $this->get_distribution_id_by_member_id($member_id);
		
		if( $orderdistribution_id > 0 )
		{
			$list = $this->get_distribution_waitget_memberlist( $orderdistribution_id  );
			return $list;
		}else{
			return array();
		}
	}
	
	/**
		@author yj 2020-06-10
		@desc 根据会员id, 骑手 手中   配送中 用户的位置列表
	**/
	public function get_distribution_sending_memberlist_by_memberid( $member_id )
	{
		$orderdistribution_id = $this->get_distribution_id_by_member_id($member_id);
		
		if( $orderdistribution_id > 0 )
		{
			$list = $this->get_distribution_sending_memberlist( $orderdistribution_id  );
			return $list;
		}else{
			return array();
		}
	}
	
	/**
		@author yj 2020-06-10
		@desc 查找某个配送员 待取货的位置的列表   state 2
	**/
	public function get_distribution_waitget_memberlist( $orderdistribution_id )
	{
		$list = M('lionfish_comshop_orderdistribution_order')->field('order_id,shop_lon,shop_lat,member_lon,member_lat')->where( array('orderdistribution_id' => $orderdistribution_id, 'state' => 2) )->select();
		return $list;
	}
	
	/**
		@author yj 2020-06-10
		@desc 查找某个配送员 配送中的位置的列表  state 3 
	**/
	public function get_distribution_sending_memberlist( $orderdistribution_id )
	{
		$list = M('lionfish_comshop_orderdistribution_order')->field('order_id,shop_lon,shop_lat,member_lon,member_lat')->where( array('orderdistribution_id' => $orderdistribution_id, 'state' => 3) )->select();
		return $list;
	}
	
	/**
		@author yj 2020-06-10
		@desc 根据会员id 查找配送员头像、昵称
		$param member_id 会员id 
	**/
	public function get_distribution_info_by_memberid( $member_id )
	{
		$orderdistribution = M('lionfish_comshop_orderdistribution')->where( array('member_id' => $member_id ) )->find();
		
		$member_info = M('lionfish_comshop_member')->field('avatar,username as nickname ')->where( array('member_id' => $member_id ) )->find();
		
		$orderdistribution['avatar']   = $member_info['avatar'];
		$orderdistribution['nickname'] = $member_info['nickname'];
		
		return $orderdistribution;
	}
	
	/**
		@auth yj 2020-06-11
		@desc 根据配送id 获取 配送订单列表
		@param member_id 会员id  state 状态，2待取货， 3配送中， 4已送达 
	**/
	public function get_distribution_orderlist( $orderdistribution_id, $state, $offset, $perpage=10 )
	{
		$list = M('lionfish_comshop_orderdistribution_order')->field('id')->where( array('orderdistribution_id' => $orderdistribution_id , 'state' => $state) )->order('id desc')->limit($offset, $perpage)->select();
		
		$need_data = array();
		if( !empty($list) )
		{
			foreach( $list as $val )
			{
				$need_data[] = $this->get_localtown_orderinfo( $val['id'] );
			}
		}
	
		return $need_data;
	}
	/**
		@auth yj 2020-06-11
		@desc 根据会员id 获取 配送订单列表
		@param member_id 会员id  state 状态，2待取货， 3配送中， 4已送达 
	**/
	public function get_distribution_orderlist_by_member_id( $member_id, $state, $offset, $perpage=10 )
	{
		$orderdistribution_id = $this->get_distribution_id_by_member_id($member_id);
		$list = $this->get_distribution_orderlist( $orderdistribution_id, $state, $offset, $perpage);
		
		return $list;
	}
	
	/**
		@author yj 2020-06-11
		@desc 根据会员id 查询 系统分配的订单数量
		@param member_id 会员id
	**/
	public function get_system_send_ordercount_by_member_id( $member_id )
	{
		$orderdistribution_id = $this->get_distribution_id_by_member_id($member_id);
		
		
		if( $orderdistribution_id > 0 )
		{
			$wait_count = $this->get_distribution_system_send_ordercount( $orderdistribution_id , 2 );
			$sending_count = $this->get_distribution_system_send_ordercount( $orderdistribution_id , 3 );
			$sended_count = $this->get_distribution_system_send_ordercount( $orderdistribution_id , 4 );
			
			$total = $wait_count + $sending_count + $sended_count;
			
			return $total;
		}else{
			return 0;
		}
		
	}
	
	/**
		@author yj 2020-06-11
		@desc 获取配送员所得佣金
	**/
	public function get_commiss_by_member_id( $member_id )
	{
		$commiss_info = M('lionfish_comshop_orderdistribution_commiss')->where( array('member_id' => $member_id ) )->find();
		
		if( empty($commiss_info) )
		{
			return array('money' => 0, 'dongmoney' => 0, 'getmoney' => 0);
		}else{
			return array('money' => $commiss_info['money'], 'dongmoney' => $commiss_info['dongmoney'], 'getmoney' => $commiss_info['getmoney']);
		}
		
	}

	/**
	 * @author cy 2020-12-22
	 * @desc 获得配送员所得佣金
	 * @param $orderdistribution_id
	 */
	public function get_commiss_by_orderdistribution_id( $orderdistribution_id ){
		$commiss_info = M('lionfish_comshop_orderdistribution_commiss')->where( array('orderdistribution_id' => $orderdistribution_id ) )->find();

		if( empty($commiss_info) )
		{
			return array('money' => 0, 'dongmoney' => 0, 'getmoney' => 0);
		}else{
			return array('money' => $commiss_info['money'], 'dongmoney' => $commiss_info['dongmoney'], 'getmoney' => $commiss_info['getmoney']);
		}
	}
	
	public function get_commiss_info( $orderdistribution_id )
	{
		M('lionfish_comshop_orderdistribution_commiss')->where( array('') )->find();
	}
	
	
}
?>