<?php
namespace Lib\Weixin; 

class Jssdk {
  private $appId;
  private $appSecret;

  public function __construct($appId, $appSecret) {
    $this->appId = $appId;
    $this->appSecret = $appSecret;
  }

  public function getSignPackage() {
    $jsapiTicket = $this->getJsApiTicket();

    // 注意 URL 一定要动态获取，不能 hardcode.
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
 
	if( strpos(C('SITE_URL'), 'https://')  !== false)
	{
		$protocol = 'https://';
	}
	
	$protocol = 'https://';
	//var_dump($protocol,$_SERVER );die();
	$url = "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	//var_dump($url);die();
    $timestamp = time();
    $nonceStr = $this->createNonceStr();

    // 这里参数的顺序要按照 key 值 ASCII 码升序排序
    $string = "jsapi_ticket=$jsapiTicket&noncestr=$nonceStr&timestamp=$timestamp&url=$url";

    $signature = sha1($string);

    $signPackage = array(
      "appId"     => $this->appId,
      "nonceStr"  => $nonceStr,
      "timestamp" => $timestamp,
      "url"       => $url,
      "signature" => $signature,
      "rawString" => $string
    );
    return $signPackage; 
  }
  public function getsnsapi_userinfo()
  {
	 
		 // 注意 URL 一定要动态获取，不能 hardcode.
		$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
		
		$protocol = "https://";
		$url = "$protocol$_SERVER[HTTP_HOST]".U('Public/wxauthcallback');
		
		$access_token = $this->getAccessToken();
		$redirect_uri = urlencode($url);
		
		$pos = strpos($_SERVER['HTTP_REFERER'], '/mp/redirect?url=');
		//var_dump($_SERVER['HTTP_REFERER']);die();
		if ($pos === false) {
			
			$pos2 = strpos($_SERVER['HTTP_REFERER'], '/wapredirect?url=');
			if ($pos2 === false) {
				$state = base64_encode($_SERVER['HTTP_REFERER']);
			} else {
				$red_par = explode('/wapredirect?url=',$_SERVER['HTTP_REFERER']);
				
				if(isset($red_par[1]) && !empty($red_par[1]))
				{
					
					$act_par = explode('&action=',$red_par[1]);
					if(isset($act_par[1]) && !empty($act_par[1]))
					{
						//var_dump($act_par[0]);die();
						$state = base64_encode($act_par[0]);	
					}else 
						$state = base64_encode($red_par[1]);	
				} else {
					$state = base64_encode($_SERVER['HTTP_REFERER']);	
				}
			}			
		}else {
			
			
			$red_par = explode('/mp/redirect?url=',$_SERVER['HTTP_REFERER']);
			//var_dump($red_par);die();
			if(isset($red_par[1]) && !empty($red_par[1]))
			{
				$state = base64_encode($red_par[1]);	
			} else {
				$state = base64_encode($_SERVER['HTTP_REFERER']);	
			}
		}
		$base_url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={$this->appId}&redirect_uri={$redirect_uri}&response_type=code&scope=snsapi_userinfo&state={$state}#wechat_redirect";
		
		
		header("Location: {$base_url}");
		exit;
  }
  
  public function cgigetinfo($openid)
  {
		$url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token={$this->getAccessToken()}&openid={$openid}&lang=zh_CN";
		
		$res = json_decode($this->httpGet($url));
		
		
		if($res->errcode == 41001)
		{
			$this->reflush_token();
			
			
			$url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token={$this->getAccessToken()}&openid={$openid}&lang=zh_CN";
			
			$res = json_decode($this->httpGet($url));
			
		}
		//var_dump($res);die();
		$subscribe = $res->subscribe;
		return $subscribe;
  }
public function getSnsapiUserinfo($auth_accsss_info)
{
	$url = "https://api.weixin.qq.com/sns/userinfo?access_token={$auth_accsss_info[access_token]}&openid={$auth_accsss_info[openid]}&lang=zh_CN";
	
    $res = json_decode($this->httpGet($url));
	
	$info = array();
	$info['openid'] = $res->openid;
	$info['nickname'] = trim(WeChatEmoji::clear($res->nickname));
	$info['sex'] =$res->sex;
	$info['province'] = $res->province;
	$info['city'] = $res->city;
	$info['country'] = $res->country;
	$info['headimgurl'] = $res->headimgurl;
	$info['unionid'] = $res->unionid;
	return $info;
	
}
  
  private function createNonceStr($length = 16) {
    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $str = "";
    for ($i = 0; $i < $length; $i++) {
      $str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
    }
    return $str;
  }
 public  function getAutoAccessToken($code)
 {
	 
	 $url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={$this->appId}&secret={$this->appSecret}&code={$code}&grant_type=authorization_code";
     $res = json_decode($this->httpGet($url));
	 $info = array();
	 $info['access_token'] = $res->access_token;
	 $info['openid'] = $res->openid;
	  
    return $info;
 }
  private function getJsApiTicket() {
    // jsapi_ticket 应该全局存储与更新，以下代码以写入到文件中做示例
    $data = json_decode(S('jsapi_ticket'));
   
    if ($data->expire_time < time() || empty( $data )) {
      $accessToken = $this->getAccessToken();
      // 如果是企业号用以下 URL 获取 ticket
      // $url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=$accessToken";
      $url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=$accessToken";
      $res = json_decode($this->httpGet($url));
      $ticket = $res->ticket;
      if ($ticket) {
        $data->expire_time = time() + 7000;
        $data->jsapi_ticket = $ticket;
        S('jsapi_ticket',json_encode($data));
      }
    } else {
      $ticket = $data->jsapi_ticket;
    }

    return $ticket;
  }
	
/**
	自提核销码
**/	
  public function getWeQrcode($quan_sn)
  {
	  $access_token = $this->getweAccessToken();
	  $url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$access_token}";
	  
	  //scene
	  //page
	  //width 430 
	  //auto_color  true
	  $data = array();
	  $data['scene'] = $quan_sn;
	  $data['page'] = 'lionfish_comshop/pages/order/hexiao';
	  $data['width'] = 430;
	  $data['auto_color'] = true;
	  
	  $data_json = json_encode($data);
	  //string(64) "{"errcode":41030,"errmsg":"invalid page hint: [nXeXeA0884wxa7]"}"

	  $res_code =  $this->http_request($url,$data_json);
	  
	  if(isset($res_code['errcode']) && $res_code['errcode']> 0)
	  {
	      $access_token = $this->getweAccessToken(true);
	      $url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$access_token}";
	  
    	  $data = array();
    	  $data['scene'] = $quan_sn;
    	  $data['page'] = 'lionfish_comshop/pages/order/hexiao';
    	  $data['width'] = 430;
    	  $data['auto_color'] = true;
    	  
    	  $data_json = json_encode($data);
    
    	  $res_code =  $this->http_request($url,$data_json);
	  }
	  
	  return $res_code;
  }
  
  public function getAllWeQrcode($page,$scene, $is_png = false,$rgb_color='')
  {
	  $access_token = $this->getweAccessToken();
	
	  $url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$access_token}";
	  
	  //scene
	  //page
	  //width 430 
	  //auto_color  true
	  $data = array();
	  $data['scene'] = $scene;
	  $data['page'] = $page;
	  $data['width'] = 430;
	  $data['auto_color'] = false;
	  $data['line_color'] = array('r'=>"253","g"=>"35","b"=>"70");
	  if( !empty($rgb_color) )
	  {
		$data['line_color'] = $rgb_color;
	  }
	   if($is_png)
	  {
		  $data['is_hyaline'] = true;
	  }
	  
	  
	  
	  $data_json = json_encode($data);
	  //string(64) "{"errcode":41030,"errmsg":"invalid page hint: [nXeXeA0884wxa7]"}"

	  $res_code =  $this->http_request($url,$data_json);
	  
	   $json_data = json_decode( $res_code, true);
	   
	   if($json_data && $json_data['errcode']> 0)
	  {
	      $access_token = $this->getweAccessToken(true);
	      $url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={$access_token}";
	      
	      //scene
	      //page
	      //width 430
	      //auto_color  true
	      $data = array();
	      $data['scene'] = $scene;
	      $data['page'] = $page;
	      $data['width'] = 430;
	      $data['auto_color'] = false;
	      $data['line_color'] = array('r'=>"253","g"=>"35","b"=>"70");
		  if($is_png)
		  {
			  $data['is_hyaline'] = true;
		  }
	      $data_json = json_encode($data);
	      //string(64) "{"errcode":41030,"errmsg":"invalid page hint: [nXeXeA0884wxa7]"}"
		  
	      $res_code =  $this->http_request($url,$data_json);
	  }
	  
	  return $res_code;
  }
  
  public function getweAccessToken($is_parse = false) {
    // access_token 应该全局存储与更新，以下代码以写入到文件中做示例
	
    return $this->getAccessToken($is_parse);
  }
  
  function http_request($url,$data = null,$headers=array())
	{
		$curl = curl_init();
		if( count($headers) >= 1 ){
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		}
		curl_setopt($curl, CURLOPT_URL, $url);

		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);

		if (!empty($data)){
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
		}
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($curl);
		curl_close($curl);
		return $output;
	}
  public function reflush_token()
  {
		$data = json_decode(S('access_token'));
		
		  // 如果是企业号用以下URL获取access_token
		  // $url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=$this->appId&corpsecret=$this->appSecret";
		  $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$this->appId&secret=$this->appSecret";
		  
		  $rr = $this->httpGet($url);
		  $res = json_decode($rr);
		  $access_token = $res->access_token;
		  
		//  var_dump($data ,$res,$rr);die();
		  if ($access_token) {
			$data->expire_time = time() + 3000;
			$data->access_token = $access_token;
			S('access_token',json_encode($data));
		  }
		
  }
  
  
  
  public function getAccessToken($is_parse=false) {
    // access_token 应该全局存储与更新，以下代码以写入到文件中做示例
	
  	$data = json_decode(S('new_access_token'));
	//var_dump($data);die();
	if ($data->expire_time < time() || empty( $data ) || $is_parse) {
      // 如果是企业号用以下URL获取access_token
      // $url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=$this->appId&corpsecret=$this->appSecret";
      $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$this->appId&secret=$this->appSecret";
	  
	  $res = json_decode($this->httpGet($url));
      $access_token = $res->access_token;
      if ($access_token) {
        $data->expire_time = time() + 3000;
        $data->access_token = $access_token;
        S('new_access_token',json_encode($data));
      }
    } else {
      $access_token = $data->access_token;
    }
    return $access_token;
  }

  private function httpGet($url) {
    $curl = curl_init();
	//$url = 'https://www.baidu.com';
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 500);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($curl, CURLOPT_URL, $url);
	//curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/600.3.18 (KHTML, like Gecko) Version/8.0.3 Safari/600.3.18");
    $res = curl_exec($curl);
	//var_dump($res);die();
    curl_close($curl);

    return $res;
  }
}

class WeChatEmoji {
		public static  function filter_utf8_char($ostr){		
		preg_match_all('/[\x{FF00}-\x{FFEF}|\x{0000}-\x{00ff}|\x{4e00}-\x{9fff}]+/u', $ostr, $matches);		
		$str = join('', $matches[0]);		
		if($str==''){ 			
			$returnstr = '';			
			$i = 0;			
			$str_length = strlen($ostr);			
				while ($i<=$str_length){				
				$temp_str = substr($ostr, $i, 1);				
				$ascnum = ord($temp_str);								
				if ($ascnum>=224)
				{					
					$returnstr = $returnstr.substr($ostr, $i, 3);					
					$i = $i + 3;				
				}elseif ($ascnum>=192)
				{			
					$returnstr = $returnstr.substr($ostr, $i, 2);					
					$i = $i + 2;				
				}elseif ($ascnum>=65 && $ascnum<=90){	
				
					$returnstr = $returnstr.substr($ostr, $i, 1);					
					$i = $i + 1;				
				}
				elseif ($ascnum>=128 && $ascnum<=191)
				{ 		
					$i = $i + 1;				
				}else{					
					$returnstr = $returnstr.substr($ostr, $i, 1);					
					$i = $i + 1;			
				}			
			}			
			$str = $returnstr;			
			preg_match_all('/[\x{FF00}-\x{FFEF}|\x{0000}-\x{00ff}|\x{4e00}-\x{9fff}]+/u', $str, $matches);		
			$str = join('', $matches[0]);		
		}		
		return $str;
	}	
	public static function clear($str) {
		$config = self::getList();		$str = self::filter_utf8_char($str) ? self::filter_utf8_char($str) : $str;
		$str = str_replace($config, '', $str);
		return $str;
	}

	public static function getList() {
		return array(
		    "\xee\x98\xbe", "\xee\x98\xbf", "\xee\x99\x80", "\xee\x99\x81", "\xee\x99\x82", "\xee\x99\x83", "\xee\x99\x84", "\xee\x99\x85", "\xee\x9a\xb3", "[\xe5\xa4\x95\xe7\x84\xbc\xe3\x81\x91]", "[\xe8\x99\xb9]", "[\xe9\x9b\xaa\xe7\xb5\x90\xe6\x99\xb6]", "\xee\x98\xbe\xee\x98\xbf", "\xee\x9c\xbf", "[\xe7\x81\xab\xe5\xb1\xb1]", "[\xe5\x9c\xb0\xe7\x90\x83]", "\xee\x9a\x9c", "\xee\x9a\x9d", "\xee\x9a\x9e", "\xee\x9a\x9f", "\xee\x9a\xa0", "[\xe2\x98\x86]", "\xe2\x98\x86\xe5\xbd\xa1", "\xee\x9a\xba", "\xee\x9c\x9f", "\xee\x9c\x9c", "\xee\x99\x86", "\xee\x99\x87", "\xee\x99\x88", "\xee\x99\x89", "\xee\x99\x8a", "\xee\x99\x8b", "\xee\x99\x8c", "\xee\x99\x8d", "\xee\x99\x8e", "\xee\x99\x8f", "\xee\x99\x90", "\xee\x99\x91", "[\xe8\x9b\x87\xe4\xbd\xbf\xe5\xba\xa7]", "\xee\x9d\x81", "\xee\x9d\x83", "\xee\x9d\x86", "\xee\x9d\x87", "\xee\x9d\x88", "[\xe3\x83\x90\xe3\x83\xa9]", "[\xe9\xa2\xa8\xe3\x81\xab\xe8\x88\x9e\xe3\x81\x86\xe8\x91\x89]", "[\xe3\x83\x8f\xe3\x82\xa4\xe3\x83\x93\xe3\x82\xb9\xe3\x82\xab\xe3\x82\xb9]", "[\xe3\x81\xb2\xe3\x81\xbe\xe3\x82\x8f\xe3\x82\x8a]", "[\xe3\x83\xa4\xe3\x82\xb7]", "[\xe3\x82\xb5\xe3\x83\x9c\xe3\x83\x86\xe3\x83\xb3]", "[\xe7\xa8\xb2\xe7\xa9\x82]", "[\xe3\x81\xa8\xe3\x81\x86\xe3\x82\x82\xe3\x82\x8d\xe3\x81\x93\xe3\x81\x97]", "[\xe3\x82\xad\xe3\x83\x8e\xe3\x82\xb3]", "[\xe6\xa0\x97]", "[\xe8\x8a\xb1]", "\xee\x9d\x82", "\xee\x9d\x84", "\xee\x9d\x85", "[\xe3\x81\xbf\xe3\x81\x8b\xe3\x82\x93]", "[\xe3\x82\xa4\xe3\x83\x81\xe3\x82\xb4]", "[\xe3\x82\xb9\xe3\x82\xa4\xe3\x82\xab]", "[\xe3\x83\x88\xe3\x83\x9e\xe3\x83\x88]", "[\xe3\x83\x8a\xe3\x82\xb9]", "[\xe3\x83\xa1\xe3\x83\xad\xe3\x83\xb3]", "[\xe3\x83\x91\xe3\x82\xa4\xe3\x83\x8a\xe3\x83\x83\xe3\x83\x97\xe3\x83\xab]", "[\xe3\x83\x96\xe3\x83\x89\xe3\x82\xa6]", "[\xe3\x83\xa2\xe3\x83\xa2]", "\xee\x9a\x91", "\xee\x9a\x92", "[\xe9\xbc\xbb]", "\xee\x9b\xb9", "\xee\x9c\xa8", "\xee\x9c\x90", "[\xe3\x83\x9e\xe3\x83\x8b\xe3\x82\xad\xe3\x83\xa5\xe3\x82\xa2]", "[\xe3\x82\xa8\xe3\x82\xb9\xe3\x83\x86]", "\xee\x99\xb5", "[\xe5\xba\x8a\xe5\xb1\x8b]", "\xee\x9a\xb1", "\xee\x9b\xb0", "[\xe5\xae\xb6\xe6\x97\x8f]", "[\xe3\x82\xab\xe3\x83\x83\xe3\x83\x97\xe3\x83\xab]", "[\xe8\xad\xa6\xe5\xae\x98]", "[\xe3\x83\x90\xe3\x83\x8b\xe3\x83\xbc]", "[\xe8\x8a\xb1\xe5\xab\x81]", "[\xe7\x99\xbd\xe4\xba\xba]", "[\xe4\xb8\xad\xe5\x9b\xbd\xe4\xba\xba]", "[\xe3\x82\xa4\xe3\x83\xb3\xe3\x83\x89\xe4\xba\xba]", "[\xe3\x81\x8a\xe3\x81\x98\xe3\x81\x84\xe3\x81\x95\xe3\x82\x93]", "[\xe3\x81\x8a\xe3\x81\xb0\xe3\x81\x82\xe3\x81\x95\xe3\x82\x93]", "[\xe8\xb5\xa4\xe3\x81\xa1\xe3\x82\x83\xe3\x82\x93]", "[\xe5\xb7\xa5\xe4\xba\x8b\xe7\x8f\xbe\xe5\xa0\xb4\xe3\x81\xae\xe4\xba\xba]", "[\xe3\x81\x8a\xe5\xa7\xab\xe6\xa7\x98]", "[\xe3\x81\xaa\xe3\x81\xbe\xe3\x81\xaf\xe3\x81\x92]", "[\xe5\xa4\xa9\xe7\x8b\x97]", "[\xe3\x81\x8a\xe5\x8c\x96\xe3\x81\x91]", "[\xe5\xa4\xa9\xe4\xbd\xbf]", "[UFO]", "[\xe5\xae\x87\xe5\xae\x99\xe4\xba\xba]", "[\xe3\x82\xa2\xe3\x82\xaf\xe3\x83\x9e]", "[\xe3\x83\x89\xe3\x82\xaf\xe3\x83\xad]", "[\xe6\xa1\x88\xe5\x86\x85]", "[\xe8\xa1\x9b\xe5\x85\xb5]", "[\xe3\x83\x80\xe3\x83\xb3\xe3\x82\xb9]", "\xee\x9d\x8e", "[\xe3\x83\x98\xe3\x83\x93]", "\xee\x9d\x94", "[\xe3\x83\x8b\xe3\x83\xaf\xe3\x83\x88\xe3\x83\xaa]", "[\xe3\x82\xa4\xe3\x83\x8e\xe3\x82\xb7\xe3\x82\xb7]", "[\xe3\x83\xa9\xe3\x82\xaf\xe3\x83\x80]", "[\xe3\x82\xbe\xe3\x82\xa6]", "[\xe3\x82\xb3\xe3\x82\xa2\xe3\x83\xa9]", "[\xe3\x82\xb5\xe3\x83\xab]", "[\xe3\x83\x92\xe3\x83\x84\xe3\x82\xb8]", "[\xe3\x82\xbf\xe3\x82\xb3]", "[\xe5\xb7\xbb\xe8\xb2\x9d]", "[\xe3\x82\xb2\xe3\x82\xb8\xe3\x82\xb2\xe3\x82\xb8]", "[\xe3\x82\xa2\xe3\x83\xaa]", "[\xe3\x83\x9f\xe3\x83\x84\xe3\x83\x90\xe3\x83\x81]", "[\xe3\x81\xa6\xe3\x82\x93\xe3\x81\xa8\xe3\x81\x86\xe8\x99\xab]", "\xee\x9d\x91", "[\xe3\x82\xab\xe3\x83\xa1]", "\xee\x9d\x8f", "\xee\x9d\x90", "\xee\x9a\xa1", "[\xe3\x82\xa4\xe3\x83\xab\xe3\x82\xab]", "[\xe3\x83\x8d\xe3\x82\xba\xe3\x83\x9f]", "[\xe3\x83\x88\xe3\x83\xa9]", "\xee\x9a\xa2", "[\xe3\x82\xaf\xe3\x82\xb8\xe3\x83\xa9]", "\xee\x9d\x95", "[\xe3\x82\xaf\xe3\x83\x9e]", "[\xe3\x83\x8f\xe3\x83\xa0\xe3\x82\xb9\xe3\x82\xbf\xe3\x83\xbc]", "[\xe7\x89\x9b]", "[\xe3\x82\xa6\xe3\x82\xb5\xe3\x82\xae]", "[\xe3\x82\xab\xe3\x82\xa8\xe3\x83\xab]", "\xee\x9a\x98", "[\xe8\xbe\xb0]", "[\xe3\x83\x91\xe3\x83\xb3\xe3\x83\x80]", "\xee\x9b\xb1", "\xee\x9b\xb3", "\xee\x9b\xb4", "\xee\x9b\xb2", "\xee\x9c\xa3", "\xee\x9c\xa5", "\xee\x9c\xa6", "\xee\x9d\x93", "\xee\x9d\x92", "[\xe9\xa2\xa8\xe9\x82\xaa\xe3\x81\xb2\xe3\x81\x8d]", "\xee\x9c\xaa", "\xee\x9c\xa2", "\xee\x9c\xae", "\xee\x9c\xad", "\xee\x9d\x97", "\xee\x9c\xab", "\xee\x9c\xa4", "\xee\x9c\xa1", "\xee\x9c\xa0", "\xee\x9c\x81", "\xee\x9c\xac", "\xee\x9c\xa9", "\xee\x9c\xaf", "\xee\x9c\x8b", "m(_ _)m", "(/_\xef\xbc\xbc)", "(\xe3\x83\xbb\xc3\x97\xe3\x83\xbb)", "|(\xe3\x83\xbb\xc3\x97\xe3\x83\xbb)|", "(^-^)/", "\xef\xbc\xbc(^o^)\xef\xbc\x8f", "(>\xe4\xba\xba<)", "\xee\x99\xa3", "\xee\x99\xa4", "\xee\x99\xa5", "\xee\x99\xa6", "\xee\x99\xa7", "\xee\x99\xa8", "\xee\x99\xa9", "\xee\x99\xa9\xee\x9b\xaf", "\xee\x99\xaa", "\xee\x9c\xbe", "[\xe6\x95\x99\xe4\xbc\x9a]", "[\xe5\x99\xb4\xe6\xb0\xb4]", "[\xe3\x83\x87\xe3\x83\x91\xe3\x83\xbc\xe3\x83\x88]", "[\xe5\x9f\x8e]", "[\xe5\xb7\xa5\xe5\xa0\xb4]", "\xee\x99\xa1", "\xee\x9d\x8b", "\xee\x9d\x80", "[\xe6\x9d\xb1\xe4\xba\xac\xe3\x82\xbf\xe3\x83\xaf\xe3\x83\xbc]", "[\xe8\x87\xaa\xe7\x94\xb1\xe3\x81\xae\xe5\xa5\xb3\xe7\xa5\x9e]", "[\xe6\x97\xa5\xe6\x9c\xac\xe5\x9c\xb0\xe5\x9b\xb3]", "[\xe3\x83\xa2\xe3\x82\xa2\xe3\x82\xa4]", "\xee\x9a\x99", "\xee\x99\xb4", "[\xe3\x83\x96\xe3\x83\xbc\xe3\x83\x84]", "\xee\x9a\x9a", "\xee\x9c\x8e", "\xee\x9c\x91", "\xee\x9c\x9a", "[\xe3\x83\x8d\xe3\x82\xaf\xe3\x82\xbf\xe3\x82\xa4]", "[\xe5\xb8\xbd\xe5\xad\x90]", "[\xe3\x83\x89\xe3\x83\xac\xe3\x82\xb9]", "[\xe7\x9d\x80\xe7\x89\xa9]", "[\xe3\x83\x93\xe3\x82\xad\xe3\x83\x8b]", "\xee\x9c\x8f", "\xee\x9a\x82", "\xee\x9a\xad", "\xee\x9c\x95", "[$\xef\xbf\xa5]", "[\xe6\xa0\xaa\xe4\xbe\xa1]", "[\xe3\x82\xab\xe3\x83\xbc\xe3\x83\x89]", "\xee\x9b\x96", "[\xe9\xa3\x9b\xe3\x82\x93\xe3\x81\xa7\xe3\x81\x84\xe3\x81\x8f\xe3\x81\x8a\xe9\x87\x91]", "[\xe4\xb8\xad\xe5\x9b\xbd]", "[\xe3\x83\x89\xe3\x82\xa4\xe3\x83\x84]", "[\xe3\x82\xb9\xe3\x83\x9a\xe3\x82\xa4\xe3\x83\xb3]", "[\xe3\x83\x95\xe3\x83\xa9\xe3\x83\xb3\xe3\x82\xb9]", "[\xe3\x82\xa4\xe3\x82\xae\xe3\x83\xaa\xe3\x82\xb9]", "[\xe3\x82\xa4\xe3\x82\xbf\xe3\x83\xaa\xe3\x82\xa2]", "[\xe6\x97\xa5\xe3\x81\xae\xe4\xb8\xb8]", "[\xe9\x9f\x93\xe5\x9b\xbd]", "[\xe3\x83\xad\xe3\x82\xb7\xe3\x82\xa2]", "[USA]", "[\xe7\x82\x8e]", "\xee\x9b\xbb", "\xee\x9c\x98", "[\xe3\x83\x8f\xe3\x83\xb3\xe3\x83\x9e\xe3\x83\xbc]", "[\xe3\x83\x8d\xe3\x82\xb8]", "[\xe5\x8c\x85\xe4\xb8\x81]", "[\xe3\x83\x94\xe3\x82\xb9\xe3\x83\x88\xe3\x83\xab]", "[\xe5\x8d\xa0\xe3\x81\x84]", "[\xe8\x8b\xa5\xe8\x91\x89\xe3\x83\x9e\xe3\x83\xbc\xe3\x82\xaf]", "[\xe6\xb3\xa8\xe5\xb0\x84]", "[\xe8\x96\xac]", "[A]", "[B]", "[AB]", "[O]", "\xee\x9a\x84", "\xee\x9a\x85", "\xee\x9a\x86", "\xee\x9a\xa4", "[\xe3\x82\xb5\xe3\x83\xb3\xe3\x82\xbf]", "[\xe7\xa5\x9d\xe6\x97\xa5]", "[\xe8\x8a\xb1\xe7\x81\xab]", "[\xe9\xa2\xa8\xe8\x88\xb9]", "[\xe3\x82\xaf\xe3\x83\xa9\xe3\x83\x83\xe3\x82\xab\xe3\x83\xbc]", "[\xe9\x96\x80\xe6\x9d\xbe]", "[\xe3\x81\xb2\xe3\x81\xaa\xe7\xa5\xad\xe3\x82\x8a]", "[\xe5\x8d\x92\xe6\xa5\xad\xe5\xbc\x8f]", "[\xe3\x83\xa9\xe3\x83\xb3\xe3\x83\x89\xe3\x82\xbb\xe3\x83\xab]", "[\xe3\x81\x93\xe3\x81\x84\xe3\x81\xae\xe3\x81\xbc\xe3\x82\x8a]", "[\xe7\xb7\x9a\xe9\xa6\x99\xe8\x8a\xb1\xe7\x81\xab]", "[\xe9\xa2\xa8\xe9\x88\xb4]", "[\xe3\x83\x8f\xe3\x83\xad\xe3\x82\xa6\xe3\x82\xa3\xe3\x83\xb3]", "[\xe3\x82\xaa\xe3\x83\xa1\xe3\x83\x87\xe3\x83\x88\xe3\x82\xa6]", "[\xe4\xb8\x83\xe5\xa4\x95]", "[\xe3\x81\x8a\xe6\x9c\x88\xe8\xa6\x8b]", "\xee\x99\x9a", "\xee\x9a\x87", "\xee\x9a\x88", "\xee\x9b\x8e", "\xee\x9a\x89", "\xee\x9b\x90", "\xee\x9b\x93", "\xee\x9b\x8f", "[\xe6\x96\xb0\xe8\x81\x9e]", "[\xe3\x82\xb9\xe3\x83\x94\xe3\x83\xbc\xe3\x82\xab]", "[\xe3\x83\xa1\xe3\x82\xac\xe3\x83\x9b\xe3\x83\xb3]", "[\xe3\x82\xa2\xe3\x83\xb3\xe3\x83\x86\xe3\x83\x8a]", "[\xe9\x80\x81\xe4\xbf\xa1BOX]", "[\xe5\x8f\x97\xe4\xbf\xa1BOX]", "[ABCD]", "[abcd]", "[1234]", "[\xe8\xa8\x98\xe5\x8f\xb7]", "[ABC]", "\xee\x9a\xae", "\xee\x9a\xb2", "\xee\x9c\x96", "\xee\x9c\x99", "\xee\x9c\xb0", "[MD]", "[\xe3\x83\x95\xe3\x83\xad\xe3\x83\x83\xe3\x83\x94\xe3\x83\xbc]", "\xee\x9a\x8c", "[\xe7\x94\xbb\xe3\x81\xb3\xe3\x82\x87\xe3\x81\x86]", "[\xe3\x82\xab\xe3\x83\xac\xe3\x83\xb3\xe3\x83\x80\xe3\x83\xbc]", "[\xe3\x83\x95\xe3\x82\xa9\xe3\x83\xab\xe3\x83\x80]", "\xee\x9a\x83", "[\xe5\x90\x8d\xe6\x9c\xad]", "\xee\x9c\x8a", "[\xe3\x82\xb0\xe3\x83\xa9\xe3\x83\x95]", "[\xe5\xae\x9a\xe8\xa6\x8f]", "[\xe4\xb8\x89\xe8\xa7\x92\xe5\xae\x9a\xe8\xa6\x8f]", "\xee\x99\x92", "\xee\x99\x93", "\xee\x99\x94", "\xee\x99\x95", "\xee\x99\x96", "\xee\x99\x97", "\xee\x99\x98", "\xee\x99\x99", "\xee\x9c\x92", "\xee\x9c\xb3", "[\xe3\x83\x88\xe3\x83\xad\xe3\x83\x95\xe3\x82\xa3\xe3\x83\xbc]", "[\xe3\x83\x95\xe3\x83\x83\xe3\x83\x88\xe3\x83\x9c\xe3\x83\xbc\xe3\x83\xab]", "[\xe6\xb0\xb4\xe6\xb3\xb3]", "\xee\x99\x9b", "\xee\x99\x9c", "\xee\x99\x9d", "\xee\x99\x9e", "\xee\x99\x9f", "\xee\x99\xa0", "[\xe3\x83\x90\xe3\x82\xb9\xe5\x81\x9c]", "\xee\x99\xa2", "\xee\x9a\xa3", "[\xe9\xa7\x85]", "[\xe3\x83\xad\xe3\x82\xb1\xe3\x83\x83\xe3\x83\x88]", "[\xe3\x83\x88\xe3\x83\xa9\xe3\x83\x83\xe3\x82\xaf]", "[\xe6\xb6\x88\xe9\x98\xb2\xe8\xbb\x8a]", "[\xe6\x95\x91\xe6\x80\xa5\xe8\xbb\x8a]", "[\xe3\x83\x91\xe3\x83\x88\xe3\x82\xab\xe3\x83\xbc]", "\xee\x99\xab", "\xee\x99\xac", "\xee\x99\xad", "[\xe5\xb7\xa5\xe4\xba\x8b\xe4\xb8\xad]", "\xee\x9b\xb7", "[\xe3\x82\xad\xe3\x83\xa3\xe3\x83\xb3\xe3\x83\x97]", "\xee\x99\xb9", "[\xe8\xa6\xb3\xe8\xa6\xa7\xe8\xbb\x8a]", "[\xe3\x82\xb8\xe3\x82\xa7\xe3\x83\x83\xe3\x83\x88\xe3\x82\xb3\xe3\x83\xbc\xe3\x82\xb9\xe3\x82\xbf\xe3\x83\xbc]", "\xee\x99\xb6", "\xee\x99\xb7", "\xee\x99\xba", "\xee\x99\xbb", "\xee\x99\xbc", "\xee\x99\xbd", "\xee\x99\xbe", "\xee\x9a\xac", "[\xe6\xbc\x94\xe5\x8a\x87]", "\xee\x9a\x8b", "[\xe9\xba\xbb\xe9\x9b\x80]", "[\xe7\x9a\x84\xe4\xb8\xad]", "[777]", "[\xe3\x83\x93\xe3\x83\xaa\xe3\x83\xa4\xe3\x83\xbc\xe3\x83\x89]", "[\xe3\x82\xb5\xe3\x82\xa4\xe3\x82\xb3\xe3\x83\xad]", "[\xe3\x83\x9c\xe3\x83\xbc\xe3\x83\xaa\xe3\x83\xb3\xe3\x82\xb0]", "[\xe8\x8a\xb1\xe6\x9c\xad]", "[\xe3\x82\xb8\xe3\x83\xa7\xe3\x83\xbc\xe3\x82\xab\xe3\x83\xbc]", "\xee\x9b\xb6", "\xee\x9b\xbf", "[\xe3\x82\xb5\xe3\x83\x83\xe3\x82\xaf\xe3\x82\xb9]", "[\xe3\x82\xae\xe3\x82\xbf\xe3\x83\xbc]", "[\xe3\x83\x94\xe3\x82\xa2\xe3\x83\x8e]", "[\xe3\x83\x88\xe3\x83\xa9\xe3\x83\xb3\xe3\x83\x9a\xe3\x83\x83\xe3\x83\x88]", "[\xe3\x83\x90\xe3\x82\xa4\xe3\x82\xaa\xe3\x83\xaa\xe3\x83\xb3]", "[\xe6\xad\x8c\xe8\xa8\x98\xe5\x8f\xb7]", "\xee\x9a\x81", "\xee\x9a\x8a", "[\xe3\x83\xa9\xe3\x82\xb8\xe3\x82\xaa]", "[\xe3\x83\x93\xe3\x83\x87\xe3\x82\xaa]", "\xee\x9c\x97", "\xee\x9c\x9b", "[\xe8\x8a\xb1\xe6\x9d\x9f]", "\xee\x9b\xad", "[\xe7\xb5\x90\xe5\xa9\x9a\xe5\xbc\x8f]", "[18\xe7\xa6\x81]", "\xee\x9c\xb1", "\xee\x9c\xb6", "\xee\x9c\xb2", "[\xef\xbd\x89]", "\xee\x9b\xa0", "\xee\x9b\xa2", "\xee\x9b\xa3", "\xee\x9b\xa4", "\xee\x9b\xa5", "\xee\x9b\xa6", "\xee\x9b\xa7", "\xee\x9b\xa8", "\xee\x9b\xa9", "\xee\x9b\xaa", "\xee\x9b\xab", "[10]", "[\xe3\x83\x90\xe3\x83\xaa3]", "[\xe3\x83\x9e\xe3\x83\x8a\xe3\x83\xbc\xe3\x83\xa2\xe3\x83\xbc\xe3\x83\x89]", "[\xe3\x82\xb1\xe3\x83\xbc\xe3\x82\xbf\xe3\x82\xa4OFF]", "\xee\x99\xb3", "\xee\x9d\x89", "\xee\x9d\x8a", "\xee\x9d\x8c", "\xee\x9d\x8d", "[\xe3\x83\x95\xe3\x83\xa9\xe3\x82\xa4\xe3\x83\x91\xe3\x83\xb3]", "[\xe3\x82\xbd\xe3\x83\x95\xe3\x83\x88\xe3\x82\xaf\xe3\x83\xaa\xe3\x83\xbc\xe3\x83\xa0]", "[\xe3\x83\x9d\xe3\x83\x86\xe3\x83\x88]", "[\xe3\x81\xa0\xe3\x82\x93\xe3\x81\x94]", "[\xe3\x81\x9b\xe3\x82\x93\xe3\x81\xb9\xe3\x81\x84]", "[\xe3\x83\x91\xe3\x82\xb9\xe3\x82\xbf]", "[\xe3\x82\xab\xe3\x83\xac\xe3\x83\xbc]", "[\xe3\x81\x8a\xe3\x81\xa7\xe3\x82\x93]", "[\xe3\x81\x99\xe3\x81\x97]", "[\xe5\xbc\x81\xe5\xbd\x93]", "[\xe9\x8d\x8b]", "[\xe3\x82\xab\xe3\x82\xad\xe6\xb0\xb7]", "[\xe8\x82\x89]", "[\xe3\x82\x84\xe3\x81\x8d\xe3\x81\x84\xe3\x82\x82]", "[\xe3\x83\x94\xe3\x82\xb6]", "[\xe3\x83\x81\xe3\x82\xad\xe3\x83\xb3]", "[\xe3\x82\xa2\xe3\x82\xa4\xe3\x82\xb9\xe3\x82\xaf\xe3\x83\xaa\xe3\x83\xbc\xe3\x83\xa0]", "[\xe3\x83\x89\xe3\x83\xbc\xe3\x83\x8a\xe3\x83\x84]", "[\xe3\x82\xaf\xe3\x83\x83\xe3\x82\xad\xe3\x83\xbc]", "[\xe3\x83\x81\xe3\x83\xa7\xe3\x82\xb3]", "[\xe3\x82\xad\xe3\x83\xa3\xe3\x83\xb3\xe3\x83\x87\xe3\x82\xa3]", "[\xe3\x83\x97\xe3\x83\xaa\xe3\x83\xb3]", "[\xe3\x83\x8f\xe3\x83\x81\xe3\x83\x9f\xe3\x83\x84]", "[\xe3\x82\xa8\xe3\x83\x93\xe3\x83\x95\xe3\x83\xa9\xe3\x82\xa4]", "\xee\x99\xaf", "\xee\x99\xb0", "\xee\x99\xb1", "\xee\x99\xb2", "\xee\x9c\x9e", "\xee\x9d\x96", "\xee\x99\xb8", "\xee\x9a\x96", "\xee\x9a\x97", "\xee\x9a\xa5", "\xee\x9b\xb5", "\xee\x9c\x80", "\xee\x9c\xbc", "\xee\x9c\xbd", "[\xe2\x86\x91]", "[\xe2\x86\x93]", "[\xe2\x86\x92]", "[\xe2\x86\x90]", "[>]", "[<]", "[>>]", "[<<]", "\xe2\x96\xb2", "\xe2\x96\xbc", "[\xc3\x97]", "\xee\x9c\x82", "\xee\x9c\x83", "\xee\x9c\x84", "[\xef\xbc\x9f]", "\xee\x9c\x89", "\xee\x9b\x9f", "\xee\x9b\xac", "\xee\x9b\xae", "\xee\x9b\xaf", "\xee\x9b\xb8", "\xee\x9a\x8d", "\xee\x9a\x8e", "\xee\x9a\x8f", "\xee\x9a\x90", "\xee\x99\xbf", "\xee\x9a\x80", "\xee\x9a\x9b", "\xee\x9b\x9e", "\xee\x9c\xb7", "\xee\x9c\xb5", "\xee\x9c\x9d", "[\xe2\x99\x82]", "[\xe2\x99\x80]", "\xee\x99\xae", "\xee\x9c\x94", "\xee\x9c\xb8", "[\xe3\x83\x81\xe3\x82\xa7\xe3\x83\x83\xe3\x82\xaf\xe3\x83\x9e\xe3\x83\xbc\xe3\x82\xaf]", "\xee\x9b\x9b", "[COOL]", "\xee\x9b\x97", "\xee\x9b\x98", "\xee\x9b\x9d", "[SOS]", "[UP!]", "[VS]", "[\xe3\x82\xb3\xe3\x82\xb3]", "[\xe3\x82\xb5\xe3\x83\xbc\xe3\x83\x93\xe3\x82\xb9]", "\xee\x9c\xb9", "\xee\x9c\xba", "\xee\x9c\xbb", "[\xe6\x9c\x89]", "[\xe7\x84\xa1]", "[\xe6\x9c\x88]", "[\xe7\x94\xb3]", "[\xe5\x89\xb2]", "[\xe6\x8c\x87]", "[\xe5\x96\xb6]", "\xee\x9c\xb4", "[\xe7\xa5\x9d]", "[\xe5\xbe\x97]", "[\xe5\x8f\xaf]", "[\xef\xbc\x8b]", "[\xef\xbc\x8d]", "[\xc3\xb7]", "\xee\x9b\xbc", "\xee\x9b\xbe", "\xee\x9c\x85", "\xee\x9c\x86", "\xee\x9c\x87", "\xee\x9c\x88", "[\xe3\x82\xa6\xe3\x83\xb3\xe3\x83\x81]", "[\xe5\x8a\x9b\xe3\x81\x93\xe3\x81\xb6]", "[\xe3\x82\xaf\xe3\x83\xa9\xe3\x82\xaf\xe3\x83\xa9]", "[\xe3\x83\x95\xe3\x82\xad\xe3\x83\x80\xe3\x82\xb7]", "\xee\x9b\xba", "\xe2\x96\xa0", "\xe2\x97\x86", "[\xe8\x8a\xb1\xe4\xb8\xb8]", "[100\xe7\x82\xb9]", "\xee\x9b\x9a", "\xe2\x94\x94\xe2\x86\x92", "[\xe9\x9b\xbb\xe6\xb1\xa0]", "[\xe3\x82\xb3\xe3\x83\xb3\xe3\x82\xbb\xe3\x83\xb3\xe3\x83\x88]", "\xee\x9b\x9c", "\xee\x9b\x99", "\xee\x9c\x93", "[\xe3\x83\xa9\xe3\x82\xb8\xe3\x82\xaa\xe3\x83\x9c\xe3\x82\xbf\xe3\x83\xb3]", "[\xe3\x83\x96\xe3\x83\x83\xe3\x82\xaf\xe3\x83\x9e\xe3\x83\xbc\xe3\x82\xaf]", "[\xe3\x83\xaa\xe3\x83\xb3\xe3\x82\xaf]", "[\xe2\x86\x90BACK]", "\xee\x9a\xb9", "\xee\x9a\xb8", "\xee\x9a\xb7", "[TOP]", "\xee\x9a\x93", "\xee\x9a\x95", "\xee\x9a\x94", "\xee\x9b\xbd", "\xee\x9c\xa7", "[\xe4\xba\xba\xe5\xb7\xae\xe3\x81\x97\xe6\x8c\x87]", "[\xe6\x8b\x8d\xe6\x89\x8b]", "\xee\x92\x88", "\xee\x92\x8d", "\xee\x92\x8c", "\xee\x92\x85", "\xee\x92\x87", "\xee\x91\xa9", "\xee\x96\x98", "\xee\xab\xa8", "\xee\xab\xb1", "\xee\xab\xb4", "\xee\x97\x9a", "\xee\xab\xb2", "\xee\x92\x8a", "\xee\x92\x8e", "\xee\x92\xbf", "\xee\xad\xbc", "\xee\xad\x93", "\xee\xad\x9f", "\xee\x96\xb3", "\xee\x96\xa8", "\xee\x96\xa9", "\xee\x96\xaa", "\xee\x92\x86", "\xe2\x97\x8b", "\xee\x92\x89", "\xee\x92\x8b", "\xee\x91\xa8", "\xee\x96\x94", "\xee\x95\xba", "\xee\x95\xbb", "\xee\x91\xbc", "\xee\x92\x8f", "\xee\x92\x90", "\xee\x92\x91", "\xee\x92\x92", "\xee\x92\x93", "\xee\x92\x94", "\xee\x92\x95", "\xee\x92\x96", "\xee\x92\x97", "\xee\x92\x98", "\xee\x92\x99", "\xee\x92\x9a", "\xee\x92\x9b", "\xee\x94\x93", "\xee\x93\xa4", "\xee\xad\xbd", "\xee\x93\x8e", "\xee\x93\x8a", "\xee\x96\xba", "\xee\x97\x8d", "\xee\xaa\x94", "\xee\x93\xa3", "\xee\x93\xa2", "\xee\xaa\x96", "\xee\xac\xb6", "\xee\xac\xb7", "\xee\xac\xb8", "\xee\xad\x89", "\xee\xae\x82", "\xee\x93\x92", "\xee\xac\xb5", "\xee\xaa\xb9", "\xee\xaa\xba", "\xee\x93\x94", "\xee\x93\x8d", "\xee\xaa\xbb", "\xee\xaa\xbc", "\xee\xac\xb2", "\xee\xac\xb3", "\xee\xac\xb4", "\xee\xac\xb9", "\xee\xad\x9a", "\xee\x96\xa4", "\xee\x96\xa5", "\xee\xab\x90", "\xee\xab\x91", "\xee\xad\x87", "\xee\x94\x89", "\xee\xaa\xa0", "\xee\x94\x8b", "\xee\xaa\xa1", "\xee\xaa\xa2", "\xe3\x80\x93", "\xee\x93\xbc", "\xee\x93\xba", "\xee\x94\x81", "\xee\x97\x9d", "\xee\xab\x9b", "\xee\xab\xa9", "\xee\xac\x93", "\xee\xac\x94", "\xee\xac\x95", "\xee\xac\x96", "\xee\xac\x97", "\xee\xac\x98", "\xee\xac\x99", "\xee\xac\x9a", "\xee\xad\x84", "\xee\xad\x85", "\xee\x93\x8b", "\xee\x96\xbf", "\xee\x94\x8e", "\xee\x93\xac", "\xee\x93\xaf", "\xee\x93\xb8", "\xee\xac\x9c", "\xee\xad\xbe", "\xee\xac\xa2", "\xee\x93\x98", "\xee\xac\xa3", "\xee\xac\xa4", "\xee\xac\xa5", "\xee\xac\x9f", "\xee\xac\xa0", "\xee\x93\x99", "\xee\x97\x87", "\xee\xab\xac", "\xee\xac\x9e", "\xee\x93\x9d", "\xee\xad\x97", "\xee\xad\x98", "\xee\xac\x9d", "\xee\x93\x93", "\xee\x97\x94", "\xee\x93\xa0", "\xee\xad\xb6", "\xee\x97\x9b", "\xee\x93\x9c", "\xee\x93\x9f", "\xee\xac\x9b", "\xee\x97\x82", "\xee\x97\x80", "\xee\x93\x9b", "\xee\x91\xb0", "\xee\x93\xa1", "\xee\x93\x9e", "\xee\x97\x81", "\xee\xac\xa1", "\xee\x93\x97", "\xee\x93\x9a", "\xee\x93\xae", "\xee\xac\xbf", "\xee\xad\x86", "\xee\xad\x88", "\xee\x91\xb2", "\xee\xad\xa7", "\xee\xab\x8a", "\xee\xab\x80", "\xee\x96\xae", "\xee\xab\x8b", "\xee\xab\x89", "\xee\x97\x84", "\xee\xab\x81", "\xee\x93\xa7", "\xee\xab\x8d", "\xee\xab\x8f", "\xee\xab\x8e", "\xee\xab\x87", "\xee\xab\x88", "\xee\x91\xb1", "\xee\x91\xb1\xee\x96\xb1", "\xee\xab\x85", "\xee\xae\x80", "\xee\xad\xa4", "\xee\x93\xbb", "\xee\xad\xa9", "\xee\x91\xb3", "\xee\xab\x86", "\xee\xab\x82", "\xee\xad\x9d", "\xee\xab\x83", "\xee\x97\x85", "\xee\xab\x84", "\xee\xaa\xbf", "\xee\x97\x86", "\xee\x91\xb4", "\xee\x97\x83", "\xee\xad\xa1", "\xee\xad\xbf", "\xee\xad\xa3", "\xee\xad\xa0", "\xee\xad\xa5", "\xee\xad\xa8", "\xee\xad\x9e", "\xee\xad\xaa", "\xee\xad\xa6", "\xee\xab\x97", "\xee\xab\x98", "\xee\xab\x99", "\xee\xad\x90", "\xee\xad\x91", "\xee\xad\x92", "\xee\xae\x85", "\xee\xae\x86", "\xee\xae\x87", "\xee\xae\x88", "\xee\xab\x92", "\xee\x92\xab", "\xee\xac\x89", "\xee\x92\xad", "\xee\x97\x9e", "\xee\x97\x9f", "\xee\x92\xaa", "\xee\x92\xa3", "\xee\xaa\x81", "\xee\xab\xb3", "\xee\x92\xa4", "\xee\xaa\x80", "\xee\x96\xbb", "\xee\x97\x8f", "\xee\xab\xb6", "\xee\xab\xb7", "\xee\xab\xb8", "\xee\xab\xb9", "\xee\x92\xa9", "\xee\x92\xbd", "\xee\x96\xbd", "\xee\x93\x80", "\xee\x95\xb2", "\xee\xad\xac", "\xee\x96\xb7", "\xee\xac\xab", "\xee\x94\x9a", "\xee\xaa\x9f", "\xee\xac\xaa", "\xee\x93\xbe", "\xee\x96\xb6", "\xee\xad\xb7", "\xee\x97\x89", "\xee\xaa\x93", "\xee\xaa\x9e", "\xee\xad\xab", "\xee\xaa\xa3", "\xee\xaa\xa4", "\xee\x94\x8d", "\xee\x94\x84", "\xee\x92\x9c", "[\xe3\x81\xb5\xe3\x81\x8f\xe3\x82\x8d]", "\xee\x93\x87", "\xee\x97\x9c", "\xee\x95\xb9", "\xee\x95\xbc", "\xee\x95\xbd", "\xee\x96\x85", "\xee\xad\x9b", "\xee\xac\x91", "\xee\xac\x8e", "\xee\x97\x95", "\xee\xab\xba", "\xee\xac\x90", "\xee\xac\x8f", "\xee\x93\x8c", "\xee\xac\x92", "\xee\x97\x96", "\xee\x95\xb3", "\xee\x91\xbb", "\xee\x96\x83", "\xee\x96\x87", "\xee\x97\x8b", "\xee\x96\x81", "\xee\x95\xbf", "\xee\x94\x8a", "\xee\xaa\x8f", "\xee\x92\x80", "\xee\x94\x90", "\xee\xaa\x9a", "\xee\xac\xa6", "\xee\xac\xa7", "\xee\xac\xa9", "\xee\xac\xa8", "\xee\x96\x9f", "\xee\x93\x8f", "\xee\x96\xa0", "\xee\x93\x89", "\xee\xab\xb0", "\xee\x97\x99", "\xee\x97\x8c", "\xee\xaa\x9b", "\xee\xaa\x9c", "\xee\xab\xa3", "\xee\xab\xa4", "\xee\xab\xa5", "\xee\xab\xa6", "\xee\xab\xa7", "\xee\xab\xab", "\xee\xab\xad", "\xee\xab\xae", "\xee\x91\xaf", "\xee\xac\xbd", "\xee\xab\xaf", "\xee\x96\x9b", "\xee\x96\x96", "\xee\x94\x9e", "\xee\x96\x88", "\xee\xac\x88", "\xee\xaa\x92", "\xee\x94\xa0", "\xee\x94\xa1", "\xee\x96\x91", "\xee\xad\xa2", "\xee\x94\x9b", "\xee\xac\x8a", "\xee\x96\x8b", "\xee\x94\x91", "\xee\x92\xa8", "\xee\x96\x92", "\xee\x96\x93", "\xee\x94\x9f", "\xee\xad\xb1", "\xee\xab\xbd", "\xee\xab\xbe", "\xee\xab\xbf", "\xee\xac\x80", "\xee\xad\x95", "\xee\xac\x83", "[\xe3\x81\x84\xe3\x81\x99]", "\xee\x96\xb8", "\xee\x92\xa1", "\xee\x92\xa0", "\xee\x97\x8e", "\xee\x96\x82", "\xee\x95\xa2", "\xee\x94\x8c", "\xee\x94\x96", "\xee\x95\xa0", "\xee\x95\xa1", "\xee\x95\xa9", "\xee\x95\xa3", "\xee\x96\x8f", "\xee\x96\x90", "\xee\x95\xab", "\xee\x92\x9f", "\xee\x92\x9d", "\xee\x95\xa8", "\xee\x95\xa5", "\xee\x95\xa6", "\xee\x95\xa7", "\xee\x95\xaf", "\xee\x94\x9d", "\xee\x95\x9f", "\xee\x95\xa4", "\xee\x95\xaa", "\xee\x95\xb4", "\xee\x95\xb5", "\xee\x95\xb6", "\xee\x95\xac", "\xee\x95\xad", "\xee\x95\xae", "\xee\x95\xb0", "\xee\x92\xa2", "\xee\xac\x8b", "\xee\x92\xba", "\xee\x96\x99", "\xee\x92\xb7", "\xee\x92\xb6", "\xee\xaa\xac", "\xee\x96\x9a", "\xee\x92\xb9", "\xee\x92\xb8", "\xee\x91\xab", "\xee\xad\x81", "\xee\x97\x93", "\xee\x92\xbb", "\xee\xab\x9e", "\xee\x92\xb5", "\xee\x96\xbc", "\xee\x92\xb0", "\xee\x92\xb1", "\xee\x92\xaf", "\xee\x92\xa7", "\xee\xaa\x82", "\xee\x92\xb3", "\xee\x92\xb4", "\xee\xad\xad", "\xee\x97\x88", "\xee\x92\xb2", "\xee\xab\x9f", "\xee\xab\xa0", "\xee\xab\xa1", "\xee\x95\xb1", "\xee\x92\xa6", "\xee\x91\xaa", "\xee\x97\x97", "\xee\xad\xb3", "\xee\x92\xbc", "\xee\x97\x90", "\xee\x91\xad", "\xee\xab\xa2", "\xee\xad\x82", "\xee\x94\x83", "\xee\x94\x97", "\xee\x94\x88", "\xee\x96\x9c", "\xee\xab\xb5", "\xee\x96\x9e", "\xee\x92\x9e", "\xee\x92\xbe", "\xee\x96\x9d", "\xee\x93\x86", "\xee\x97\x91", "\xee\x93\x85", "\xee\x91\xae", "\xee\xab\x9d", "\xee\x93\x88", "\xee\xad\x83", "\xee\xad\xae", "\xee\xad\xaf", "\xee\x96\xbe", "\xee\x94\x85", "\xee\x94\x86", "\xee\xad\x80", "\xee\xab\x9c", "\xee\x94\x87", "\xee\xab\x8c", "\xee\x94\x95", "\xee\x95\xbe", "\xee\x94\x82", "\xee\x96\xb9", "\xee\x96\x80", "\xee\x93\xab", "\xee\xad\xb8", "\xee\x94\x94", "\xee\x97\x8a", "\xee\xaa\x95", "\xee\xab\x9a", "\xee\xaa\x83", "\xee\x95\x98", "\xee\x95\x99", "\xee\x95\x8e", "\xee\x94\xb3", "\xee\xae\x84", "\xee\x94\xa2", "\xee\x94\xa3", "\xee\x94\xa4", "\xee\x94\xa5", "\xee\x94\xa6", "\xee\x94\xa7", "\xee\x94\xa8", "\xee\x94\xa9", "\xee\x94\xaa", "\xee\x96\xac", "\xee\x94\xab", "\xee\xaa\x84", "\xee\xaa\x90", "\xee\xaa\x91", "\xee\x93\x96", "\xee\x93\x95", "\xee\x93\x90", "\xee\x96\xb4", "\xee\xaa\xaf", "\xee\x93\x91", "\xee\xaa\xb0", "\xee\xaa\xb1", "\xee\xaa\xb2", "\xee\xaa\xb3", "\xee\xaa\xb4", "\xee\xaa\xb5", "\xee\xaa\xb6", "\xee\xaa\xb7", "\xee\xaa\xb8", "\xee\xaa\xbd", "\xee\xaa\xbe", "\xee\xab\xaa", "\xee\x93\x84", "\xee\x93\xad", "\xee\xac\xba", "\xee\xac\xbb", "\xee\xac\xbc", "\xee\xad\x8a", "\xee\xad\x8b", "\xee\xad\x8c", "\xee\xad\x8d", "\xee\xad\x8e", "\xee\xad\x8f", "\xee\xad\x96", "\xee\xad\x99", "\xee\xad\xb0", "\xee\x92\xac", "\xee\x96\x97", "\xee\x93\x82", "\xee\x93\x83", "\xee\xaa\xae", "\xee\xaa\x97", "\xee\x93\x81", "\xee\xaa\x98", "\xee\xac\xbe", "\xee\x95\x95", "\xee\x95\x8d", "\xee\x95\x8c", "\xee\x95\x96", "\xee\xac\xad", "\xee\xac\xae", "\xee\xad\xba", "\xee\xad\xbb", "\xee\x94\xbf", "\xee\x95\x80", "\xee\x95\x92", "\xee\x95\x93", "\xee\x94\xae", "\xee\x94\xad", "\xee\x94\xb0", "\xee\x94\xaf", "\xee\x95\x85", "\xee\x95\x84", "\xee\x95\x9a", "\xee\x95\x9b", "\xee\x95\x83", "\xee\x95\x82", "\xee\xaa\xad", "\xee\x95\x90", "\xee\x95\x91", "\xee\x92\x82", "\xee\xac\xaf", "\xee\xac\xb0", "\xee\x92\x83", "\xee\xac\xb1", "[\xe3\x83\x95\xe3\x83\xaa\xe3\x83\xbc\xe3\x83\x80\xe3\x82\xa4\xe3\x83\xa4\xe3\x83\xab]", "\xee\x96\x95", "\xee\xad\xb5", "\xee\x91\xb7", "\xee\x91\xb8", "\xee\xaa\xa6", "\xee\x93\xaa", "\xee\xaa\xa7", "\xee\xaa\xa8", "\xee\xaa\xa9", "\xee\xaa\xaa", "\xee\xad\x94", "\xee\x96\xaf", "\xee\xaa\xa5", "\xee\x96\xa1", "\xee\x96\xa2", "\xee\x96\xa3", "\xee\x91\xbd", "\xee\x91\xbe", "\xee\x91\xbf", "\xee\xac\xac", "\xee\x92\x81", "\xee\x92\x84", "\xee\xad\xb9", "\xee\x92\xae", "\xee\xad\xb2", "\xee\x97\x98", "\xee\x92\xa5", "[\xe3\x83\x89\xe3\x82\xa2]", "\xee\x95\x81", "\xee\x95\x97", "\xee\x96\xab", "\xee\xaa\x85", "\xee\x95\xb8", "\xee\xaa\x88", "\xee\x96\xb5", "[NG]", "\xee\x96\xad", "\xee\x93\xa8", "\xee\x94\x8f", "\xee\x97\x92", "\xee\xaa\x87", "[\xe7\xa6\x81]", "\xee\xaa\x8a", "[\xe5\x90\x88]", "\xee\xaa\x89", "\xee\xaa\x86", "\xee\xaa\x8b", "\xee\xaa\x8c", "\xee\x93\xb1", "\xee\xaa\x99", "\xee\x93\xb7", "\xee\xac\x81", "\xee\x94\xbc", "\xee\x94\xbd", "\xee\x95\x8f", "\xee\x95\x94", "\xee\x91\xb6", "\xee\x93\xa5", "\xee\x91\xba", "\xee\x91\xb5", "\xee\x96\xb0", "\xee\x96\xb1", "\xee\x93\xa6", "\xee\x93\xb4", "\xee\x93\xb5", "\xee\x93\xa9", "\xee\xad\x9c", "\xee\x93\xbd", "\xee\xaa\xab", "\xee\x91\xb9", "\xee\x94\xbe", "\xee\x94\xba", "\xee\x94\xbb", "\xee\x95\x8a", "\xee\x95\x8b", "\xee\x95\x88", "\xee\x95\x89", "\xee\x94\xb1", "\xee\x94\xb2", "\xee\x94\xb4", "\xee\x94\xb5", "\xee\x94\xb8", "\xee\x94\xb9", "\xee\x95\x86", "\xee\x95\x87", "\xee\x94\xb6", "\xee\x94\xb7", "\xee\x91\xac", "\xee\x93\xb0", "\xee\x93\xb2", "\xee\x95\x9d", "\xee\x95\x9c", "\xee\xac\x8d", "\xee\x96\x84", "\xee\x96\x89", "\xee\x94\x98", "\xee\xac\x85", "\xee\x94\x9c", "\xee\xac\x8c", "\xee\xab\xbc", "\xee\x94\x99", "\xee\x94\x92", "\xee\xac\x82", "\xee\xac\x84", "\xee\xac\x87", "\xee\x96\x8a", "\xee\xac\x86", "[end]", "[ON]", "[SOON]", "\xee\x95\x9e", "\xee\xae\x83", "\xee\x96\xa7", "\xee\x96\xa6", "\xee\x93\xb3", "\xee\x93\xb9", "\xee\x93\xb6", "\xee\xaa\x8d", "\xee\xaa\x8e", "\xee\x93\xbf", "\xee\x94\x80", "\xee\xab\x96", "\xee\xab\x93", "\xee\xab\x94", "\xee\xab\x95", "\xee\x81\x8a", "\xee\x81\x89", "\xee\x81\x8b", "\xee\x81\x88", "\xee\x84\xbd", "\xee\x91\x83", "[\xe9\x9c\xa7]", "\xee\x90\xbc", "\xee\x91\x8b", "\xee\x81\x8d", "\xee\x91\x89", "\xee\x85\x86", "\xee\x91\x8a", "\xee\x91\x8c", "\xee\x81\x8a\xee\x81\x89", "\xee\x90\xbe", "\xe2\x97\x8f", "\xee\x81\x8c", "\xee\x8c\xb5", "\xee\x80\xa4", "\xee\x80\xa5", "\xee\x80\xa6", "\xee\x80\xa7", "\xee\x80\xa8", "\xee\x80\xa9", "\xee\x80\xaa", "\xee\x80\xab", "\xee\x80\xac", "\xee\x80\xad", "\xee\x80\xae", "\xee\x80\xaf", "[\xe8\x85\x95\xe6\x99\x82\xe8\xa8\x88]", "[\xe7\xa0\x82\xe6\x99\x82\xe8\xa8\x88]", "\xee\x88\xbf", "\xee\x89\x80", "\xee\x89\x81", "\xee\x89\x82", "\xee\x89\x83", "\xee\x89\x84", "\xee\x89\x85", "\xee\x89\x86", "\xee\x89\x87", "\xee\x89\x88", "\xee\x89\x89", "\xee\x89\x8a", "\xee\x89\x8b", "\xee\x84\x90", "\xee\x8c\x84", "\xee\x84\x98", "\xee\x80\xb0", "\xee\x80\xb2", "\xee\x84\x99", "\xee\x91\x87", "\xee\x8c\x83", "\xee\x8c\x85", "\xee\x8c\x87", "\xee\x8c\x88", "\xee\x91\x84", "[\xe3\x81\x95\xe3\x81\x8f\xe3\x82\x89\xe3\x82\x93\xe3\x81\xbc]", "[\xe3\x83\x90\xe3\x83\x8a\xe3\x83\x8a]", "\xee\x8d\x85", "\xee\x8d\x86", "\xee\x8d\x87", "\xee\x8d\x88", "\xee\x8d\x89", "\xee\x8d\x8a", "\xee\x90\x99", "\xee\x90\x9b", "\xee\x90\x9a", "\xee\x90\x9c", "\xee\x90\x89", "\xee\x8c\x9c", "\xee\x8c\x9d", "\xee\x8c\x9e", "\xee\x8c\x9f", "\xee\x8c\xa0", "\xee\x80\x81", "\xee\x80\x82", "\xee\x80\x84", "\xee\x80\x85", "\xee\x90\xa8", "\xee\x85\x92", "\xee\x90\xa9", "\xee\x84\x9b", "\xee\x81\x8e", "\xee\x84\x8c", "\xee\x84\xab", "\xee\x84\x9a", "\xee\x84\x9c", "\xee\x89\x93", "[\xe3\x82\xab\xe3\x82\xbf\xe3\x83\x84\xe3\x83\xa0\xe3\x83\xaa]", "\xee\x84\xb4", "\xee\x84\x8a", "\xee\x91\x81", "\xee\x80\x99", "\xee\x81\x95", "\xee\x81\x92", "\xee\x81\x93", "\xee\x81\x90", "\xee\x81\x8f", "\xee\x81\x94", "\xee\x80\x9a", "\xee\x84\x89", "\xee\x84\x8b", "\xee\x81\x91", "\xee\x94\xac", "\xee\x81\x99", "\xee\x90\x83", "\xee\x90\x90", "\xee\x81\x98", "\xee\x90\x86", "\xee\x90\x8f", "\xee\x90\x8e", "\xee\x84\x86", "\xee\x90\x84", "\xee\x84\x85", "\xee\x81\x96", "\xee\x90\x98", "\xee\x90\x97", "\xee\x90\x8c", "\xee\x90\x8d", "\xee\x81\x97", "\xee\x90\x95\xee\x8c\xb1", "\xee\x90\x8a", "\xee\x90\x92", "\xee\x90\x94", "\xee\x90\x95", "\xee\x90\x93", "\xee\x90\x91", "\xee\x90\x8b", "\xee\x90\x96", "\xee\x90\x87", "\xee\x84\x87", "\xee\x90\x88", "\xee\x90\x82", "\xee\x84\x88", "\xee\x90\x81", "\xee\x90\x85", "\xee\x90\xa3", "\xee\x90\xa4", "\xee\x90\xa6", "\xee\x80\x92", "\xee\x90\xa7", "\xee\x90\x9d", "\xee\x80\xb6", "\xee\x80\xb8", "\xee\x85\x93", "\xee\x85\x95", "\xee\x85\x8d", "\xee\x85\x94", "\xee\x85\x98", "\xee\x85\x96", "\xee\x85\x97", "\xee\x80\xb7", "\xee\x84\xa1", "\xee\x88\x82", "\xee\x8c\x8b", "\xee\x80\xbb", "\xee\x80\x87", "\xee\x84\xbe", "\xee\x8c\x9a", "\xee\x8c\x9b", "[\xe3\x83\xa1\xe3\x82\xac\xe3\x83\x8d]", "\xee\x80\x86", "[\xe3\x82\xb8\xe3\x83\xbc\xe3\x83\xb3\xe3\x82\xba]", "\xee\x84\x8e", "\xee\x8c\x82", "\xee\x8c\x98", "\xee\x8c\x99", "\xee\x8c\xa1", "\xee\x8c\xa2", "[\xe8\xb2\xa1\xe5\xb8\x83]", "\xee\x8c\xa3", "\xee\x84\xaf", "\xee\x85\x89", "\xee\x85\x8a", "\xef\xbf\xa5", "\xee\x84\x9d", "[\xe6\x87\x90\xe4\xb8\xad\xe9\x9b\xbb\xe7\x81\xaf]", "[\xe3\x83\xac\xe3\x83\xb3\xe3\x83\x81]", "\xee\x84\x96", "\xee\x84\x93", "\xee\x88\xbe", "\xee\x88\x89", "\xee\x80\xb1", "\xee\x84\xbb", "\xee\x8c\x8f", "\xee\x8c\x94", "\xee\x84\x92", "\xee\x8d\x8b", "\xee\x80\xb3", "\xee\x91\x88", "\xee\x85\x83", "\xee\x84\x97", "\xee\x8c\x90", "\xee\x8c\x92", "\xee\x90\xb6", "\xee\x90\xb8", "\xee\x90\xb9", "\xee\x90\xba", "\xee\x90\xbb", "\xee\x91\x80", "\xee\x91\x82", "\xee\x91\x85", "\xee\x91\x86", "[\xe3\x83\x9d\xe3\x82\xb1\xe3\x83\x99\xe3\x83\xab]", "\xee\x80\x89", "\xee\x80\x8a", "\xee\x84\x84", "\xee\x8c\x81", "\xee\x80\x8b", "\xee\x84\x83", "\xee\x84\x81", "\xee\x84\x82", "\xee\x85\x82", "\xee\x8c\x97", "\xee\x85\x8b", "[\xe3\x83\x9a\xe3\x83\xb3]", "\xee\x84\x9f", "\xee\x80\x8c", "[\xe3\x82\xaf\xe3\x83\xaa\xe3\x83\x83\xe3\x83\x97]", "\xee\x84\x9e", "\xee\x8c\x96", "\xee\x84\xa6", "\xee\x84\xa7", "\xee\x8c\x93", "\xee\x85\x88", "[\xe3\x82\xb9\xe3\x82\xaf\xe3\x83\xad\xe3\x83\xbc\xe3\x83\xab]", "\xee\x80\x96", "\xee\x80\x94", "\xee\x80\x95", "\xee\x80\x98", "\xee\x80\x93", "\xee\x90\xaa", "\xee\x84\xb2", "[\xe3\x82\xb9\xe3\x83\x8e\xe3\x83\x9c]", "\xee\x84\x95", "\xee\x80\x97", "\xee\x84\xb1", "\xee\x90\xab", "\xee\x90\xad", "\xee\x80\x9e", "\xee\x90\xb4", "\xee\x90\xb5", "\xee\x80\x9f", "\xee\x80\x9b", "\xee\x90\xae", "\xee\x85\x99", "\xee\x85\x90", "\xee\x80\x9d", "\xee\x80\x9c", "\xee\x80\xb9", "\xee\x84\x8d", "\xee\x84\xb5", "\xee\x85\x9a", "\xee\x90\xaf", "\xee\x90\xb0", "\xee\x90\xb1", "\xee\x90\xb2", "\xee\x80\xba", "\xee\x85\x8f", "\xee\x85\x8e", "\xee\x84\xb7", "\xee\x84\xa3", "\xee\x84\xa2", "\xee\x84\xa4", "\xee\x90\xb3", "\xee\x80\xbc", "\xee\x80\xbd", "\xee\x8c\x8a", "[\xe3\x82\xa4\xe3\x83\x99\xe3\x83\xb3\xe3\x83\x88]", "\xee\x84\xa5", "\xee\x8c\xa4", "[\xe3\x82\xb2\xe3\x83\xbc\xe3\x83\xa0]", "\xee\x84\xad", "\xee\x84\xb0", "\xee\x84\xb3", "\xee\x90\xac", "\xee\x80\xbe", "\xee\x8c\xa6", "\xee\x81\x80", "\xee\x81\x81", "\xee\x81\x82", "\xee\x84\xac", "\xee\x80\x88", "\xee\x84\xaa", "\xee\x84\xa8", "\xee\x84\xa9", "\xee\x80\x83", "\xee\x84\x83\xee\x8c\xa8", "\xee\x80\xb4", "\xee\x80\xb5", "\xee\x84\x91", "\xee\x8c\x86", "\xee\x90\xa5", "\xee\x90\xbd", "\xee\x88\x87", "\xee\x89\x8e", "\xee\x89\x8f", "\xee\x88\x90", "\xee\x88\x9c", "\xee\x88\x9d", "\xee\x88\x9e", "\xee\x88\x9f", "\xee\x88\xa0", "\xee\x88\xa1", "\xee\x88\xa2", "\xee\x88\xa3", "\xee\x88\xa4", "\xee\x88\xa5", "\xee\x88\x8b", "\xee\x89\x90", "\xee\x89\x91", "\xee\x84\xa0", "\xee\x8d\x82", "\xee\x81\x86", "\xee\x8d\x80", "\xee\x8c\xb9", "\xee\x85\x87", "\xee\x8c\xba", "\xee\x8c\xbb", "\xee\x8c\xbc", "\xee\x8c\xbd", "\xee\x8c\xbe", "\xee\x8c\xbf", "\xee\x8d\x81", "\xee\x8d\x83", "\xee\x8d\x84", "\xee\x8d\x8c", "\xee\x8d\x8d", "\xee\x90\xbf", "[\xe3\x81\xaa\xe3\x82\x8b\xe3\x81\xa8]", "\xee\x81\x83", "\xee\x81\x85", "\xee\x81\x84", "\xee\x81\x87", "\xee\x8c\xb8", "\xee\x8c\x8c", "\xee\x88\xb6", "\xee\x88\xb8", "\xee\x88\xb7", "\xee\x88\xb9", "\xe2\x87\x94", "\xe2\x86\x91\xe2\x86\x93", "\xee\x88\xb2", "\xee\x88\xb3", "\xee\x88\xb4", "\xee\x88\xb5", "\xee\x88\xba", "\xee\x88\xbb", "\xee\x88\xbc", "\xee\x88\xbd", "\xee\x8c\xb2", "\xee\x8c\xb3", "\xee\x80\xa1", "\xef\xbc\x81\xef\xbc\x9f", "\xef\xbc\x81\xef\xbc\x81", "\xee\x80\xa0", "\xee\x8c\xb6", "\xee\x8c\xb7", "\xef\xbd\x9e", "\xee\x88\x91", "\xee\x80\xa2", "\xee\x8c\xa7", "\xee\x80\xa3", "\xee\x8c\xa8", "\xee\x8c\xa9", "\xee\x8c\xaa", "\xee\x8c\xab", "\xee\x8c\xac", "\xee\x8c\xad", "\xee\x90\xb7", "\xee\x88\x84", "\xee\x88\x8c", "\xee\x88\x8e", "\xee\x88\x8d", "\xee\x88\x8f", "\xee\x8c\x8e", "\xee\x88\x88", "\xee\x88\x8a", "[\xe6\x97\x97]", "\xee\x89\x92", "\xee\x84\xb6", "\xee\x88\x81", "\xee\x84\xb8", "\xee\x84\xb9", "\xee\x84\xbf", "\xee\x85\x91", "\xee\x85\x80", "\xee\x8c\x89", "\xee\x84\xba", "[\xe7\xa6\x81\xe6\xad\xa2]", "[CL]", "\xee\x88\x94", "[FREE]", "\xee\x88\xa9", "\xee\x88\x92", "\xee\x89\x8d", "\xee\x88\x93", "\xee\x84\xae", "\xee\x88\x83", "\xee\x88\xa8", "\xee\x88\xab", "\xee\x88\xaa", "\xee\x88\x95", "\xee\x88\x96", "\xee\x88\x97", "\xee\x88\x98", "\xee\x88\xa7", "\xee\x88\xac", "\xee\x88\xad", "\xee\x8c\x95", "\xee\x8c\x8d", "\xee\x88\xa6", "\xee\x84\x8f", "\xee\x8c\xb4", "\xee\x8c\x91", "\xee\x84\xbc", "[\xe3\x83\x89\xe3\x83\xb3\xe3\x83\x83]", "\xee\x8c\xb1", "\xee\x8c\xb0", "\xee\x81\x9a", "\xee\x85\x8c", "\xee\x8c\xae", "\xee\x88\x85", "\xee\x88\x86", "\xee\x88\x99", "\xee\x88\x9a", "\xee\x88\x9b", "\xee\x8c\xaf", "\xe2\x86\x90\xe2\x94\x98", "\xee\x85\x81", "\xee\x84\x94", "\xee\x85\x84", "\xee\x85\x85", "\xee\x80\xbf", "\xee\x8c\xa5", "\xee\x89\x8c", "\xee\x80\x90", "\xee\x80\x91", "\xee\x80\x8d", "\xee\x80\x8e", "\xee\x80\x8f", "\xee\x88\xae", "\xee\x88\xaf", "\xee\x88\xb0", "\xee\x88\xb1", "\xee\x90\x9e", "\xee\x90\x9f", "\xee\x90\xa0", "\xee\x90\xa1", "\xee\x90\xa2", "\xf3\xbe\x80\x80", "\xf3\xbe\x80\x81", "\xf3\xbe\x80\x82", "\xf3\xbe\x80\x83", "\xf3\xbe\x80\x84", "\xf3\xbe\x80\x85", "\xf3\xbe\x80\x86", "\xf3\xbe\x80\x87", "\xf3\xbe\x80\x88", "\xf3\xbe\x80\x89", "\xf3\xbe\x80\x8a", "\xf3\xbe\x80\x8b", "\xf3\xbe\x80\x8c", "\xf3\xbe\x80\x8d", "\xf3\xbe\x80\x8e", "\xf3\xbe\x80\x8f", "\xf3\xbe\x80\x90", "\xf3\xbe\x80\xb8", "\xf3\xbe\x80\xba", "\xf3\xbe\x80\xbb", "\xf3\xbe\x80\xb9", "\xf3\xbe\x80\x91", "\xf3\xbe\x80\x92", "\xf3\xbe\x80\x93", "\xf3\xbe\x80\x94", "\xf3\xbe\x80\x95", "\xf3\xbe\x80\x96", "\xf3\xbe\xad\xa9", "\xf3\xbe\xad\xaa", "\xf3\xbe\x80\x9e", "\xf3\xbe\x80\x9f", "\xf3\xbe\x80\xa0", "\xf3\xbe\x80\xa1", "\xf3\xbe\x80\xa2", "\xf3\xbe\x80\xa3", "\xf3\xbe\x80\xa4", "\xf3\xbe\x80\xa5", "\xf3\xbe\x80\xa6", "\xf3\xbe\x80\xa7", "\xf3\xbe\x80\xa8", "\xf3\xbe\x80\xa9", "\xf3\xbe\x80\x9d", "\xf3\xbe\x80\x9c", "\xf3\xbe\x80\xaa", "\xf3\xbe\x80\x9b", "\xf3\xbe\x80\xab", "\xf3\xbe\x80\xac", "\xf3\xbe\x80\xad", "\xf3\xbe\x80\xae", "\xf3\xbe\x80\xaf", "\xf3\xbe\x80\xb0", "\xf3\xbe\x80\xb1", "\xf3\xbe\x80\xb2", "\xf3\xbe\x80\xb3", "\xf3\xbe\x80\xb4", "\xf3\xbe\x80\xb5", "\xf3\xbe\x80\xb6", "\xf3\xbe\x80\xb7", "\xf3\xbe\x80\xbc", "\xf3\xbe\x80\xbd", "\xf3\xbe\x80\xbe", "\xf3\xbe\x80\xbf", "\xf3\xbe\x81\x80", "\xf3\xbe\x81\x81", "\xf3\xbe\x81\x82", "\xf3\xbe\x81\x83", "\xf3\xbe\x81\x85", "\xf3\xbe\x81\x86", "\xf3\xbe\x81\x87", "\xf3\xbe\x81\x88", "\xf3\xbe\x81\x89", "\xf3\xbe\x81\x8a", "\xf3\xbe\x81\x8b", "\xf3\xbe\x81\x8c", "\xf3\xbe\x81\x8d", "\xf3\xbe\x81\x8e", "\xf3\xbe\x81\x8f", "\xf3\xbe\x81\x90", "\xf3\xbe\x81\x91", "\xf3\xbe\x81\x92", "\xf3\xbe\x81\x93", "\xf3\xbe\x81\x94", "\xf3\xbe\x81\x95", "\xf3\xbe\x81\x96", "\xf3\xbe\x81\x97", "\xf3\xbe\x81\x98", "\xf3\xbe\x81\x99", "\xf3\xbe\x81\x9a", "\xf3\xbe\x81\x9b", "\xf3\xbe\x86\x90", "\xf3\xbe\x86\x91", "\xf3\xbe\x86\x92", "\xf3\xbe\x86\x93", "\xf3\xbe\x86\x94", "\xf3\xbe\x86\x95", "\xf3\xbe\x86\x96", "\xf3\xbe\x86\x97", "\xf3\xbe\x86\x98", "\xf3\xbe\x86\x99", "\xf3\xbe\x86\x9a", "\xf3\xbe\x86\x9b", "\xf3\xbe\x86\x9c", "\xf3\xbe\x86\x9d", "\xf3\xbe\x86\x9e", "\xf3\xbe\x86\x9f", "\xf3\xbe\x86\xa0", "\xf3\xbe\x86\xa1", "\xf3\xbe\x86\xa2", "\xf3\xbe\x86\xa3", "\xf3\xbe\x86\xa4", "\xf3\xbe\x86\xa5", "\xf3\xbe\x86\xa6", "\xf3\xbe\x86\xa7", "\xf3\xbe\x86\xa8", "\xf3\xbe\x86\xa9", "\xf3\xbe\x86\xaa", "\xf3\xbe\x86\xab", "\xf3\xbe\x86\xac", "\xf3\xbe\x86\xad", "\xf3\xbe\x86\xae", "\xf3\xbe\x86\xaf", "\xf3\xbe\x86\xb0", "\xf3\xbe\x86\xb1", "\xf3\xbe\x86\xb2", "\xf3\xbe\x86\xb3", "\xf3\xbe\x86\xb4", "\xf3\xbe\x86\xb5", "\xf3\xbe\x86\xb6", "\xf3\xbe\x86\xb9", "\xf3\xbe\x87\x93", "\xf3\xbe\x9f\x9c", "\xf3\xbe\x87\x94", "\xf3\xbe\x87\x95", "\xf3\xbe\x87\x96", "\xf3\xbe\x87\x8c", "\xf3\xbe\x87\x8d", "\xf3\xbe\x87\x8e", "\xf3\xbe\x87\x8f", "\xf3\xbe\x87\x85", "\xf3\xbe\x87\x86", "\xf3\xbe\x87\x8b", "\xf3\xbe\x87\x9a", "\xf3\xbe\x87\xa1", "\xf3\xbe\x87\xa2", "\xf3\xbe\x87\x89", "\xf3\xbe\x87\x99", "\xf3\xbe\x87\x9c", "\xf3\xbe\x86\xba", "\xf3\xbe\x86\xbb", "\xf3\xbe\x87\x88", "\xf3\xbe\x87\x9d", "\xf3\xbe\x86\xbc", "\xf3\xbe\x87\x98", "\xf3\xbe\x86\xbd", "\xf3\xbe\x87\x87", "\xf3\xbe\x87\x82", "\xf3\xbe\x87\x80", "\xf3\xbe\x86\xb8", "\xf3\xbe\x87\x83", "\xf3\xbe\x86\xbe", "\xf3\xbe\x87\x84", "\xf3\xbe\x86\xb7", "\xf3\xbe\x86\xbf", "\xf3\xbe\x87\x81", "\xf3\xbe\x87\x8a", "\xf3\xbe\x87\x90", "\xf3\xbe\x87\x91", "\xf3\xbe\x87\x92", "\xf3\xbe\x87\x97", "\xf3\xbe\x87\x9b", "\xf3\xbe\x87\x9e", "\xf3\xbe\x87\x9f", "\xf3\xbe\x87\xa0", "\xf3\xbe\x8c\xa0", "\xf3\xbe\x8c\xa1", "\xf3\xbe\x8c\xa2", "\xf3\xbe\x8c\xa3", "\xf3\xbe\x8c\xa4", "\xf3\xbe\x8c\xa5", "\xf3\xbe\x8c\xa6", "\xf3\xbe\x8c\xa7", "\xf3\xbe\x8c\xa8", "\xf3\xbe\x8c\xa9", "\xf3\xbe\x8c\xaa", "\xf3\xbe\x8c\xab", "\xf3\xbe\x8c\xac", "\xf3\xbe\x8c\xad", "\xf3\xbe\x8c\xae", "\xf3\xbe\x8c\xaf", "\xf3\xbe\x8c\xb0", "\xf3\xbe\x8c\xb1", "\xf3\xbe\x8c\xb2", "\xf3\xbe\x8c\xb3", "\xf3\xbe\x8c\xb4", "\xf3\xbe\x8c\xb5", "\xf3\xbe\x8c\xb6", "\xf3\xbe\x8c\xb8", "\xf3\xbe\x8c\xb9", "\xf3\xbe\x8c\xba", "\xf3\xbe\x8c\xbb", "\xf3\xbe\x8c\xbc", "\xf3\xbe\x8c\xbd", "\xf3\xbe\x8c\xbe", "\xf3\xbe\x8c\xbf", "\xf3\xbe\x8d\x80", "\xf3\xbe\x8d\x81", "\xf3\xbe\x8d\x82", "\xf3\xbe\x8d\x83", "\xf3\xbe\x8d\x84", "\xf3\xbe\x8d\x85", "\xf3\xbe\x8d\x86", "\xf3\xbe\x8d\x87", "\xf3\xbe\x8d\x88", "\xf3\xbe\x8d\x89", "\xf3\xbe\x8d\x8a", "\xf3\xbe\x8d\x8b", "\xf3\xbe\x8d\x8c", "\xf3\xbe\x8d\x8d", "\xf3\xbe\x8d\x8e", "\xf3\xbe\x8d\x8f", "\xf3\xbe\x8d\x90", "\xf3\xbe\x8d\x91", "\xf3\xbe\x8d\x92", "\xf3\xbe\x8d\x93", "\xf3\xbe\x8d\x94", "\xf3\xbe\x8d\x95", "\xf3\xbe\x8d\x96", "\xf3\xbe\x8d\x97", "\xf3\xbe\x8d\x98", "\xf3\xbe\x8d\x99", "\xf3\xbe\x8d\x9a", "\xf3\xbe\x8d\x9b", "\xf3\xbe\x92\xb0", "\xf3\xbe\x92\xb1", "\xf3\xbe\x92\xb2", "\xf3\xbe\x92\xb3", "\xf3\xbe\x92\xb4", "\xf3\xbe\x92\xb5", "\xf3\xbe\x92\xb6", "\xf3\xbe\x92\xb7", "\xf3\xbe\x92\xb8", "\xf3\xbe\x92\xb9", "\xf3\xbe\x92\xba", "\xf3\xbe\x92\xbb", "\xf3\xbe\x92\xbc", "\xf3\xbe\x92\xbd", "\xf3\xbe\x92\xbe", "\xf3\xbe\x92\xbf", "\xf3\xbe\x93\x80", "\xf3\xbe\x93\x81", "\xf3\xbe\x93\x82", "\xf3\xbe\x93\x83", "\xf3\xbe\x93\x84", "\xf3\xbe\x93\x86", "\xf3\xbe\x93\x87", "\xf3\xbe\x93\x88", "\xf3\xbe\x93\x8c", "\xf3\xbe\x93\x8d", "\xf3\xbe\x93\x96", "\xf3\xbe\x93\x97", "\xf3\xbe\x93\x98", "\xf3\xbe\x95\x93", "\xf3\xbe\x93\x8e", "\xf3\xbe\x93\x8f", "\xf3\xbe\x93\x90", "\xf3\xbe\x93\x91", "\xf3\xbe\x93\x93", "\xf3\xbe\x93\x94", "\xf3\xbe\x93\x95", "\xf3\xbe\x93\x99", "\xf3\xbe\x93\x9a", "\xf3\xbe\x93\x9b", "\xf3\xbe\x93\x9c", "\xf3\xbe\x93\xb0", "\xf3\xbe\x93\xb1", "\xf3\xbe\x93\x9d", "\xf3\xbe\x93\x9e", "\xf3\xbe\x93\x9f", "\xf3\xbe\x93\xa0", "\xf3\xbe\x93\xa1", "\xf3\xbe\x93\xa2", "\xf3\xbe\x93\xa3", "\xf3\xbe\x93\xa4", "\xf3\xbe\x93\xad", "\xf3\xbe\x93\xa8", "\xf3\xbe\x93\xab", "\xf3\xbe\x93\xa7", "\xf3\xbe\x93\xaa", "\xf3\xbe\x93\xa9", "\xf3\xbe\x93\xa5", "\xf3\xbe\x93\xae", "\xf3\xbe\x93\xac", "\xf3\xbe\x93\xa6", "\xf3\xbe\x93\xb6", "\xf3\xbe\x93\xbb", "\xf3\xbe\x93\x89", "\xf3\xbe\x93\x8a", "\xf3\xbe\x93\x8b", "\xf3\xbe\x93\xba", "\xf3\xbe\x93\xb5", "\xf3\xbe\x93\xb7", "\xf3\xbe\x93\xb8", "\xf3\xbe\x81\x84", "\xf3\xbe\x93\x92", "\xf3\xbe\x94\x89", "\xf3\xbe\x94\x8a", "\xf3\xbe\x94\x8b", "\xf3\xbe\x94\x8c", "\xf3\xbe\x94\x8d", "\xf3\xbe\x94\x8e", "\xf3\xbe\x94\x8f", "\xf3\xbe\x94\x90", "\xf3\xbe\x94\x91", "\xf3\xbe\x94\x92", "\xf3\xbe\x94\x93", "\xf3\xbe\x94\x94", "\xf3\xbe\x94\x95", "\xf3\xbe\x94\x96", "\xf3\xbe\x94\x97", "\xf3\xbe\x94\x98", "\xf3\xbe\x94\x99", "\xf3\xbe\x94\x9a", "\xf3\xbe\x94\x9b", "\xf3\xbe\x94\x9c", "\xf3\xbe\x94\x9d", "\xf3\xbe\x94\x9e", "\xf3\xbe\x94\x9f", "\xf3\xbe\x94\xa0", "\xf3\xbe\x94\xa1", "\xf3\xbe\x80\x97", "\xf3\xbe\x94\xa2", "\xf3\xbe\x94\xa3", "\xf3\xbe\x94\xa4", "\xf3\xbe\x94\xa5", "\xf3\xbe\x94\xa6", "\xf3\xbe\x94\xa7", "\xf3\xbe\x94\xa8", "\xf3\xbe\x94\xa9", "\xf3\xbe\x94\xaa", "\xf3\xbe\x94\xab", "\xf3\xbe\x94\xac", "\xf3\xbe\x94\xad", "\xf3\xbe\x94\xae", "\xf3\xbe\xa0\xa2", "\xf3\xbe\x94\xaf", "\xf3\xbe\x94\xb0", "\xf3\xbe\x94\xb1", "\xf3\xbe\x94\xb3", "\xf3\xbe\x94\xb4", "\xf3\xbe\x94\xb5", "\xf3\xbe\xae\x92", "\xf3\xbe\xad\xbc", "\xf3\xbe\xad\xbd", "\xf3\xbe\xad\xbe", "\xf3\xbe\xad\xbf", "\xf3\xbe\xae\x80", "\xf3\xbe\x94\xb6", "\xf3\xbe\x94\xb7", "\xf3\xbe\x94\xb8", "\xf3\xbe\x94\xb9", "\xf3\xbe\x94\xba", "\xf3\xbe\x94\xbb", "\xf3\xbe\x94\xbc", "\xf3\xbe\x94\xbd", "\xf3\xbe\xa0\x9d", "\xf3\xbe\xa0\x9e", "\xf3\xbe\x94\xbe", "\xf3\xbe\x94\xbf", "\xf3\xbe\x95\x80", "\xf3\xbe\x95\x81", "\xf3\xbe\x95\x82", "\xf3\xbe\x95\x83", "\xf3\xbe\x95\x84", "\xf3\xbe\x95\x85", "\xf3\xbe\x95\x86", "\xf3\xbe\x95\x87", "\xf3\xbe\x94\x82", "\xf3\xbe\x93\xbf", "\xf3\xbe\x94\x80", "\xf3\xbe\x94\x81", "\xf3\xbe\x94\x83", "\xf3\xbe\x94\x84", "\xf3\xbe\x93\xbd", "\xf3\xbe\x95\x88", "\xf3\xbe\x95\x89", "\xf3\xbe\x95\x8a", "\xf3\xbe\x95\x8b", "\xf3\xbe\x95\x8c", "\xf3\xbe\x95\x8d", "\xf3\xbe\x95\x8e", "\xf3\xbe\x95\x8f", "\xf3\xbe\x95\x90", "\xf3\xbe\x95\x91", "\xf3\xbe\x95\x92", "\xf3\xbe\x9f\x90", "\xf3\xbe\x9f\x91", "\xf3\xbe\x9f\x92", "\xf3\xbe\x9f\x93", "\xf3\xbe\x9f\x94", "\xf3\xbe\x9f\x95", "\xf3\xbe\x9f\x96", "\xf3\xbe\x9f\x97", "\xf3\xbe\x9f\x98", "\xf3\xbe\x9f\x99", "\xf3\xbe\x9f\x9a", "\xf3\xbe\x9f\x9b", "\xf3\xbe\x9f\x9d", "\xf3\xbe\x9f\x9e", "\xf3\xbe\x9f\x9f", "\xf3\xbe\x9f\xa0", "\xf3\xbe\x9f\xa1", "\xf3\xbe\x9f\xa2", "\xf3\xbe\x9f\xa3", "\xf3\xbe\x9f\xa4", "\xf3\xbe\x9f\xa5", "\xf3\xbe\x9f\xa6", "\xf3\xbe\x9f\xa7", "\xf3\xbe\x9f\xa8", "\xf3\xbe\x9f\xa9", "\xf3\xbe\x9f\xaa", "\xf3\xbe\x9f\xac", "\xf3\xbe\x9f\xad", "\xf3\xbe\x9f\xae", "\xf3\xbe\x9f\xaf", "\xf3\xbe\x9f\xb1", "\xf3\xbe\x9f\xb2", "\xf3\xbe\x9f\xb3", "\xf3\xbe\x9f\xb4", "\xf3\xbe\x9f\xb5", "\xf3\xbe\x9f\xb6", "\xf3\xbe\x9f\xb7", "\xf3\xbe\x9f\xb8", "\xf3\xbe\x9f\xb9", "\xf3\xbe\x9f\xba", "\xf3\xbe\x9f\xbb", "\xf3\xbe\x9f\xbc", "\xf3\xbe\x9f\xbd", "\xf3\xbe\x9f\xbe", "\xf3\xbe\x9f\xbf", "\xf3\xbe\xa0\x80", "\xf3\xbe\xa0\x81", "\xf3\xbe\xa0\x82", "\xf3\xbe\xa0\x83", "\xf3\xbe\xa0\x84", "\xf3\xbe\xa0\x85", "\xf3\xbe\xa0\x86", "\xf3\xbe\xa0\x87", "\xf3\xbe\xa0\x88", "\xf3\xbe\xa0\x89", "\xf3\xbe\xa0\x8a", "\xf3\xbe\xa0\x8b", "\xf3\xbe\xa0\x8c", "\xf3\xbe\xa0\x8d", "\xf3\xbe\xa0\x8e", "\xf3\xbe\xa0\x8f", "\xf3\xbe\xa0\x90", "\xf3\xbe\xa0\x91", "\xf3\xbe\xa0\x92", "\xf3\xbe\xa0\x93", "\xf3\xbe\xa0\x94", "\xf3\xbe\xa0\x95", "\xf3\xbe\xa0\x96", "\xf3\xbe\xa0\x97", "\xf3\xbe\xa0\x98", "\xf3\xbe\xa0\x99", "\xf3\xbe\xa0\x9a", "\xf3\xbe\xa0\x9b", "\xf3\xbe\x93\xaf", "\xf3\xbe\x93\xb9", "\xf3\xbe\xa0\x9c", "\xf3\xbe\xa0\x9f", "\xf3\xbe\xa0\xa0", "\xf3\xbe\xa0\xa3", "\xf3\xbe\xa0\xa4", "\xf3\xbe\xa0\xa5", "\xf3\xbe\xa0\xa6", "\xf3\xbe\xa0\xa7", "\xf3\xbe\xa0\xa8", "\xf3\xbe\xa0\xa9", "\xf3\xbe\xa0\xaa", "\xf3\xbe\xac\xa5", "\xf3\xbe\xac\xa9", "\xf3\xbe\xac\xad", "\xf3\xbe\xac\xaa", "\xf3\xbe\xad\x87", "\xf3\xbe\xa0\xac", "\xf3\xbe\xa0\xae", "\xf3\xbe\xa0\xaf", "\xf3\xbe\xa0\xb0", "\xf3\xbe\xa0\xb1", "\xf3\xbe\xa0\xb2", "\xf3\xbe\xa0\xb3", "\xf3\xbe\xa0\xb4", "\xf3\xbe\xa0\xb5", "\xf3\xbe\xa0\xb6", "\xf3\xbe\xa0\xb7", "\xf3\xbe\xa0\xbb", "\xf3\xbe\xa0\xb8", "\xf3\xbe\xa0\xb9", "\xf3\xbe\xa0\xba", "\xf3\xbe\xa5\xa0", "\xf3\xbe\xa5\xa1", "\xf3\xbe\xa5\xa2", "\xf3\xbe\xa5\xa3", "\xf3\xbe\xa5\xa4", "\xf3\xbe\xa5\xa5", "\xf3\xbe\xa5\xa6", "\xf3\xbe\xa5\xa7", "\xf3\xbe\xa5\xa8", "\xf3\xbe\xa5\xa9", "\xf3\xbe\xa5\xaa", "\xf3\xbe\xa5\xab", "\xf3\xbe\xa5\xac", "\xf3\xbe\xa5\xad", "\xf3\xbe\xa5\xae", "\xf3\xbe\xa5\xaf", "\xf3\xbe\xa5\xb0", "\xf3\xbe\xa5\xb1", "\xf3\xbe\xa5\xb2", "\xf3\xbe\xa5\xb3", "\xf3\xbe\xa5\xb4", "\xf3\xbe\xa5\xb5", "\xf3\xbe\xa5\xb6", "\xf3\xbe\xa5\xb7", "\xf3\xbe\xa5\xb8", "\xf3\xbe\xa5\xb9", "\xf3\xbe\xa5\xba", "\xf3\xbe\xa5\xbb", "\xf3\xbe\xa5\xbc", "\xf3\xbe\xa5\xbd", "\xf3\xbe\xa5\xbe", "\xf3\xbe\xa5\xbf", "\xf3\xbe\xa6\x80", "\xf3\xbe\xa6\x81", "\xf3\xbe\xa6\x82", "\xf3\xbe\xa6\x83", "\xf3\xbe\xa6\x84", "\xf3\xbe\xa6\x85", "\xf3\xbe\xa6\x86", "\xf3\xbe\xa6\x87", "\xf3\xbe\xa6\x88", "\xf3\xbe\xab\xb0", "\xf3\xbe\xab\xb1", "\xf3\xbe\xab\xb2", "\xf3\xbe\xab\xb3", "\xf3\xbe\xab\xb4", "\xf3\xbe\xab\xb5", "\xf3\xbe\xab\xb6", "\xf3\xbe\xab\xb7", "\xf3\xbe\xab\xb8", "\xf3\xbe\xab\xb9", "\xf3\xbe\xab\xba", "\xf3\xbe\xab\xbb", "\xf3\xbe\xab\xbc", "\xf3\xbe\xab\xbd", "\xf3\xbe\xab\xbe", "\xf3\xbe\xab\xbf", "\xf3\xbe\xac\x83", "\xf3\xbe\xac\x82", "\xf3\xbe\xad\xb8", "\xf3\xbe\xad\xb9", "\xf3\xbe\xac\x81", "\xf3\xbe\xac\x80", "\xf3\xbe\xad\x84", "\xf3\xbe\xad\x85", "\xf3\xbe\xad\x86", "\xf3\xbe\xac\x84", "\xf3\xbe\xac\x85", "\xf3\xbe\xac\x86", "\xf3\xbe\xac\x89", "\xf3\xbe\xac\x8a", "\xf3\xbe\xac\x8b", "\xf3\xbe\xac\x87", "\xf3\xbe\xac\x88", "\xf3\xbe\xa0\xab", "\xf3\xbe\xac\x8c", "\xf3\xbe\xac\x8d", "\xf3\xbe\xac\x8e", "\xf3\xbe\xac\x8f", "\xf3\xbe\xac\x90", "\xf3\xbe\xac\x91", "\xf3\xbe\xac\x92", "\xf3\xbe\xac\x93", "\xf3\xbe\xac\x94", "\xf3\xbe\xac\x95", "\xf3\xbe\xac\x96", "\xf3\xbe\xac\x97", "\xf3\xbe\xac\x98", "\xf3\xbe\xac\x99", "\xf3\xbe\xac\x9a", "\xf3\xbe\xac\x9b", "\xf3\xbe\xac\x9c", "\xf3\xbe\xac\x9d", "\xf3\xbe\xac\x9e", "\xf3\xbe\xac\x9f", "\xf3\xbe\xac\xa0", "\xf3\xbe\xac\xa2", "\xf3\xbe\xac\xa3", "\xf3\xbe\xac\xa6", "\xf3\xbe\xac\xac", "\xf3\xbe\x9f\xab", "\xf3\xbe\x9f\xb0", "\xf3\xbe\xac\xb3", "\xf3\xbe\xac\xb4", "\xf3\xbe\x94\x85", "\xf3\xbe\x94\x86", "\xf3\xbe\x94\x87", "\xf3\xbe\x94\x88", "\xf3\xbe\xac\xb5", "\xf3\xbe\x93\xb3", "\xf3\xbe\xad\x88", "\xf3\xbe\xad\x89", "\xf3\xbe\xae\x84", "\xf3\xbe\xac\xb8", "\xf3\xbe\xac\xa1", "\xf3\xbe\xae\x81", "\xf3\xbe\xac\xb6", "\xf3\xbe\xac\xa8", "\xf3\xbe\xac\xa7", "\xf3\xbe\xad\x8f", "\xf3\xbe\xac\xb7", "\xf3\xbe\xac\xb2", "\xf3\xbe\xac\xa4", "\xf3\xbe\xac\xbf", "\xf3\xbe\xac\xae", "\xf3\xbe\xac\xaf", "\xf3\xbe\xac\xb0", "\xf3\xbe\xac\xb1", "\xf3\xbe\xac\xb9", "\xf3\xbe\xac\xba", "\xf3\xbe\xac\xbb", "\xf3\xbe\xac\xbc", "\xf3\xbe\xac\xbe", "\xf3\xbe\xad\x80", "\xf3\xbe\xad\x81", "\xf3\xbe\xac\xab", "\xf3\xbe\xad\x83", "\xf3\xbe\xac\xbd", "\xf3\xbe\xad\x90", "\xf3\xbe\xad\x91", "\xf3\xbe\xad\x92", "\xf3\xbe\xad\x93", "\xf3\xbe\xad\x94", "\xf3\xbe\xad\x95", "\xf3\xbe\xad\x96", "\xf3\xbe\xad\x97", "\xf3\xbe\xad\x98", "\xf3\xbe\xad\x99", "\xf3\xbe\xad\x9a", "\xf3\xbe\xad\x9b", "\xf3\xbe\xad\x9c", "\xf3\xbe\xad\x9d", "\xf3\xbe\x93\xb4", "\xf3\xbe\xad\x9e", "\xf3\xbe\xad\x9f", "\xf3\xbe\x94\xb2", "\xf3\xbe\xad\xa0", "\xf3\xbe\xad\xa1", "\xf3\xbe\xad\xa2", "\xf3\xbe\xad\xa5", "\xf3\xbe\xad\xa6", "\xf3\xbe\xad\xa3", "\xf3\xbe\xad\xa4", "\xf3\xbe\xad\xa7", "\xf3\xbe\xad\xa8", "\xf3\xbe\xad\xab", "\xf3\xbe\xad\xac", "\xf3\xbe\xad\xad", "\xf3\xbe\xad\xae", "\xf3\xbe\xad\xaf", "\xf3\xbe\xad\xb0", "\xf3\xbe\xad\xb1", "\xf3\xbe\xad\xb2", "\xf3\xbe\xad\xb3", "\xf3\xbe\xad\xb4", "\xf3\xbe\xad\xb5", "\xf3\xbe\xad\xb6", "\xf3\xbe\xad\xb7", "\xf3\xbe\xad\xba", "\xf3\xbe\xad\xbb", "\xf3\xbe\xae\x83", "\xf3\xbe\xae\x88", "\xf3\xbe\xae\x91", "\xf3\xbe\xa0\xa1", "\xf3\xbe\x93\xbc", "\xf3\xbe\x93\xbe", "\xf3\xbe\xae\x85", "\xf3\xbe\xae\x8d", "\xf3\xbe\xae\x86", "\xf3\xbe\xae\x87", "\xf3\xbe\xae\x90", "\xf3\xbe\xae\x8a", "\xf3\xbe\xae\x82", "\xf3\xbe\x93\xb2", "\xf3\xbe\xae\x8b", "\xf3\xbe\xae\x8c", "\xf3\xbe\xae\x8f", "\xf3\xbe\xad\x8b", "\xf3\xbe\xae\x8e", "\xf3\xbe\x80\x9a", "\xf3\xbe\x80\x99", "\xf3\xbe\x80\x98", "\xf3\xbe\xad\x82", "\xf3\xbe\xad\x8a", "\xf3\xbe\xae\x93", "\xf3\xbe\xae\x95", "\xf3\xbe\xae\x94", "\xf3\xbe\xae\x96", "\xf3\xbe\xae\x97", "\xf3\xbe\xae\x98", "\xf3\xbe\xae\x99", "\xf3\xbe\xae\x9a", "\xf3\xbe\xae\x9b", "\xf3\xbe\xae\x9c", "\xf3\xbe\xae\x9d", "\xf3\xbe\xae\x9e", "\xf3\xbe\xae\x9f", "\xf3\xbe\xae\xa0", "\xf3\xbe\xae\xa1"
		);
	}

}


