<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    cy 2021-05-21
 * @desc    万能表单管理
 *
 */
namespace Seller\Controller;

class AllformController extends CommonController{

	protected $menu;
	protected function _initialize(){
		parent::_initialize();

		$menu = array(
            'title'    => '万能表单',
            'subtitle' => '万能表单',
            'route' => 'allform/index',
            'items'    => array(
                array('title' => '表单列表', 'route' => 'allform/index'),
                array('title' => '表单设置', 'route' => 'allform/config'),
            )
        );

        $perm_url = strtolower(CONTROLLER_NAME) .'/'. strtolower(ACTION_NAME);
        $this->assign('perm_url', $perm_url );

		//组件权限方法===begin
        if(SELLERUID != 1)
        {
            $seller_info = M('seller')->field('s_role_id')->where( array('s_id' => SELLERUID ) )->find();

            $perm_role = M('lionfish_comshop_perm_role')->where( array('id' => $seller_info['s_role_id']) )->find();

            $perms_str = $perm_role['perms2'];

            $items = [];
            $can_use_routearr = [];

            foreach( $menu['items'] as $val )
            {
                $val_route =  str_replace('/','.', $val['route']);

                if( strpos($perms_str, '.'.$val_route) !== false )
                {
                    $items[] = $val;
                    $can_use_routearr[] = strtolower($val['route']);
                }
            }
            $menu['items'] = $items;
            if( empty($can_use_routearr) )
            {
                $this->redirect( 'application/index', [], 1,'您没有当前应用权限' );
            }else if( !in_array($perm_url , $can_use_routearr ) )
            {
                $this->redirect( $can_use_routearr[0]  );
            }
        }
        //组件方法end
		$this->menu = $menu;
		$this->assign('menu', $menu );
	}

    /**
     * @author cy 2021-05-21
     * @desc  万能表单列表
     */
    public function index(){
        $_GPC = I('request.');

        $pindex    = max(1, intval($_GPC['page']));
        $psize     = 20;

        $condition = " 1 ";

        if (!empty($_GPC['keyword'])) {
            $_GPC['keyword'] = trim($_GPC['keyword']);
            $condition .= ' and form_name like "%'.$_GPC['keyword'].'%"';
        }

        $list = M('lionfish_comshop_forms')->where($condition)->order('id desc')->limit( (($pindex - 1) * $psize) , $psize )->select();

        foreach($list as $k=>$v){
            $list[$k]['form_type_text'] = D('Seller/allform')->getFormTypeName($v['form_type']);
            $list[$k]['collection_count'] = D('Seller/allform')->getFormInfoCountByFormId($v['id']);
            $list[$k]['addtime'] = date('Y-m-d H:i:s', $v['addtime']);
        }

        $total = M('lionfish_comshop_forms')->where( $condition )->count();

        $pager = pagination2($total, $pindex, $psize);

        $this->list = $list;
        $this->pager = $pager;

        $this->_GPC = $_GPC;

        $this->display();
    }

    /**
     * @desc 添加万能表单
     * @author cy
     */
    public function add( )
    {
        $_GPC = I('request.');
        $id = $_GPC['id'];

        if( $id > 0 )
        {
            $item = D('Seller/allform')->getFormsById( $id );

            $item_content = D('Seller/allform')->setFormsContent($item);
            $item['item_li'] = $item_content['item_li'];
            $item['phone_item'] = $item_content['phone_item'];
            $this->item = $item;
        }

        if( IS_POST )
        {
            $res =  D('Seller/allform')->addOrUpdateForm();
            if( $res['code'] == 0 )
            {
                show_json(0,  array('message' => $res['message'] ,'url' => $_SERVER['HTTP_REFERER']) );
                die();
            }else if( $res['code'] == 1 ){
                show_json(1, array('url' => U('allform/index')));
                die();
            }
        }
        $this->display('Allform/addform');
    }

    /**
     * @author cy 2021-05-24
     * @desc 万能表单添加项目
     */
    public function add_item(){
        $type = I('request.type');
        $need_data = D('Seller/allform')->getFormItem($type);
        show_json(1, array('data' => $need_data));
    }

    /**
     * @author cy 2021-05-25
     * @desc 删除万能表单
     * @return mixed
     */
    public function delete(){
        $id = I('request.id');
        $res = D('Seller/allform')->deleteForm($id);
        if($res['code'] == 0){
            show_json(0,  array('message' => $res['message'] ,'url' => $_SERVER['HTTP_REFERER']) );
            die();
        }else{
            show_json(1, array('url' => U('allform/index')));
            die();
        }
    }

    /**
     * @author cy 2021-05-25
     * @desc 表单设置
     */
    public function config()
    {
        $_GPC = I('request.');

        if (IS_POST) {
            $data = ((is_array($_GPC['parameter']) ? $_GPC['parameter'] : array()));

            $data['is_open_allform'] = isset($data['is_open_allform']) ? $data['is_open_allform'] : 0;
            $data['is_open_orderform'] = isset($data['is_open_orderform']) ? $data['is_open_orderform'] : 0;
            $data['order_allform_id'] = isset($data['order_allform_id']) ? $data['order_allform_id'] : 0;

            D('Seller/Config')->update($data);

            show_json(1,  array('url' => $_SERVER['HTTP_REFERER']) );
            die();
        }

        $data = D('Seller/Config')->get_all_config();
        if(!empty($data['order_allform_id'])){
            $form_data = D('Seller/allform')->getFormsById( $data['order_allform_id'] );
            if(!empty($form_data)){
                $data['order_allform_name'] = $form_data['form_name'];
            }
        }else{
            $data['order_allform_name'] = "";
        }
        $this->data = $data;

        $this->display();
    }

    /**
     * @author cy 2021-05-25
     * @desc 公共查询表单数据列表
     */
    public function query_form(){
        $_GPC = I('request.');

        $is_ajax = isset($_GPC['is_ajax']) ? intval($_GPC['is_ajax']) : 0;

        $need_data = D('Seller/allform')->queryList($_GPC);

        if( $is_ajax == 1 ) {
            echo json_encode( array('code' => 0, 'html' => $need_data['html'],'pager' => $need_data['pager']) );
            die();
        }else{
            $data = [];
            $data['gpc'] = ['keyword' => $_GPC['keyword'],'type' => $_GPC['type'],'template' => $_GPC['template']];
            $data['list'] = $need_data['list'];
            $data['pager'] = $need_data['pager'];
            $this->data = $data;
            $this->display('Allform/query_form');
        }
    }

    /**
     * @author cy 2021-05-26
     * @desc 表单数据列表
     */
    public function datalist(){
        $_GPC = I('request.');

        $need_data = D('Seller/allform')->getDataList($_GPC);

        $data = [];
        $data['gpc'] = ['keyword' => $_GPC['keyword'],'id' => $_GPC['id']];
        $data['list'] = $need_data['list'];
        $data['pager'] = $need_data['pager'];
        $data['form_info'] = $need_data['form_info'];
        $this->data = $data;
        $this->display('Allform/datalist');
    }

    /**
     * @author cy 2021-05-26
     * @desc 导出表单数据列表信息
     */
    public function exportdata(){
        $_GPC = I('request.');
        $form_id = $_GPC['id'];
        //获取表单信息
        $form_data = D('Seller/allform')->getExportFormDataList($form_id);

        $title_list = $form_data['title_list'];
        $form_list = $form_data['form_list'];
        $form_data = $form_data['form_data'];

        $columns = array(
            array('title' => '表单数据ID', 'field' => 'id', 'width' => 12),
            array('title' => '表单名称', 'field' => 'form_name', 'width' => 12),
            array('title' => '表单类型', 'field' => 'form_type_name', 'width' => 12),
            array('title' => '关联订单', 'field' => 'order_number', 'width' => 24),
            array('title' => '提交会员', 'field' => 'username', 'width' => 24),
            array('title' => '提交时间', 'field' => 'addtime', 'width' => 24)
        );
        if(!empty($title_list)){
            foreach($title_list as $k=>$v){
                $columns[] = array('title' => $v, 'field' => $v, 'width' => 24 );
            }
        }
        $need_list = [];
        if( !empty($form_list) )
        {
            foreach($form_list as $val )
            {
                $tmp_arr = [];
                if($form_data['form_type'] == 'order'){
                    $tmp_arr['id'] = $val['id'];
                    $tmp_arr['form_name'] = $val['form_name'];
                    $tmp_arr['form_type_name'] = D('Seller/allform')->getFormTypeName($val['form_type']);
                    $tmp_arr['order_number'] = $val['order_number'];
                    $tmp_arr['username'] = $val['username'];
                    $tmp_arr['addtime'] = $val['addtime'];
                }
                if(!empty($title_list)){
                    foreach($title_list as $k=>$v){
                        if(!empty($val[$v])){
                            $tmp_arr[$v] = $val[$v];
                        }else{
                            $tmp_arr[$v] = "";
                        }
                    }
                }
                $need_list[] = $tmp_arr;
            }
        }
        D('Seller/Excel')->export($need_list, array('title' => $form_data['form_name'].'表单数据列表-' . date('Y-m-d-H-i', time()), 'columns' => $columns));
    }
}
?>