<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    cy 2021-04-26
 * @desc    货到付款设置
 *
 */
namespace Seller\Controller;

class CashondeliveryController extends CommonController{
	protected $menu;
	protected function _initialize(){
		parent::_initialize();

		$menu = array(
            'title'    => '货到付款',
            'subtitle' => '货到付款',
            'route' => 'cashondelivery/config',
            'items'    => array(
                array('title' => '设置', 'route' => 'cashondelivery/config'),            )
        );

        $perm_url = strtolower(CONTROLLER_NAME) .'/'. strtolower(ACTION_NAME);
        $this->assign('perm_url', $perm_url );

		//组件权限方法===begin
        if(SELLERUID != 1)
        {
            $seller_info = M('seller')->field('s_role_id')->where( array('s_id' => SELLERUID ) )->find();

            $perm_role = M('lionfish_comshop_perm_role')->where( array('id' => $seller_info['s_role_id']) )->find();

            $perms_str = $perm_role['perms2'];

            $items = [];
            $can_use_routearr = [];

            foreach( $menu['items'] as $val )
            {
                $val_route =  str_replace('/','.', $val['route']);

                if( strpos($perms_str, '.'.$val_route) !== false )
                {
                    $items[] = $val;
                    $can_use_routearr[] = strtolower($val['route']);
                }
            }
            $menu['items'] = $items;
            if( empty($can_use_routearr) )
            {
                $this->redirect( 'application/index', [], 1,'您没有当前应用权限' );
            }else if( !in_array($perm_url , $can_use_routearr ) )
            {
                $this->redirect( $can_use_routearr[0]  );
            }
        }
        //组件方法end
		$this->menu = $menu;
		$this->assign('menu', $menu );
	}

	public function config()
    {
        $_GPC = I('request.');

        if (IS_POST) {


            $data = ((is_array($_GPC['parameter']) ? $_GPC['parameter'] : array()));

            $data['isopen_cashondelivery'] = isset($data['isopen_cashondelivery']) ? $data['isopen_cashondelivery'] : 0;
            $data['isopen_cashondelivery_communityhead'] = isset($data['isopen_cashondelivery_communityhead']) ? $data['isopen_cashondelivery_communityhead'] : 0;
            $data['isopen_cashondelivery_express'] = isset($data['isopen_cashondelivery_express']) ? $data['isopen_cashondelivery_express'] : 0;
            $data['isopen_cashondelivery_localtown'] = isset($data['isopen_cashondelivery_localtown']) ? $data['isopen_cashondelivery_localtown'] : 0;
            $data['isopen_cashondelivery_hexiao'] = isset($data['isopen_cashondelivery_hexiao']) ? $data['isopen_cashondelivery_hexiao'] : 0;

            $data['isopen_cashondelivery_code'] = isset($data['isopen_cashondelivery_code']) ? $data['isopen_cashondelivery_code'] : 0;
            $data['cashondelivery_code_img'] = isset($data['cashondelivery_code_img']) ? $data['cashondelivery_code_img'] : '';

            D('Seller/Config')->update($data);

            show_json(1,  array('url' => $_SERVER['HTTP_REFERER']) );
            die();
        }

        $data = D('Seller/Config')->get_all_config();
        $this->data = $data;

        $this->display();
    }

}
?>