<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    fish
 *
 */
namespace Seller\Controller;

class ShopdiyController extends CommonController{
	
	protected function _initialize(){
		parent::_initialize();
		
	}
	
	public function index()
    {
		// 组件数据
		$diyviewData = file_get_contents(__ROOT__ . './static/js/diy/diyview.json');
		$diyview = json_decode($diyviewData, true);
		$goods_category_list = D('Seller/GoodsCategory')->getFullCategory();

		$data = D('Seller/Config')->get_all_config();
		$global = 0;
		$diyJson = 0;

		$newdata = D('Seller/Diydata')->get_all_config();
		if(!empty($newdata)) {
			$diyJson = json_encode($newdata);
			if($data['index_diy_json']) {
				$diyDataRes = unserialize($data['index_diy_json']);
				$global = htmlspecialchars_decode($diyDataRes["global"]);
			}
		} else if($data['index_diy_json']) {
			// 旧数据兼容处理
			$diyDataRes = unserialize($data['index_diy_json']);
			$diyData = htmlspecialchars_decode($diyDataRes['value']);
			$diyDataJson = json_decode($diyData);
			$global = json_encode($diyDataJson->global);
			$diyJson = json_encode($diyDataJson->value);

			if($global=="null") {
				$global = htmlspecialchars_decode($diyDataRes["global"]);
			}
		}

		$openDiyPage = D('Home/Front')->get_config_by_name('open_diy_index_page');

		$this->global = $global;
		$this->openDiyPage = $openDiyPage;
		$this->diyJson = $diyJson;

		$this->resourceurl = '/static/diycomponent';
		$this->diyview = $diyview;
		$this->goods_category_list = $goods_category_list;
        $this->display();
    }

	public function link()
    {
		// 组件数据
		$linkData = file_get_contents(__ROOT__ . './static/js/diy/linklist.json');
		$list = json_decode($linkData, true);
		$link = I('request.link', '');

		$category_list = D('Seller/GoodsCategory')->getThreeCategory();

		$this->category_list = $category_list;
		$this->link = $link;
		$link = stripslashes(html_entity_decode($link));
		$this->link_array = \json_decode($link, true);
		$this->list = $list;
        $this->display();
    }

	public function childLink()
	{
		$link = I('request.link', array());
        $name = I('request.name', array());
        $is_array = true;
        if (!empty($link)) {
            $link = htmlspecialchars_decode($link);
            $link = json_decode($link, true);
            $is_array = is_array($link);
        }

		$res = array( "link" => $link, "list" => array() );
        echo json_encode($res);
        die();
	}

	public function save()
	{
		$params = I('request.');


		$valueJson = $params["value"];
		$valueJson = htmlspecialchars_decode($valueJson);
		$value = json_decode($valueJson);
		D('Seller/Diydata')->update($value);
        
		$data = array();
		$data['open_diy_index_page'] = intval($params['openDiyPage']);
		unset($params["value"]);
		unset($params["openDiyPage"]);
		$data['index_diy_json'] = serialize($params);
		D('Seller/Config')->update($data);

		show_json(1, array('url' => U('Shopdiy/index')));
        die();
	}
	
	public function goodsSelect()
	{
		if (IS_GET) {
			$page = I('request.page', 1);
        	$page_size = I('request.page_size', 10);
			$promotion = I('request.promotion', '');

			$condition = " type='".$promotion."' and grounding=1 and total > 0 ";

			$sql = 'SELECT id FROM ' .C('DB_PREFIX'). 'lionfish_comshop_goods WHERE' .$condition;
			$count=count(M()->query($sql));

			$Page = new \Think\Page($count, $page_size);
			$list = M()->query('SELECT id,goodsname as title,productprice,price as marketprice,total FROM '.C('DB_PREFIX').'lionfish_comshop_goods WHERE '.$condition.' LIMIT '.($page-1)*$page_size.','.$Page->listRows);

			if(count($list)) {
				foreach($list as $kk => $vv)
				{
					$thumb =  M('lionfish_comshop_goods_images')->where( array('goods_id' => $vv['id'] ) )->order('id asc')->find();		
					// $vv['image'] =  tomedia($thumb['image']);
					$vv['image'] =  $thumb['thumb'];
					$list[$kk] = $vv;
				}
			}

			$page_count = ceil($count/$page_size);

			$res = array( "code" => 0, "data" => array('list'=>$list, 'count'=>$count, 'page_count'=>$page_count) );
			echo json_encode($res);
			die();
		}
	}
}
?>