/// <reference types="node" />
import { MenuItemOptions } from './menu';
import { Subject, Observable } from 'rxjs';
export interface ClipboardContent {
    text: string;
    html?: string;
}
export interface MessageBoxOptions {
    type: 'warning' | 'error';
    message: string;
    detail?: string;
    buttons: string[];
    defaultId?: number;
    cancelId?: number;
}
export interface MessageBoxResult {
    response: number;
}
export declare abstract class FileTransfer {
    abstract getName(): string;
    abstract getMode(): number;
    abstract getSize(): number;
    abstract close(): void;
    getSpeed(): number;
    getCompletedBytes(): number;
    isComplete(): boolean;
    isCancelled(): boolean;
    cancel(): void;
    protected increaseProgress(bytes: number): void;
    private completedBytes;
    private lastChunkStartTime;
    private lastChunkSpeed;
    private cancelled;
}
export declare abstract class FileDownload extends FileTransfer {
    abstract write(buffer: Buffer): Promise<void>;
}
export declare abstract class FileUpload extends FileTransfer {
    abstract read(): Promise<Buffer>;
    readAll(): Promise<Buffer>;
}
export interface FileUploadOptions {
    multiple: boolean;
}
export declare abstract class PlatformService {
    supportsWindowControls: boolean;
    get fileTransferStarted$(): Observable<FileTransfer>;
    get displayMetricsChanged$(): Observable<void>;
    protected fileTransferStarted: Subject<FileTransfer>;
    protected displayMetricsChanged: Subject<void>;
    abstract readClipboard(): string;
    abstract setClipboard(content: ClipboardContent): void;
    abstract loadConfig(): Promise<string>;
    abstract saveConfig(content: string): Promise<void>;
    abstract startDownload(name: string, mode: number, size: number): Promise<FileDownload | null>;
    abstract startUpload(options?: FileUploadOptions): Promise<FileUpload[]>;
    startUploadFromDragEvent(event: DragEvent, multiple?: boolean): FileUpload[];
    getConfigPath(): string | null;
    showItemInFolder(path: string): void;
    isProcessRunning(name: string): Promise<boolean>;
    installPlugin(name: string, version: string): Promise<void>;
    uninstallPlugin(name: string): Promise<void>;
    getWinSCPPath(): string | null;
    exec(app: string, argv: string[]): void;
    isShellIntegrationSupported(): boolean;
    isShellIntegrationInstalled(): Promise<boolean>;
    installShellIntegration(): Promise<void>;
    uninstallShellIntegration(): Promise<void>;
    openPath(path: string): void;
    abstract getOSRelease(): string;
    abstract getAppVersion(): string;
    abstract openExternal(url: string): void;
    abstract listFonts(): Promise<string[]>;
    abstract setErrorHandler(handler: (_: any) => void): void;
    abstract popupContextMenu(menu: MenuItemOptions[], event?: MouseEvent): void;
    abstract showMessageBox(options: MessageBoxOptions): Promise<MessageBoxResult>;
    abstract quit(): void;
}
export declare class HTMLFileUpload extends FileUpload {
    private file;
    private stream;
    private reader;
    constructor(file: File);
    getName(): string;
    getMode(): number;
    getSize(): number;
    read(): Promise<Buffer>;
    bringToFront(): void;
    close(): void;
}
