import { NgbDropdown, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { CdkDragDrop } from '@angular/cdk/drag-drop';
import { HostAppService, Platform } from '../api/hostApp';
import { HotkeysService } from '../services/hotkeys.service';
import { LogService } from '../services/log.service';
import { ConfigService } from '../services/config.service';
import { ThemesService } from '../services/themes.service';
import { UpdaterService } from '../services/updater.service';
import { BaseTabComponent } from './baseTab.component';
import { TabBodyComponent } from './tabBody.component';
import { AppService, FileTransfer, HostWindowService, PlatformService, ToolbarButton, ToolbarButtonProvider } from '../api';
/** @hidden */
export declare class AppRootComponent {
    private hotkeys;
    private updater;
    hostWindow: HostWindowService;
    hostApp: HostAppService;
    config: ConfigService;
    app: AppService;
    private toolbarButtonProviders;
    Platform: typeof Platform;
    ready: boolean;
    leftToolbarButtons: ToolbarButton[];
    rightToolbarButtons: ToolbarButton[];
    platformClassWindows: boolean;
    platformClassMacOS: boolean;
    platformClassLinux: boolean;
    noTabs: boolean;
    tabBodies: TabBodyComponent[];
    activeTransfersDropdown: NgbDropdown;
    unsortedTabs: BaseTabComponent[];
    updatesAvailable: boolean;
    activeTransfers: FileTransfer[];
    private logger;
    constructor(hotkeys: HotkeysService, updater: UpdaterService, hostWindow: HostWindowService, hostApp: HostAppService, config: ConfigService, app: AppService, toolbarButtonProviders: ToolbarButtonProvider[], platform: PlatformService, log: LogService, ngbModal: NgbModal, _themes: ThemesService);
    ngOnInit(): Promise<void>;
    onDragOver(): boolean;
    onDrop(): boolean;
    hasVerticalTabs(): boolean;
    generateButtonSubmenu(button: ToolbarButton): Promise<void>;
    hasIcons(submenuItems: ToolbarButton[]): boolean;
    onTabsReordered(event: CdkDragDrop<BaseTabComponent[]>): void;
    onTransfersChange(): void;
    get isVibrant(): any;
    private getToolbarButtons;
}
