import { Observable, OperatorFunction } from 'rxjs';
import { ViewContainerRef, ComponentFactoryResolver, Injector } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { ConfigProxy, ConfigService, Profile, ProfileProvider, ProfileSettingsComponent, ProfilesService } from 'tabby-core';
/** @hidden */
export declare class EditProfileModalComponent<P extends Profile> {
    private injector;
    private componentFactoryResolver;
    private profilesService;
    private modalInstance;
    profile: P & ConfigProxy;
    profileProvider: ProfileProvider<P>;
    settingsComponent: new () => ProfileSettingsComponent<P>;
    defaultsMode: boolean;
    groupNames: string[];
    placeholder: ViewContainerRef;
    private _profile;
    private settingsComponentInstance?;
    constructor(injector: Injector, componentFactoryResolver: ComponentFactoryResolver, profilesService: ProfilesService, config: ConfigService, modalInstance: NgbActiveModal);
    colorsAutocomplete: (text$: any) => any;
    colorsFormatter: (value: any) => any;
    ngOnInit(): void;
    ngAfterViewInit(): void;
    groupTypeahead: (text$: Observable<string>) => Observable<string[]>;
    iconSearch: OperatorFunction<string, string[]>;
    save(): void;
    cancel(): void;
}
