import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { ConfigService, HostAppService, Profile, SelectorService, ProfilesService, PlatformService, BaseComponent, PartialProfile, ProfileProvider, TranslateService } from 'tabby-core';
interface ProfileGroup {
    name?: string;
    profiles: PartialProfile<Profile>[];
    editable: boolean;
    collapsed: boolean;
}
/** @hidden */
export declare class ProfilesSettingsTabComponent extends BaseComponent {
    config: ConfigService;
    hostApp: HostAppService;
    profileProviders: ProfileProvider<Profile>[];
    private profilesService;
    private selector;
    private ngbModal;
    private platform;
    private translate;
    profiles: PartialProfile<Profile>[];
    builtinProfiles: PartialProfile<Profile>[];
    templateProfiles: PartialProfile<Profile>[];
    profileGroups: ProfileGroup[];
    filter: string;
    constructor(config: ConfigService, hostApp: HostAppService, profileProviders: ProfileProvider<Profile>[], profilesService: ProfilesService, selector: SelectorService, ngbModal: NgbModal, platform: PlatformService, translate: TranslateService);
    ngOnInit(): Promise<void>;
    launchProfile(profile: PartialProfile<Profile>): void;
    newProfile(base?: PartialProfile<Profile>): Promise<void>;
    editProfile(profile: PartialProfile<Profile>): Promise<void>;
    showProfileEditModal(profile: PartialProfile<Profile>): Promise<PartialProfile<Profile> | null>;
    deleteProfile(profile: PartialProfile<Profile>): Promise<void>;
    refresh(): void;
    editGroup(group: ProfileGroup): Promise<void>;
    deleteGroup(group: ProfileGroup): Promise<void>;
    isGroupVisible(group: ProfileGroup): boolean;
    isProfileVisible(profile: PartialProfile<Profile>): boolean;
    getDescription(profile: PartialProfile<Profile>): string | null;
    getTypeLabel(profile: PartialProfile<Profile>): string;
    getTypeColorClass(profile: PartialProfile<Profile>): string;
    toggleGroupCollapse(group: ProfileGroup): void;
    editDefaults(provider: ProfileProvider<Profile>): Promise<void>;
}
export {};
