/// <reference types="node" />
import { Observable } from 'rxjs';
import { Duplex } from 'stream';
export declare class SSHProxyStreamSocket extends Duplex {
    private parent;
    constructor(parent: SSHProxyStream);
    _read(size: number): void;
    _write(chunk: Buffer, _encoding: string, callback: (error?: Error | null) => void): void;
    _destroy(error: Error | null, callback: (error: Error | null) => void): void;
}
export declare abstract class SSHProxyStream {
    get message$(): Observable<string>;
    get destroyed$(): Observable<Error | null>;
    get socket(): SSHProxyStreamSocket | null;
    private message;
    private destroyed;
    private _socket;
    start(): Promise<SSHProxyStreamSocket>;
    abstract requestData(size: number): void;
    abstract consumeInput(data: Buffer): Promise<void>;
    protected emitMessage(message: string): void;
    protected emitOutput(data: Buffer): void;
    handleStopRequest(error: Error | null): Promise<void>;
    stop(error?: Error): void;
}
