import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { ConfigService, FileProvidersService, Platform, HostAppService, PartialProfile } from 'tabby-core';
import { LoginScriptsSettingsComponent } from 'tabby-terminal';
import { PasswordStorageService } from '../services/passwordStorage.service';
import { ForwardedPortConfig, SSHProfile } from '../api';
/** @hidden */
export declare class SSHProfileSettingsComponent {
    hostApp: HostAppService;
    private config;
    private passwordStorage;
    private ngbModal;
    private fileProviders;
    Platform: typeof Platform;
    profile: SSHProfile;
    hasSavedPassword: boolean;
    connectionMode: 'direct' | 'proxyCommand' | 'jumpHost' | 'socksProxy' | 'httpProxy';
    supportedAlgorithms: Record<string, string>;
    algorithms: Record<string, Record<string, boolean>>;
    jumpHosts: PartialProfile<SSHProfile>[];
    loginScriptsSettings: LoginScriptsSettingsComponent | null;
    constructor(hostApp: HostAppService, config: ConfigService, passwordStorage: PasswordStorageService, ngbModal: NgbModal, fileProviders: FileProvidersService);
    ngOnInit(): Promise<void>;
    getJumpHostLabel(p: PartialProfile<SSHProfile>): string;
    setPassword(): Promise<void>;
    clearSavedPassword(): void;
    addPrivateKey(): Promise<void>;
    removePrivateKey(path: string): void;
    save(): void;
    onForwardAdded(fw: ForwardedPortConfig): void;
    onForwardRemoved(fw: ForwardedPortConfig): void;
    getConnectionDropdownTitle(): string;
}
