import { Injector } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { GetRecoveryTokenOptions, Platform, ProfilesService, RecoveryToken } from 'tabby-core';
import { BaseTerminalTabComponent } from 'tabby-terminal';
import { SSHService } from '../services/ssh.service';
import { KeyboardInteractivePrompt, SSHSession } from '../session/ssh';
import { SSHProfile } from '../api';
import { SSHShellSession } from '../session/shell';
import { SSHMultiplexerService } from '../services/sshMultiplexer.service';
/** @hidden */
export declare class SSHTabComponent extends BaseTerminalTabComponent {
    ssh: SSHService;
    private ngbModal;
    private profilesService;
    private sshMultiplexer;
    Platform: typeof Platform;
    profile?: SSHProfile;
    sshSession: SSHSession | null;
    session: SSHShellSession | null;
    sftpPanelVisible: boolean;
    sftpPath: string;
    enableToolbar: boolean;
    activeKIPrompt: KeyboardInteractivePrompt | null;
    private recentInputs;
    private reconnectOffered;
    constructor(injector: Injector, ssh: SSHService, ngbModal: NgbModal, profilesService: ProfilesService, sshMultiplexer: SSHMultiplexerService);
    ngOnInit(): void;
    setupOneSession(injector: Injector, profile: SSHProfile): Promise<SSHSession>;
    protected attachSessionHandlers(): void;
    initializeSession(): Promise<void>;
    getRecoveryToken(options?: GetRecoveryTokenOptions): Promise<RecoveryToken>;
    showPortForwarding(): void;
    reconnect(): Promise<void>;
    canClose(): Promise<boolean>;
    openSFTP(): Promise<void>;
    onClick(): void;
}
