import { ProfileProvider, NewTabParameters, PartialProfile, TranslateService } from 'tabby-core';
import { SSHProfileSettingsComponent } from './components/sshProfileSettings.component';
import { SSHTabComponent } from './components/sshTab.component';
import { PasswordStorageService } from './services/passwordStorage.service';
import { SSHProfile } from './api';
import { SSHProfileImporter } from './api/importer';
export declare class SSHProfilesService extends ProfileProvider<SSHProfile> {
    private passwordStorage;
    private translate;
    private importers;
    id: string;
    name: string;
    supportsQuickConnect: boolean;
    settingsComponent: typeof SSHProfileSettingsComponent;
    configDefaults: {
        options: {
            host: null;
            port: number;
            user: string;
            auth: null;
            password: null;
            privateKeys: never[];
            keepaliveInterval: number;
            keepaliveCountMax: number;
            readyTimeout: null;
            x11: boolean;
            skipBanner: boolean;
            jumpHost: null;
            agentForward: boolean;
            warnOnClose: null;
            algorithms: {
                hmac: never[];
                kex: never[];
                cipher: never[];
                serverHostKey: never[];
            };
            proxyCommand: null;
            forwardedPorts: never[];
            scripts: never[];
            socksProxyHost: null;
            socksProxyPort: null;
            httpProxyHost: null;
            httpProxyPort: null;
            reuseSession: boolean;
        };
    };
    constructor(passwordStorage: PasswordStorageService, translate: TranslateService, importers: SSHProfileImporter[] | null);
    getBuiltinProfiles(): Promise<PartialProfile<SSHProfile>[]>;
    getNewTabParameters(profile: SSHProfile): Promise<NewTabParameters<SSHTabComponent>>;
    getSuggestedName(profile: SSHProfile): string;
    getDescription(profile: PartialProfile<SSHProfile>): string;
    deleteProfile(profile: SSHProfile): void;
    quickConnect(query: string): PartialProfile<SSHProfile>;
    intoQuickConnectString(profile: SSHProfile): string | null;
}
