import { VaultService } from 'tabby-core';
import { SSHProfile } from '../api';
export declare const VAULT_SECRET_TYPE_PASSWORD = "ssh:password";
export declare const VAULT_SECRET_TYPE_PASSPHRASE = "ssh:key-passphrase";
export declare class PasswordStorageService {
    private vault;
    constructor(vault: VaultService);
    savePassword(profile: SSHProfile, password: string): Promise<void>;
    deletePassword(profile: SSHProfile): Promise<void>;
    loadPassword(profile: SSHProfile): Promise<string | null>;
    savePrivateKeyPassword(id: string, password: string): Promise<void>;
    deletePrivateKeyPassword(id: string): Promise<void>;
    loadPrivateKeyPassword(id: string): Promise<string | null>;
    private getKeytarKeyForConnection;
    private getKeytarKeyForPrivateKey;
    private getVaultKeyForConnection;
    private getVaultKeyForPrivateKey;
}
