import { BaseTabComponent, TabContextMenuItemProvider, TabHeaderComponent, NotificationsService, MenuItemOptions, TranslateService } from 'tabby-core';
import { TerminalContextMenuItemProvider } from './api/contextMenuProvider';
/** @hidden */
export declare class CopyPasteContextMenu extends TabContextMenuItemProvider {
    private notifications;
    private translate;
    weight: number;
    constructor(notifications: NotificationsService, translate: TranslateService);
    getItems(tab: BaseTabComponent, tabHeader?: TabHeaderComponent): Promise<MenuItemOptions[]>;
}
/** @hidden */
export declare class MiscContextMenu extends TabContextMenuItemProvider {
    private translate;
    weight: number;
    constructor(translate: TranslateService);
    getItems(tab: BaseTabComponent): Promise<MenuItemOptions[]>;
}
/** @hidden */
export declare class LegacyContextMenu extends TabContextMenuItemProvider {
    protected contextMenuProviders: TerminalContextMenuItemProvider[] | null;
    weight: number;
    constructor(contextMenuProviders: TerminalContextMenuItemProvider[] | null);
    getItems(tab: BaseTabComponent, _tabHeader?: TabHeaderComponent): Promise<MenuItemOptions[]>;
}
