import { ModuleWithProviders } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { TranslateMessageFormatCompiler } from 'ngx-translate-messageformat-compiler';
import { AppRootComponent } from './components/appRoot.component';
import { PlatformService, ProfilesService, ProfileProvider, Profile, SelectorService } from './api';
import { AppService } from './services/app.service';
import { ConfigService } from './services/config.service';
import { HotkeysService } from './services/hotkeys.service';
import { LocaleService } from './services/locale.service';
import 'perfect-scrollbar/css/perfect-scrollbar.css';
export declare function TranslateMessageFormatCompilerFactory(): TranslateMessageFormatCompiler;
/** @hidden */
export default class AppModule {
    locale: LocaleService;
    private translate;
    private profilesService;
    private selector;
    constructor(app: AppService, config: ConfigService, platform: PlatformService, hotkeys: HotkeysService, locale: LocaleService, translate: TranslateService, profilesService: ProfilesService, selector: SelectorService);
    showSelector(provider: ProfileProvider<Profile>): Promise<void>;
    static forRoot(): ModuleWithProviders<AppModule>;
}
export { AppRootComponent as bootstrap };
export * from './api';
export { ToolbarButton as IToolbarButton } from './api';
export { HotkeyDescription as IHotkeyDescription } from './api';
