import { Observable } from 'rxjs';
import { BaseTabComponent } from '../components/baseTab.component';
import { SplitTabComponent } from '../components/splitTab.component';
import { SelectorOption } from '../api/selector';
import { NewTabParameters } from './tabs.service';
export declare class AppService {
    private config;
    private hostApp;
    private hostWindow;
    private tabRecovery;
    private tabsService;
    private selector;
    private bootstrapData;
    tabs: BaseTabComponent[];
    get activeTab(): BaseTabComponent | null;
    private lastTabIndex;
    private _activeTab;
    private closedTabsStack;
    private activeTabChange;
    private tabsChanged;
    private tabOpened;
    private tabRemoved;
    private tabClosed;
    private tabDragActive;
    private ready;
    private recoveryStateChangedHint;
    private completionObservers;
    get activeTabChange$(): Observable<BaseTabComponent | null>;
    get tabOpened$(): Observable<BaseTabComponent>;
    get tabsChanged$(): Observable<void>;
    get tabRemoved$(): Observable<BaseTabComponent>;
    get tabClosed$(): Observable<BaseTabComponent>;
    get tabDragActive$(): Observable<BaseTabComponent | null>;
    /** Fires once when the app is ready */
    get ready$(): Observable<void>;
    /** @hidden */
    private constructor();
    addTabRaw(tab: BaseTabComponent, index?: number | null): void;
    removeTab(tab: BaseTabComponent): void;
    /**
     * Adds a new tab **without** wrapping it in a SplitTabComponent
     * @param inputs  Properties to be assigned on the new tab component instance
     */
    openNewTabRaw<T extends BaseTabComponent>(params: NewTabParameters<T>): T;
    /**
     * Adds a new tab while wrapping it in a SplitTabComponent
     * @param inputs  Properties to be assigned on the new tab component instance
     */
    openNewTab<T extends BaseTabComponent>(params: NewTabParameters<T>): T;
    /**
     * Adds an existing tab while wrapping it in a SplitTabComponent
     */
    wrapAndAddTab(tab: BaseTabComponent): SplitTabComponent;
    reopenLastTab(): Promise<BaseTabComponent | null>;
    selectTab(tab: BaseTabComponent | null): void;
    getParentTab(tab: BaseTabComponent): SplitTabComponent | null;
    /** Switches between the current tab and the previously active one */
    toggleLastTab(): void;
    nextTab(): void;
    previousTab(): void;
    moveSelectedTabLeft(): void;
    moveSelectedTabRight(): void;
    swapTabs(a: BaseTabComponent, b: BaseTabComponent): void;
    /** @hidden */
    emitTabsChanged(): void;
    closeTab(tab: BaseTabComponent, checkCanClose?: boolean): Promise<void>;
    duplicateTab(tab: BaseTabComponent): Promise<BaseTabComponent | null>;
    /**
     * Attempts to close all tabs, returns false if one of the tabs blocked closure
     */
    closeAllTabs(): Promise<boolean>;
    closeWindow(): Promise<void>;
    /** @hidden */
    emitReady(): void;
    /** @hidden */
    emitTabDragStarted(tab: BaseTabComponent): void;
    /** @hidden */
    emitTabDragEnded(): void;
    /**
     * Returns an observable that fires once
     * the tab's internal "process" (see [[BaseTabProcess]]) completes
     */
    observeTabCompletion(tab: BaseTabComponent): Observable<void>;
    stopObservingTabCompletion(tab: BaseTabComponent): void;
    showSelector<T>(name: string, options: SelectorOption<T>[]): Promise<T>;
    explodeTab(tab: SplitTabComponent): SplitTabComponent[];
    combineTabsInto(into: SplitTabComponent): void;
}
