import { TranslateService } from '@ngx-translate/core';
import { NewTabParameters } from './tabs.service';
import { BaseTabComponent } from '../components/baseTab.component';
import { PartialProfile, Profile, ProfileProvider } from '../api/profileProvider';
import { SelectorOption } from '../api/selector';
import { AppService } from './app.service';
import { ConfigService } from './config.service';
import { NotificationsService } from './notifications.service';
import { SelectorService } from './selector.service';
export declare class ProfilesService {
    private app;
    private config;
    private notifications;
    private selector;
    private translate;
    private profileProviders;
    private profileDefaults;
    constructor(app: AppService, config: ConfigService, notifications: NotificationsService, selector: SelectorService, translate: TranslateService, profileProviders: ProfileProvider<Profile>[]);
    openNewTabForProfile<P extends Profile>(profile: PartialProfile<P>): Promise<BaseTabComponent | null>;
    newTabParametersForProfile<P extends Profile>(profile: PartialProfile<P>): Promise<NewTabParameters<BaseTabComponent> | null>;
    getProviders(): ProfileProvider<Profile>[];
    getProfiles(): Promise<PartialProfile<Profile>[]>;
    providerForProfile<T extends Profile>(profile: PartialProfile<T>): ProfileProvider<T> | null;
    getDescription<P extends Profile>(profile: PartialProfile<P>): string | null;
    selectorOptionForProfile<P extends Profile, T>(profile: PartialProfile<P>): SelectorOption<T>;
    getRecentProfiles(): PartialProfile<Profile>[];
    showProfileSelector(): Promise<PartialProfile<Profile> | null>;
    quickConnect(query: string): Promise<PartialProfile<Profile> | null>;
    getConfigProxyForProfile<T extends Profile>(profile: PartialProfile<T>, skipUserDefaults?: boolean): T;
    launchProfile(profile: PartialProfile<Profile>): Promise<void>;
}
