import { NgZone } from '@angular/core';
import { PlatformService, ClipboardContent, MenuItemOptions, MessageBoxOptions, MessageBoxResult, FileUpload, FileDownload, FileUploadOptions, TranslateService } from 'tabby-core';
import { ElectronService } from '../services/electron.service';
import { ElectronHostWindow } from './hostWindow.service';
import { ShellIntegrationService } from './shellIntegration.service';
import { ElectronHostAppService } from './hostApp.service';
export declare class ElectronPlatformService extends PlatformService {
    private hostApp;
    private hostWindow;
    private electron;
    private zone;
    private shellIntegration;
    private translate;
    supportsWindowControls: boolean;
    private configPath;
    constructor(hostApp: ElectronHostAppService, hostWindow: ElectronHostWindow, electron: ElectronService, zone: NgZone, shellIntegration: ShellIntegrationService, translate: TranslateService);
    readClipboard(): string;
    setClipboard(content: ClipboardContent): void;
    installPlugin(name: string, version: string): Promise<void>;
    uninstallPlugin(name: string): Promise<void>;
    isProcessRunning(name: string): Promise<boolean>;
    getWinSCPPath(): string | null;
    exec(app: string, argv: string[]): void;
    isShellIntegrationSupported(): boolean;
    isShellIntegrationInstalled(): Promise<boolean>;
    installShellIntegration(): Promise<void>;
    uninstallShellIntegration(): Promise<void>;
    loadConfig(): Promise<string>;
    saveConfig(content: string): Promise<void>;
    getConfigPath(): string | null;
    showItemInFolder(p: string): void;
    openExternal(url: string): void;
    openPath(p: string): void;
    getOSRelease(): string;
    getAppVersion(): string;
    listFonts(): Promise<string[]>;
    popupContextMenu(menu: MenuItemOptions[], _event?: MouseEvent): void;
    rewrapMenuItemOptions(menu: MenuItemOptions): MenuItemOptions;
    showMessageBox(options: MessageBoxOptions): Promise<MessageBoxResult>;
    quit(): void;
    startUpload(options?: FileUploadOptions, paths?: string[]): Promise<FileUpload[]>;
    startDownload(name: string, mode: number, size: number, filePath?: string): Promise<FileDownload | null>;
    setErrorHandler(handler: (_: any) => void): void;
}
