import { Injector } from '@angular/core';
import { BaseTabProcess, GetRecoveryTokenOptions } from 'tabby-core';
import { BaseTerminalTabComponent } from 'tabby-terminal';
import { LocalProfile, SessionOptions } from '../api';
import { Session } from '../session';
import { UACService } from '../services/uac.service';
/** @hidden */
export declare class TerminalTabComponent extends BaseTerminalTabComponent {
    private uac;
    sessionOptions: SessionOptions;
    profile: LocalProfile;
    session: Session | null;
    constructor(injector: Injector, uac: UACService);
    ngOnInit(): void;
    protected onFrontendReady(): void;
    initializeSession(columns: number, rows: number): void;
    getRecoveryToken(options?: GetRecoveryTokenOptions): Promise<any>;
    getCurrentProcess(): Promise<BaseTabProcess | null>;
    canClose(): Promise<boolean>;
    ngOnDestroy(): void;
}
