/// <reference types="node" />
import { Injector } from '@angular/core';
import { BaseSession } from 'tabby-terminal';
import { SessionOptions, ChildProcess } from './api';
export declare class PTYProxy {
    private id;
    private subscriptions;
    static spawn(...options: any[]): PTYProxy;
    static restore(id: string): PTYProxy | null;
    private constructor();
    getPTYID(): string;
    getPID(): number;
    subscribe(event: string, handler: (..._: any[]) => void): void;
    ackData(length: number): void;
    unsubscribeAll(): void;
    resize(columns: number, rows: number): void;
    write(data: Buffer): void;
    kill(signal?: string): void;
}
/** @hidden */
export declare class Session extends BaseSession {
    private pty;
    private ptyClosed;
    private pauseAfterExit;
    private guessedCWD;
    private initialCWD;
    private config;
    private hostApp;
    private bootstrapData;
    constructor(injector: Injector);
    start(options: SessionOptions): void;
    getPTYID(): string | null;
    resize(columns: number, rows: number): void;
    write(data: Buffer): void;
    kill(signal?: string): void;
    getChildProcesses(): Promise<ChildProcess[]>;
    gracefullyKillProcess(): Promise<void>;
    supportsWorkingDirectory(): boolean;
    getWorkingDirectory(): Promise<string | null>;
    private guessWindowsCWD;
}
