import { NgZone } from '@angular/core';
import { ConfigService, BaseTabComponent, HostAppService, Platform, HomeBaseService, UpdaterService, PlatformService, HostWindowService, AppService, LocaleService, TranslateService } from 'tabby-core';
import { SettingsTabProvider } from '../api';
/** @hidden */
export declare class SettingsTabComponent extends BaseTabComponent {
    config: ConfigService;
    hostApp: HostAppService;
    hostWindow: HostWindowService;
    homeBase: HomeBaseService;
    platform: PlatformService;
    zone: NgZone;
    locale: LocaleService;
    private updater;
    private app;
    settingsProviders: SettingsTabProvider[];
    activeTab: string;
    Platform: typeof Platform;
    configDefaults: any;
    configFile: string;
    isShellIntegrationInstalled: boolean;
    checkingForUpdate: boolean;
    updateAvailable: boolean;
    showConfigDefaults: boolean;
    allLanguages: {
        code: string;
        name: string;
    }[];
    padWindowControls: boolean;
    constructor(config: ConfigService, hostApp: HostAppService, hostWindow: HostWindowService, homeBase: HomeBaseService, platform: PlatformService, zone: NgZone, locale: LocaleService, updater: UpdaterService, app: AppService, settingsProviders: SettingsTabProvider[], translate: TranslateService);
    ngOnInit(): Promise<void>;
    toggleShellIntegration(): Promise<void>;
    ngOnDestroy(): void;
    restartApp(): void;
    saveConfiguration(requireRestart?: boolean): void;
    saveConfigFile(): void;
    showConfigFile(): void;
    isConfigFileValid(): boolean;
    checkForUpdates(): Promise<void>;
    showReleaseNotes(): void;
}
