import { EventEmitter } from '@angular/core';
import { FileUpload, MenuItemOptions, NotificationsService, PlatformService } from 'tabby-core';
import { SFTPSession, SFTPFile } from '../session/sftp';
import { SSHSession } from '../session/ssh';
import { SFTPContextMenuItemProvider } from '../api';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
interface PathSegment {
    name: string;
    path: string;
}
export declare class SFTPPanelComponent {
    private ngbModal;
    private notifications;
    platform: PlatformService;
    protected contextMenuProviders: SFTPContextMenuItemProvider[];
    session: SSHSession;
    closed: EventEmitter<void>;
    sftp: SFTPSession;
    fileList: SFTPFile[] | null;
    path: string;
    pathChange: EventEmitter<string>;
    pathSegments: PathSegment[];
    cwdDetectionAvailable: boolean;
    constructor(ngbModal: NgbModal, notifications: NotificationsService, platform: PlatformService, contextMenuProviders: SFTPContextMenuItemProvider[]);
    ngOnInit(): Promise<void>;
    navigate(newPath: string, fallbackOnError?: boolean): Promise<void>;
    getIcon(item: SFTPFile): string;
    goUp(): void;
    open(item: SFTPFile): Promise<void>;
    openCreateDirectoryModal(): Promise<void>;
    upload(): Promise<void>;
    uploadOne(transfer: FileUpload): Promise<void>;
    download(itemPath: string, mode: number, size: number): Promise<void>;
    getModeString(item: SFTPFile): string;
    buildContextMenu(item: SFTPFile): Promise<MenuItemOptions[]>;
    showContextMenu(item: SFTPFile, event: MouseEvent): Promise<void>;
    get shouldShowCWDTip(): boolean;
    dismissCWDTip(): void;
    close(): void;
}
export {};
