/// <reference types="node" />
import { SSHSession } from '../session/ssh';
import { SSHProfile, SSHProxyStream, SSHProxyStreamSocket } from '../api';
export declare class SSHService {
    private passwordStorage;
    private config;
    private platform;
    private detectedWinSCPPath;
    private constructor();
    getWinSCPPath(): string | undefined;
    getWinSCPURI(profile: SSHProfile, cwd?: string, username?: string): Promise<string>;
    launchWinSCP(session: SSHSession): Promise<void>;
}
export declare class ProxyCommandStream extends SSHProxyStream {
    private command;
    private process;
    constructor(command: string);
    start(): Promise<SSHProxyStreamSocket>;
    requestData(size: number): void;
    consumeInput(data: Buffer): Promise<void>;
    stop(error?: Error): Promise<void>;
}
export declare class SocksProxyStream extends SSHProxyStream {
    private profile;
    private client;
    private header;
    constructor(profile: SSHProfile);
    start(): Promise<SSHProxyStreamSocket>;
    requestData(size: number): void;
    consumeInput(data: Buffer): Promise<void>;
    stop(error?: Error): Promise<void>;
}
export declare class HTTPProxyStream extends SSHProxyStream {
    private profile;
    private client;
    private connected;
    constructor(profile: SSHProfile);
    start(): Promise<SSHProxyStreamSocket>;
    requestData(size: number): void;
    consumeInput(data: Buffer): Promise<void>;
    stop(error?: Error): Promise<void>;
}
