/// <reference types="node" />
import { Observable } from 'rxjs';
import { Injector, NgZone } from '@angular/core';
import { FileDownload, FileUpload } from 'tabby-core';
import { SFTPWrapper } from 'ssh2';
export interface SFTPFile {
    name: string;
    fullPath: string;
    isDirectory: boolean;
    isSymlink: boolean;
    mode: number;
    size: number;
    modified: Date;
}
export declare class SFTPFileHandle {
    private sftp;
    private handle;
    private zone;
    position: number;
    constructor(sftp: SFTPWrapper, handle: Buffer, zone: NgZone);
    read(): Promise<Buffer>;
    write(chunk: Buffer): Promise<void>;
    close(): Promise<void>;
}
export declare class SFTPSession {
    private sftp;
    get closed$(): Observable<void>;
    private closed;
    private zone;
    private logger;
    constructor(sftp: SFTPWrapper, injector: Injector);
    readdir(p: string): Promise<SFTPFile[]>;
    readlink(p: string): Promise<string>;
    stat(p: string): Promise<SFTPFile>;
    open(p: string, mode: string): Promise<SFTPFileHandle>;
    rmdir(p: string): Promise<void>;
    mkdir(p: string): Promise<void>;
    rename(oldPath: string, newPath: string): Promise<void>;
    unlink(p: string): Promise<void>;
    upload(path: string, transfer: FileUpload): Promise<void>;
    download(path: string, transfer: FileDownload): Promise<void>;
    private _makeFile;
}
