/// <reference types="node" />
import { Injector } from '@angular/core';
import { Client, ClientChannel, SFTPWrapper } from 'ssh2';
import { Observable } from 'rxjs';
import { SFTPSession } from './sftp';
import { SSHProfile, SSHProxyStream } from '../api';
import { ForwardedPort } from './forwards';
export interface Prompt {
    prompt: string;
    echo?: boolean;
}
export declare class KeyboardInteractivePrompt {
    name: string;
    instruction: string;
    prompts: Prompt[];
    private callback;
    responses: string[];
    constructor(name: string, instruction: string, prompts: Prompt[], callback: (_: string[]) => void);
    respond(): void;
}
export declare class SSHSession {
    private injector;
    profile: SSHProfile;
    shell?: ClientChannel;
    ssh: Client;
    sftp?: SFTPWrapper;
    forwardedPorts: ForwardedPort[];
    jumpStream: any;
    proxyCommandStream: SSHProxyStream | null;
    savedPassword?: string;
    get serviceMessage$(): Observable<string>;
    get keyboardInteractivePrompt$(): Observable<KeyboardInteractivePrompt>;
    get willDestroy$(): Observable<void>;
    agentPath?: string;
    activePrivateKey: string | null;
    authUsername: string | null;
    open: boolean;
    private logger;
    private refCount;
    private remainingAuthMethods;
    private serviceMessage;
    private keyboardInteractivePrompt;
    private willDestroy;
    private keychainPasswordUsed;
    private hostKeyDigest;
    private passwordStorage;
    private ngbModal;
    private hostApp;
    private platform;
    private notifications;
    private zone;
    private fileProviders;
    private config;
    private translate;
    private knownHosts;
    private privateKeyImporters;
    constructor(injector: Injector, profile: SSHProfile);
    init(): Promise<void>;
    openSFTP(): Promise<SFTPSession>;
    start(): Promise<void>;
    private verifyHostKey;
    emitServiceMessage(msg: string): void;
    emitKeyboardInteractivePrompt(prompt: KeyboardInteractivePrompt): void;
    handleAuth(methodsLeft?: string[] | null): Promise<any>;
    addPortForward(fw: ForwardedPort): Promise<void>;
    removePortForward(fw: ForwardedPort): Promise<void>;
    destroy(): Promise<void>;
    openShellChannel(options: {
        x11: boolean;
    }): Promise<ClientChannel>;
    loadPrivateKey(name: string, privateKeyContents: Buffer): Promise<string | null>;
    parsePrivateKey(privateKey: string): Promise<any>;
    ref(): void;
    unref(): void;
}
