/// <reference types="node" />
import { Observable, Subject } from 'rxjs';
import { NgZone, OnInit, OnDestroy, Injector, ElementRef } from '@angular/core';
import { AnimationTriggerMetadata } from '@angular/animations';
import { AppService, ConfigService, BaseTabComponent, HostAppService, HotkeysService, NotificationsService, LogService, Logger, TabContextMenuItemProvider, MenuItemOptions, PlatformService, HostWindowService, TranslateService } from 'tabby-core';
import { BaseSession } from '../session';
import { Frontend } from '../frontends/frontend';
import { ResizeEvent } from './interfaces';
import { TerminalDecorator } from './decorator';
import { SearchPanelComponent } from '../components/searchPanel.component';
/**
 * A class to base your custom terminal tabs on
 */
export declare class BaseTerminalTabComponent extends BaseTabComponent implements OnInit, OnDestroy {
    protected injector: Injector;
    static template: string;
    static styles: string[];
    static animations: AnimationTriggerMetadata[];
    session: BaseSession | null;
    savedState?: any;
    savedStateIsLive: boolean;
    zoom: number;
    showSearchPanel: boolean;
    /** @hidden */
    content: any;
    /** @hidden */
    backgroundColor: string | null;
    /** @hidden */
    enableToolbar: boolean;
    /** @hidden */
    pinToolbar: boolean;
    /** @hidden */
    revealToolbar: boolean;
    frontend?: Frontend;
    /** @hidden */
    frontendIsReady: boolean;
    frontendReady: Subject<void>;
    size: ResizeEvent;
    /**
     * Enables normall passthrough from session output to terminal input
     */
    enablePassthrough: boolean;
    /**
     * Disables display of dynamic window/tab title provided by the shell
     */
    disableDynamicTitle: boolean;
    alternateScreenActive: boolean;
    searchPanel?: SearchPanelComponent;
    config: ConfigService;
    element: ElementRef;
    protected zone: NgZone;
    protected app: AppService;
    protected hostApp: HostAppService;
    protected hotkeys: HotkeysService;
    protected platform: PlatformService;
    protected notifications: NotificationsService;
    protected log: LogService;
    protected decorators: TerminalDecorator[];
    protected contextMenuProviders: TabContextMenuItemProvider[];
    protected hostWindow: HostWindowService;
    protected translate: TranslateService;
    protected logger: Logger;
    protected output: Subject<string>;
    protected sessionChanged: Subject<BaseSession | null>;
    private bellPlayer;
    private termContainerSubscriptions;
    private allFocusModeSubscription;
    private sessionHandlers;
    private spinner;
    private spinnerActive;
    private spinnerPaused;
    private toolbarRevealTimeout;
    private frontendWriteLock;
    get input$(): Observable<Buffer>;
    get output$(): Observable<string>;
    get resize$(): Observable<ResizeEvent>;
    get alternateScreenActive$(): Observable<boolean>;
    get frontendReady$(): Observable<void>;
    get sessionChanged$(): Observable<BaseSession | null>;
    constructor(injector: Injector);
    /** @hidden */
    ngOnInit(): void;
    protected onFrontendReady(): void;
    buildContextMenu(): Promise<MenuItemOptions[]>;
    /**
     * Feeds input into the active session
     */
    sendInput(data: string | Buffer): void;
    /**
     * Feeds input into the terminal frontend
     */
    write(data: string): Promise<void>;
    protected writeRaw(data: string): Promise<void>;
    paste(): Promise<void>;
    /**
     * Applies the user settings to the terminal
     */
    configure(): void;
    zoomIn(): void;
    zoomOut(): void;
    resetZoom(): void;
    focusAllPanes(): void;
    cancelFocusAllPanes(): void;
    copyCurrentPath(): Promise<void>;
    /** @hidden */
    ngOnDestroy(): void;
    destroy(): Promise<void>;
    protected detachTermContainerHandlers(): void;
    private rightMouseDownTime;
    protected handleRightMouseDown(event: MouseEvent): Promise<void>;
    protected handleRightMouseUp(event: MouseEvent): Promise<void>;
    protected attachTermContainerHandlers(): void;
    setSession(session: BaseSession | null, destroyOnSessionClose?: boolean): void;
    showToolbar(): void;
    hideToolbar(): void;
    togglePinToolbar(): void;
    get hasTitleInset(): boolean;
    protected attachSessionHandler<T>(observable: Observable<T>, handler: (v: T) => void): void;
    protected attachSessionHandlers(destroyOnSessionClose?: boolean): void;
    protected detachSessionHandlers(): void;
    protected startSpinner(text?: string): void;
    protected stopSpinner(): void;
    protected withSpinnerPaused(work: () => any): Promise<void>;
    protected forEachFocusedTerminalPane(cb: (tab: BaseTerminalTabComponent) => void): void;
}
