import { ConfigProvider } from 'tabby-core';
/** @hidden */
export declare class TerminalConfigProvider extends ConfigProvider {
    defaults: {
        hotkeys: {
            'copy-current-path': never[];
        };
        terminal: {
            frontend: string;
            fontSize: number;
            fontWeight: number;
            fontWeightBold: number;
            fallbackFont: null;
            linePadding: number;
            bell: string;
            bracketedPaste: boolean;
            background: string;
            ligatures: boolean;
            cursor: string;
            cursorBlink: boolean;
            hideTabIndex: boolean;
            showTabProfileIcon: boolean;
            hideCloseButton: boolean;
            rightClick: string;
            pasteOnMiddleClick: boolean;
            copyOnSelect: boolean;
            copyAsHTML: boolean;
            scrollOnInput: boolean;
            altIsMeta: boolean;
            wordSeparator: string;
            colorScheme: {
                __nonStructural: boolean;
                name: string;
                foreground: string;
                background: string;
                selection: null;
                cursor: string;
                cursorAccent: null;
                colors: string[];
            };
            customColorSchemes: never[];
            warnOnMultilinePaste: boolean;
            searchRegexAlwaysEnabled: boolean;
            searchOptions: {
                regex: boolean;
                wholeWord: boolean;
                caseSensitive: boolean;
            };
            detectProgress: boolean;
            scrollbackLines: number;
            drawBoldTextInBrightColors: boolean;
            sixel: boolean;
        };
    };
    platformDefaults: {
        macOS: {
            terminal: {
                font: string;
            };
            hotkeys: {
                'ctrl-c': string[];
                copy: string[];
                paste: string[];
                clear: string[];
                'select-all': string[];
                'zoom-in': string[];
                'zoom-out': string[];
                'reset-zoom': string[];
                home: string[];
                end: string[];
                'previous-word': string[];
                'next-word': string[];
                'delete-previous-word': string[];
                'delete-line': string[];
                'delete-next-word': string[];
                search: string[];
                'pane-focus-all': string[];
                'scroll-to-top': string[];
                'scroll-up': string[];
                'scroll-down': string[];
                'scroll-to-bottom': string[];
            };
        };
        Windows: {
            terminal: {
                font: string;
                rightClick: string;
                pasteOnMiddleClick: boolean;
                copyOnSelect: boolean;
            };
            hotkeys: {
                'ctrl-c': string[];
                copy: string[];
                paste: string[];
                'select-all': string[];
                clear: never[];
                'zoom-in': string[];
                'zoom-out': string[];
                'reset-zoom': string[];
                home: string[];
                end: string[];
                'previous-word': string[];
                'next-word': string[];
                'delete-previous-word': string[];
                'delete-line': string[];
                'delete-next-word': string[];
                search: string[];
                'pane-focus-all': string[];
                'scroll-to-top': string[];
                'scroll-up': string[];
                'scroll-down': string[];
                'scroll-to-bottom': string[];
            };
        };
        Linux: {
            terminal: {
                font: string;
                pasteOnMiddleClick: boolean;
            };
            hotkeys: {
                'ctrl-c': string[];
                copy: string[];
                paste: string[];
                'select-all': string[];
                clear: never[];
                'zoom-in': string[];
                'zoom-out': string[];
                'reset-zoom': string[];
                home: string[];
                end: string[];
                'previous-word': string[];
                'next-word': string[];
                'delete-previous-word': string[];
                'delete-line': string[];
                'delete-next-word': string[];
                search: string[];
                'pane-focus-all': string[];
                'scroll-to-top': string[];
                'scroll-up': string[];
                'scroll-down': string[];
                'scroll-to-bottom': string[];
            };
        };
    };
}
