import { Injector } from '@angular/core';
import { Frontend, SearchOptions, SearchState } from './frontend';
import './xterm.css';
/** @hidden */
export declare class XTermFrontend extends Frontend {
    enableResizing: boolean;
    protected xtermCore: any;
    protected enableWebGL: boolean;
    private xterm;
    private element?;
    private configuredFontSize;
    private configuredLinePadding;
    private zoom;
    private resizeHandler;
    private configuredTheme;
    private copyOnSelect;
    private search;
    private searchState;
    private fitAddon;
    private serializeAddon;
    private ligaturesAddon?;
    private webGLAddon?;
    private opened;
    private resizeObserver?;
    private flowControl;
    private configService;
    private hotkeysService;
    private platformService;
    private hostApp;
    constructor(injector: Injector);
    attach(host: HTMLElement): Promise<void>;
    detach(_host: HTMLElement): void;
    destroy(): void;
    getSelection(): string;
    copySelection(): void;
    selectAll(): void;
    clearSelection(): void;
    focus(): void;
    write(data: string): Promise<void>;
    clear(): void;
    visualBell(): void;
    scrollToTop(): void;
    scrollPages(pages: number): void;
    scrollToBottom(): void;
    configure(): void;
    setZoom(zoom: number): void;
    private getSearchOptions;
    private wrapSearchResult;
    findNext(term: string, searchOptions?: SearchOptions): SearchState;
    findPrevious(term: string, searchOptions?: SearchOptions): SearchState;
    cancelSearch(): void;
    saveState(): any;
    restoreState(state: string): void;
    supportsBracketedPaste(): boolean;
    isAlternateScreenActive(): boolean;
    private setFontSize;
    private getSelectionAsHTML;
    private getHexColor;
    private getLineAsHTML;
}
/** @hidden */
export declare class XTermWebGLFrontend extends XTermFrontend {
    protected enableWebGL: boolean;
}
