--[[
BY
 _____   _____   __   _  
|  _  \ /  _  \ |  \ | | 
| | | | | | | | |   \| | 
| | | | | | | | | |\   | 
| |_| | | |_| | | | \  | 
|_____/ \_____/ |_|  \_| 

]]

require "prefabutil"

local assets =
{
	Asset("ANIM", "anim/candy_coin.zip"),
	
    Asset("ATLAS", "images/inventoryimages/doncandycoin.xml"),
    Asset("IMAGE", "images/inventoryimages/doncandycoin.tex"),

}

local function shine(inst)
    if not inst.AnimState:IsCurrentAnimation("sparkle") then
        inst.AnimState:PlayAnimation("sparkle")
        inst.AnimState:PushAnimation("idle", false)
    end
    inst:DoTaskInTime(4 + math.random() * 5, shine)
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)	
	inst.AnimState:SetBank("candycoin")
	inst.AnimState:SetBuild("candycoin")
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
	MakeSnowCoveredPristine(inst)
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("inspectable")
	
	inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/doncandycoin.xml"
    inst.components.inventoryitem:SetOnPickupFn(function()  end)

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM

	shine(inst)
	
    return inst
end

STRINGS.DONCANDYCOIN = "Candy Machine Coin"
STRINGS.NAMES.DONCANDYCOIN = "Candy Machine Coin"
STRINGS.RECIPE_DESC.DONCANDYCOIN = "A coin to be used in the candy machine."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DONCANDYCOIN = "I hope to be in luck today"

return Prefab( "common/inventory/doncandycoin", fn, assets)
