/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat;

import com.android.chimpchat.core.ChimpException;
import com.android.chimpchat.core.ChimpView;
import com.android.chimpchat.core.IChimpView;
import com.android.chimpchat.core.PhysicalButton;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChimpManager {
    private static Logger LOG = Logger.getLogger(ChimpManager.class.getName());
    private Socket monkeySocket;
    private BufferedWriter monkeyWriter;
    private BufferedReader monkeyReader;

    public ChimpManager(Socket monkeySocket) throws IOException {
        this.monkeySocket = monkeySocket;
        this.monkeyWriter = new BufferedWriter(new OutputStreamWriter(monkeySocket.getOutputStream()));
        this.monkeyReader = new BufferedReader(new InputStreamReader(monkeySocket.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.quit();
        }
        finally {
            this.close();
            super.finalize();
        }
    }

    public boolean touchDown(int x, int y) throws IOException {
        return this.sendMonkeyEvent("touch down " + x + " " + y);
    }

    public boolean touchUp(int x, int y) throws IOException {
        return this.sendMonkeyEvent("touch up " + x + " " + y);
    }

    public boolean touchMove(int x, int y) throws IOException {
        return this.sendMonkeyEvent("touch move " + x + " " + y);
    }

    public boolean touch(int x, int y) throws IOException {
        return this.sendMonkeyEvent("tap " + x + " " + y);
    }

    public boolean press(String name) throws IOException {
        return this.sendMonkeyEvent("press " + name);
    }

    public boolean keyDown(String name) throws IOException {
        return this.sendMonkeyEvent("key down " + name);
    }

    public boolean keyUp(String name) throws IOException {
        return this.sendMonkeyEvent("key up " + name);
    }

    public boolean press(PhysicalButton button) throws IOException {
        return this.press(button.getKeyName());
    }

    private String sendMonkeyEventAndGetResponse(String command) throws IOException {
        command = command.trim();
        LOG.info("Monkey Command: " + command + ".");
        this.monkeyWriter.write(command + "\n");
        this.monkeyWriter.flush();
        return this.monkeyReader.readLine();
    }

    private boolean parseResponseForSuccess(String monkeyResponse) {
        if (monkeyResponse == null) {
            return false;
        }
        return monkeyResponse.startsWith("OK");
    }

    private String parseResponseForExtra(String monkeyResponse) {
        int offset = monkeyResponse.indexOf(58);
        if (offset < 0) {
            return "";
        }
        return monkeyResponse.substring(offset + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMonkeyEvent(String command) throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String monkeyResponse = this.sendMonkeyEventAndGetResponse(command);
            return this.parseResponseForSuccess(monkeyResponse);
        }
    }

    public void close() {
        try {
            this.monkeySocket.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to close monkeySocket", e);
        }
        try {
            this.monkeyReader.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to close monkeyReader", e);
        }
        try {
            this.monkeyWriter.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to close monkeyWriter", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariable(String name) throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String response = this.sendMonkeyEventAndGetResponse("getvar " + name);
            if (!this.parseResponseForSuccess(response)) {
                return null;
            }
            return this.parseResponseForExtra(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listVariable() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String response = this.sendMonkeyEventAndGetResponse("listvar");
            if (!this.parseResponseForSuccess(response)) {
                Collections.emptyList();
            }
            String extras = this.parseResponseForExtra(response);
            return Lists.newArrayList((Object[])extras.split(" "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            this.sendMonkeyEventAndGetResponse("done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            try {
                this.sendMonkeyEventAndGetResponse("quit");
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public boolean tap(int x, int y) throws IOException {
        return this.sendMonkeyEvent("tap " + x + " " + y);
    }

    public boolean type(String text) throws IOException {
        StringTokenizer tok = new StringTokenizer(text, "\n", true);
        while (tok.hasMoreTokens()) {
            boolean success;
            String line = tok.nextToken();
            if (!("\n".equals(line) ? !(success = this.press(PhysicalButton.ENTER)) : !(success = this.sendMonkeyEvent("type " + line)))) continue;
            return false;
        }
        return true;
    }

    public boolean type(char keyChar) throws IOException {
        return this.type(Character.toString(keyChar));
    }

    public void wake() throws IOException {
        this.sendMonkeyEvent("wake");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listViewIds() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String response = this.sendMonkeyEventAndGetResponse("listviews");
            if (!this.parseResponseForSuccess(response)) {
                Collections.emptyList();
            }
            String extras = this.parseResponseForExtra(response);
            return Lists.newArrayList((Object[])extras.split(" "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryView(String idType, List<String> ids, String query) throws IOException {
        StringBuilder monkeyCommand = new StringBuilder("queryview " + idType + " ");
        for (String id : ids) {
            monkeyCommand.append(id).append(" ");
        }
        monkeyCommand.append(query);
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String response = this.sendMonkeyEventAndGetResponse(monkeyCommand.toString());
            if (!this.parseResponseForSuccess(response)) {
                throw new ChimpException(this.parseResponseForExtra(response));
            }
            return this.parseResponseForExtra(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChimpView getRootView() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String response = this.sendMonkeyEventAndGetResponse("getrootview");
            String extra = this.parseResponseForExtra(response);
            List<String> ids = Arrays.asList(extra.split(" "));
            if (!this.parseResponseForSuccess(response) || ids.size() != 2) {
                throw new ChimpException(extra);
            }
            ChimpView root = new ChimpView("accessibilityids", ids);
            root.setManager(this);
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getViewsWithText(String text) throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String response;
            if (text.split(" ").length > 1) {
                text = "\"" + text + "\"";
            }
            if (!this.parseResponseForSuccess(response = this.sendMonkeyEventAndGetResponse("getviewswithtext " + text))) {
                throw new ChimpException(this.parseResponseForExtra(response));
            }
            return this.parseResponseForExtra(response);
        }
    }
}

