/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.AddonPackage;
import com.android.sdklib.internal.repository.packages.BuildToolPackage;
import com.android.sdklib.internal.repository.packages.DocPackage;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.License;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.packages.PlatformPackage;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.internal.repository.packages.SamplePackage;
import com.android.sdklib.internal.repository.packages.SystemImagePackage;
import com.android.sdklib.internal.repository.packages.ToolPackage;
import com.android.sdklib.internal.repository.sources.SdkAddonSource;
import com.android.sdklib.internal.repository.sources.SdkRepoSource;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.w3c.dom.Node;

public abstract class Package
implements IDescription,
IListDescription,
Comparable<Package> {
    private final String mObsolete;
    private final License mLicense;
    private final String mListDisplay;
    private final String mDescription;
    private final String mDescUrl;
    @Deprecated
    private final String mReleaseNote;
    @Deprecated
    private final String mReleaseUrl;
    private final Archive[] mArchives;
    private final SdkSource mSource;
    private static final boolean sUsingUnixPerm = SdkConstants.CURRENT_PLATFORM == 3 || SdkConstants.CURRENT_PLATFORM == 1;

    Package(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        this.mSource = source;
        this.mListDisplay = PackageParserUtils.getXmlString(packageNode, "list-display");
        this.mDescription = PackageParserUtils.getXmlString(packageNode, "description");
        this.mDescUrl = PackageParserUtils.getXmlString(packageNode, "desc-url");
        this.mReleaseNote = PackageParserUtils.getXmlString(packageNode, "release-note");
        this.mReleaseUrl = PackageParserUtils.getXmlString(packageNode, "release-url");
        this.mObsolete = PackageParserUtils.getOptionalXmlString(packageNode, "obsolete");
        this.mLicense = this.parseLicense(packageNode, licenses);
        this.mArchives = this.parseArchives(PackageParserUtils.findChildElement(packageNode, "archives"));
    }

    public Package(SdkSource source, Properties props, int revision, String license, String description, String descUrl, String archiveOsPath) {
        if (description == null) {
            description = "";
        }
        if (descUrl == null) {
            descUrl = "";
        }
        this.mLicense = new License(Package.getProperty(props, "Pkg.License", license), Package.getProperty(props, "Pkg.LicenseRef", null));
        this.mListDisplay = Package.getProperty(props, "Pkg.ListDisplay", "");
        this.mDescription = Package.getProperty(props, "Pkg.Desc", description);
        this.mDescUrl = Package.getProperty(props, "Pkg.DescUrl", descUrl);
        this.mReleaseNote = Package.getProperty(props, "Pkg.RelNote", "");
        this.mReleaseUrl = Package.getProperty(props, "Pkg.RelNoteUrl", "");
        this.mObsolete = Package.getProperty(props, "Pkg.Obsolete", null);
        String srcUrl = Package.getProperty(props, "Pkg.SourceUrl", null);
        if (props != null && source == null && srcUrl != null) {
            source = this instanceof AddonPackage || this instanceof ExtraPackage && srcUrl.endsWith("addon.xml") ? new SdkAddonSource(srcUrl, null) : new SdkRepoSource(srcUrl, null);
        }
        this.mSource = source;
        this.mArchives = this.initializeArchives(props, archiveOsPath);
    }

    @NonNull
    public abstract IPkgDesc getPkgDesc();

    protected Archive[] initializeArchives(Properties props, String archiveOsPath) {
        return new Archive[]{new Archive(this, props, archiveOsPath)};
    }

    @Nullable
    static String getProperty(@Nullable Properties props, @NonNull String propKey, @Nullable String defaultValue) {
        return PackageParserUtils.getProperty(props, propKey, defaultValue);
    }

    static int getPropertyInt(@Nullable Properties props, @NonNull String propKey, int defaultValue) {
        return PackageParserUtils.getPropertyInt(props, propKey, defaultValue);
    }

    public void saveProperties(@NonNull Properties props) {
        if (this.mLicense != null) {
            String licenseRef;
            String license = this.mLicense.getLicense();
            if (license != null && license.length() > 0) {
                props.setProperty("Pkg.License", license);
            }
            if ((licenseRef = this.mLicense.getLicenseRef()) != null && licenseRef.length() > 0) {
                props.setProperty("Pkg.LicenseRef", licenseRef);
            }
        }
        if (this.mListDisplay != null && this.mListDisplay.length() > 0) {
            props.setProperty("Pkg.ListDisplay", this.mListDisplay);
        }
        if (this.mDescription != null && this.mDescription.length() > 0) {
            props.setProperty("Pkg.Desc", this.mDescription);
        }
        if (this.mDescUrl != null && this.mDescUrl.length() > 0) {
            props.setProperty("Pkg.DescUrl", this.mDescUrl);
        }
        if (this.mReleaseNote != null && this.mReleaseNote.length() > 0) {
            props.setProperty("Pkg.RelNote", this.mReleaseNote);
        }
        if (this.mReleaseUrl != null && this.mReleaseUrl.length() > 0) {
            props.setProperty("Pkg.RelNoteUrl", this.mReleaseUrl);
        }
        if (this.mObsolete != null) {
            props.setProperty("Pkg.Obsolete", this.mObsolete);
        }
        if (this.mSource != null) {
            props.setProperty("Pkg.SourceUrl", this.mSource.getUrl());
        }
    }

    @Nullable
    private License parseLicense(@NonNull Node packageNode, @NonNull Map<String, String> licenses) {
        Node ref;
        Node usesLicense = PackageParserUtils.findChildElement(packageNode, "uses-license");
        if (usesLicense != null && (ref = usesLicense.getAttributes().getNamedItem("ref")) != null) {
            String licenseRef = ref.getNodeValue();
            return new License(licenses.get(licenseRef), licenseRef);
        }
        return null;
    }

    @NonNull
    private Archive[] parseArchives(@NonNull Node archivesNode) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (archivesNode != null) {
            String nsUri = archivesNode.getNamespaceURI();
            for (Node child = archivesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"archive".equals(child.getLocalName())) continue;
                archives.add(this.parseArchive(child));
            }
        }
        return archives.toArray(new Archive[archives.size()]);
    }

    @NonNull
    private Archive parseArchive(@NonNull Node archiveNode) {
        Archive a = new Archive(this, PackageParserUtils.parseArchFilter(archiveNode), PackageParserUtils.getXmlString(archiveNode, "url"), PackageParserUtils.getXmlLong(archiveNode, "size", 0L), PackageParserUtils.getXmlString(archiveNode, "checksum"));
        return a;
    }

    @Nullable
    public SdkSource getParentSource() {
        return this.mSource;
    }

    public boolean isObsolete() {
        return this.mObsolete != null;
    }

    @NonNull
    public abstract FullRevision getRevision();

    @Nullable
    public License getLicense() {
        return this.mLicense;
    }

    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @NonNull
    public String getListDisplay() {
        return this.mListDisplay;
    }

    @NonNull
    public String getDescUrl() {
        return this.mDescUrl;
    }

    @NonNull
    public String getReleaseNote() {
        return this.mReleaseNote;
    }

    @NonNull
    public String getReleaseNoteUrl() {
        return this.mReleaseUrl;
    }

    @NonNull
    public Archive[] getArchives() {
        return this.mArchives;
    }

    public boolean hasArchive(Archive archive) {
        for (Archive a : this.mArchives) {
            if (a != archive) continue;
            return true;
        }
        return false;
    }

    public boolean hasCompatibleArchive() {
        for (Archive archive : this.mArchives) {
            if (!archive.isCompatible()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public abstract String installId();

    @NonNull
    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    @Override
    @NonNull
    public abstract String getListDescription();

    @Override
    @NonNull
    public abstract String getShortDescription();

    @Override
    @NonNull
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        String s = this.getDescription();
        if (s != null) {
            sb.append(s);
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(String.format("Revision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : ""));
        s = this.getDescUrl();
        if (s != null && s.length() > 0) {
            sb.append(String.format("\n\nMore information at %1$s", s));
        }
        if ((s = this.getReleaseNote()) != null && s.length() > 0) {
            sb.append("\n\nRelease note:\n").append(s);
        }
        if ((s = this.getReleaseNoteUrl()) != null && s.length() > 0) {
            sb.append("\nRelease note URL: ").append(s);
        }
        return sb.toString();
    }

    public boolean isLocal() {
        return this.mArchives.length == 1 && this.mArchives[0].isLocal();
    }

    @NonNull
    public abstract File getInstallFolder(String var1, SdkManager var2);

    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        return true;
    }

    public void postUnzipFileHook(Archive archive, ITaskMonitor monitor, IFileOp fileOp, File unzippedFile, ZipArchiveEntry zipEntry) {
        int mode;
        if (sUsingUnixPerm && fileOp.isFile(unzippedFile) && ((mode = zipEntry.getUnixMode()) & 0x49) != 0) {
            try {
                fileOp.setExecutablePermission(unzippedFile);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
    }

    public abstract boolean sameItemAs(Package var1);

    @NonNull
    public abstract UpdateInfo canBeUpdatedBy(Package var1);

    @Override
    public int compareTo(Package other) {
        String s1 = this.comparisonKey();
        String s2 = other.comparisonKey();
        int r = s1.compareTo(s2);
        return r;
    }

    @NonNull
    protected String comparisonKey() {
        StringBuilder sb = new StringBuilder();
        sb.append("t:");
        if (this instanceof ToolPackage) {
            sb.append(0);
        } else if (this instanceof PlatformToolPackage) {
            sb.append(1);
        } else if (this instanceof BuildToolPackage) {
            sb.append(2);
        } else if (this instanceof DocPackage) {
            sb.append(3);
        } else if (this instanceof PlatformPackage) {
            sb.append(4);
        } else if (this instanceof SamplePackage) {
            sb.append(5);
        } else if (this instanceof SystemImagePackage && ((SystemImagePackage)this).isPlatform()) {
            sb.append(6);
        } else if (this instanceof AddonPackage) {
            sb.append(7);
        } else if (this instanceof SystemImagePackage) {
            sb.append(8);
        } else {
            sb.append(9);
        }
        sb.append("|v:");
        if (this instanceof IAndroidVersionProvider) {
            AndroidVersion v = ((IAndroidVersionProvider)((Object)this)).getAndroidVersion();
            sb.append(String.format("%1$04d.%2$d", 10000 - v.getApiLevel(), v.isPreview() ? 1 : 0));
        }
        sb.append("|r:");
        FullRevision rev = this.getRevision();
        sb.append(String.format("%1$04d.%2$04d.%3$04d.", rev.getMajor(), rev.getMinor(), rev.getMicro()));
        if (rev.isPreview()) {
            sb.append(rev.getPreview());
        } else {
            sb.append('0');
        }
        sb.append('|');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mArchives);
        result = 31 * result + (this.mObsolete == null ? 0 : this.mObsolete.hashCode());
        result = 31 * result + this.getRevision().hashCode();
        result = 31 * result + (this.mSource == null ? 0 : this.mSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Package)) {
            return false;
        }
        Package other = (Package)obj;
        if (!Arrays.equals(this.mArchives, other.mArchives)) {
            return false;
        }
        if (this.mObsolete == null ? other.mObsolete != null : !this.mObsolete.equals(other.mObsolete)) {
            return false;
        }
        if (!this.getRevision().equals(other.getRevision())) {
            return false;
        }
        return !(this.mSource == null ? other.mSource != null : !this.mSource.equals(other.mSource));
    }

    public static enum UpdateInfo {
        INCOMPATIBLE,
        NOT_UPDATE,
        UPDATE;

    }
}

