/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AnnotationMethodDeclarationTemplate;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Comment;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.JavadocContainer;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeMemberMixin;
import lombok.ast.TypeReference;

public class AnnotationMethodDeclaration
extends AbstractNode
implements TypeMember,
DescribedNode,
JavadocContainer {
    private AbstractNode javadoc = null;
    private AbstractNode modifiers = this.adopt(new Modifiers());
    private AbstractNode returnTypeReference = null;
    private AbstractNode methodName = this.adopt(new Identifier());
    private AbstractNode defaultValue = null;

    @Override
    public TypeBody upToTypeBody() {
        if (!(this.getParent() instanceof TypeBody)) {
            return null;
        }
        TypeBody out = (TypeBody)this.getParent();
        if (!out.rawMembers().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public AnnotationMethodDeclaration astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public AnnotationMethodDeclaration rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    public Modifiers astModifiers() {
        if (!(this.modifiers instanceof Modifiers)) {
            return null;
        }
        return (Modifiers)this.modifiers;
    }

    public AnnotationMethodDeclaration astModifiers(Modifiers modifiers) {
        return this.rawModifiers(modifiers);
    }

    private AnnotationMethodDeclaration rawModifiers(Node modifiers) {
        if (modifiers == this.modifiers) {
            return this;
        }
        if (modifiers != null) {
            this.adopt((AbstractNode)modifiers);
        }
        if (this.modifiers != null) {
            this.disown(this.modifiers);
        }
        this.modifiers = (AbstractNode)modifiers;
        return this;
    }

    public TypeReference astReturnTypeReference() {
        if (!(this.returnTypeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.returnTypeReference;
    }

    public AnnotationMethodDeclaration astReturnTypeReference(TypeReference returnTypeReference) {
        if (returnTypeReference == null) {
            throw new NullPointerException("returnTypeReference is mandatory");
        }
        return this.rawReturnTypeReference(returnTypeReference);
    }

    public Node rawReturnTypeReference() {
        return this.returnTypeReference;
    }

    public AnnotationMethodDeclaration rawReturnTypeReference(Node returnTypeReference) {
        if (returnTypeReference == this.returnTypeReference) {
            return this;
        }
        if (returnTypeReference != null) {
            this.adopt((AbstractNode)returnTypeReference);
        }
        if (this.returnTypeReference != null) {
            this.disown(this.returnTypeReference);
        }
        this.returnTypeReference = (AbstractNode)returnTypeReference;
        return this;
    }

    public Identifier astMethodName() {
        if (!(this.methodName instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.methodName;
    }

    public AnnotationMethodDeclaration astMethodName(Identifier methodName) {
        return this.rawMethodName(methodName);
    }

    private AnnotationMethodDeclaration rawMethodName(Node methodName) {
        if (methodName == this.methodName) {
            return this;
        }
        if (methodName != null) {
            this.adopt((AbstractNode)methodName);
        }
        if (this.methodName != null) {
            this.disown(this.methodName);
        }
        this.methodName = (AbstractNode)methodName;
        return this;
    }

    public Expression astDefaultValue() {
        if (!(this.defaultValue instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.defaultValue);
    }

    public AnnotationMethodDeclaration astDefaultValue(Expression defaultValue) {
        return this.rawDefaultValue(defaultValue);
    }

    public Node rawDefaultValue() {
        return this.defaultValue;
    }

    public AnnotationMethodDeclaration rawDefaultValue(Node defaultValue) {
        if (defaultValue == this.defaultValue) {
            return this;
        }
        if (defaultValue != null) {
            this.adopt((AbstractNode)defaultValue);
        }
        if (this.defaultValue != null) {
            this.disown(this.defaultValue);
        }
        this.defaultValue = (AbstractNode)defaultValue;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        if (this.modifiers != null) {
            result.add(this.modifiers);
        }
        if (this.returnTypeReference != null) {
            result.add(this.returnTypeReference);
        }
        if (this.methodName != null) {
            result.add(this.methodName);
        }
        if (this.defaultValue != null) {
            result.add(this.defaultValue);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.modifiers == original) {
            if (replacement instanceof Modifiers) {
                this.astModifiers((Modifiers)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Modifiers", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.returnTypeReference == original) {
            this.rawReturnTypeReference(replacement);
            return true;
        }
        if (this.methodName == original) {
            if (replacement instanceof Identifier) {
                this.astMethodName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.defaultValue == original) {
            this.rawDefaultValue(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.modifiers == child) {
            this.disown((AbstractNode)child);
            this.modifiers = null;
            return true;
        }
        if (this.returnTypeReference == child) {
            this.disown((AbstractNode)child);
            this.returnTypeReference = null;
            return true;
        }
        if (this.methodName == child) {
            this.disown((AbstractNode)child);
            this.methodName = null;
            return true;
        }
        if (this.defaultValue == child) {
            this.disown((AbstractNode)child);
            this.defaultValue = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAnnotationMethodDeclaration(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        if (this.modifiers != null) {
            this.modifiers.accept(visitor);
        }
        if (this.returnTypeReference != null) {
            this.returnTypeReference.accept(visitor);
        }
        if (this.methodName != null) {
            this.methodName.accept(visitor);
        }
        if (this.defaultValue != null) {
            this.defaultValue.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public AnnotationMethodDeclaration copy() {
        AnnotationMethodDeclaration result = new AnnotationMethodDeclaration();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        if (this.modifiers != null) {
            result.rawModifiers(this.modifiers.copy());
        }
        if (this.returnTypeReference != null) {
            result.rawReturnTypeReference(this.returnTypeReference.copy());
        }
        if (this.methodName != null) {
            result.rawMethodName(this.methodName.copy());
        }
        if (this.defaultValue != null) {
            result.rawDefaultValue(this.defaultValue.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return AnnotationMethodDeclarationTemplate.getDescription(this);
    }

    public TypeDeclaration upUpToTypeDeclaration() {
        return TypeMemberMixin.upUpToTypeDeclaration(this);
    }
}

