/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.ArrayCreation;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.Node;

public class ArrayDimension
extends AbstractNode {
    private AbstractNode dimension = null;

    public ArrayCreation upToArrayCreation() {
        if (!(this.getParent() instanceof ArrayCreation)) {
            return null;
        }
        ArrayCreation out = (ArrayCreation)this.getParent();
        if (!out.rawDimensions().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astDimension() {
        if (!(this.dimension instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.dimension);
    }

    public ArrayDimension astDimension(Expression dimension) {
        return this.rawDimension(dimension);
    }

    public Node rawDimension() {
        return this.dimension;
    }

    public ArrayDimension rawDimension(Node dimension) {
        if (dimension == this.dimension) {
            return this;
        }
        if (dimension != null) {
            this.adopt((AbstractNode)dimension);
        }
        if (this.dimension != null) {
            this.disown(this.dimension);
        }
        this.dimension = (AbstractNode)dimension;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.dimension != null) {
            result.add(this.dimension);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.dimension == original) {
            this.rawDimension(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.dimension == child) {
            this.disown((AbstractNode)child);
            this.dimension = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitArrayDimension(this)) {
            return;
        }
        if (this.dimension != null) {
            this.dimension.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ArrayDimension copy() {
        ArrayDimension result = new ArrayDimension();
        if (this.dimension != null) {
            result.rawDimension(this.dimension.copy());
        }
        return result;
    }
}

